/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.logs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.SequenceInputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.openide.util.NbBundle;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class LogRecords {
    private static final Logger LOG = Logger.getLogger(LogRecords.class.getName());

    private LogRecords() {
    }

    public static void scan(InputStream inputStream, Handler handler) throws IOException {
        Object object;
        Object object2;
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 32);
        byte[] byArray = new byte[5];
        int n = pushbackInputStream.read(byArray);
        if (n == -1) {
            return;
        }
        pushbackInputStream.unread(byArray, 0, n);
        if (byArray[0] == 31 && byArray[1] == -117) {
            n = (pushbackInputStream = new PushbackInputStream(new GZIPInputStream(pushbackInputStream), 32)).read(byArray);
            if (n == -1) {
                return;
            }
            pushbackInputStream.unread(byArray, 0, n);
        }
        if (byArray[0] == 60 && byArray[1] == 63 && byArray[2] == 120 && byArray[3] == 109 && byArray[4] == 108) {
            inputStream = pushbackInputStream;
        } else {
            object2 = new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?><uigestures version='1.0'>".getBytes());
            object = new ByteArrayInputStream("</uigestures>".getBytes());
            inputStream = new SequenceInputStream(new SequenceInputStream((InputStream)object2, pushbackInputStream), (InputStream)object);
        }
        object2 = SAXParserFactory.newInstance();
        ((SAXParserFactory)object2).setValidating(false);
        try {
            try {
                ((SAXParserFactory)object2).setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                LOG.log(Level.INFO, null, sAXNotRecognizedException);
            }
            object = ((SAXParserFactory)object2).newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            LOG.log(Level.SEVERE, null, parserConfigurationException);
            throw (IOException)new IOException(parserConfigurationException.getMessage()).initCause(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            LOG.log(Level.SEVERE, null, sAXException);
            throw (IOException)new IOException(sAXException.getMessage()).initCause(sAXException);
        }
        Parser parser = new Parser(handler);
        try {
            ((SAXParser)object).parse(inputStream, (DefaultHandler)parser);
        }
        catch (SAXException sAXException) {
            LOG.log(Level.WARNING, null, sAXException);
            throw (IOException)new IOException(sAXException.getMessage()).initCause(sAXException);
        }
        catch (InternalError internalError) {
            LOG.log(Level.WARNING, "Input file corruption", internalError);
            throw (IOException)new IOException(internalError.getMessage()).initCause(internalError);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            LOG.log(Level.WARNING, "Input file corruption", runtimeException);
        }
    }

    static Level parseLevel(String string) {
        return "USER".equals(string) ? Level.SEVERE : Level.parse(string);
    }

    private static final class FakeException
    extends Exception {
        final List<StackTraceElement> trace = new ArrayList<StackTraceElement>();
        Map<Parser.Elem, String> values;
        String message;
        int more;

        public FakeException(Map<Parser.Elem, String> map) {
            this.values = map;
            this.more = 0;
        }

        @Override
        public StackTraceElement[] getStackTrace() {
            return this.trace.toArray(new StackTraceElement[0]);
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        public int getMore() {
            return this.more;
        }

        @Override
        public String toString() {
            return this.message;
        }
    }

    private static final class FakeBundle
    extends ResourceBundle {
        private String key;
        private String value;

        public FakeBundle(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        @Override
        protected Object handleGetObject(String string) {
            if (this.key.equals(string)) {
                return this.value;
            }
            return null;
        }

        @Override
        public Enumeration<String> getKeys() {
            return Collections.enumeration(Collections.singleton(this.key));
        }
    }

    private static final class Parser
    extends DefaultHandler {
        private Handler callback;
        private Map<Elem, String> values = new EnumMap<Elem, String>(Elem.class);
        private Elem current;
        private FakeException currentEx;
        private Queue<FakeException> exceptions;
        private List<String> params;
        private StringBuilder chars = new StringBuilder();
        private int fatalErrors;

        public Parser(Handler handler) {
            this.callback = handler;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
            this.callback.flush();
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "uri: {0} localName: {1} qName: {2} atts: {3}", new Object[]{string, string2, string3, attributes});
            }
            try {
                this.current = Elem.valueOf(string3.toUpperCase());
                if (this.current == Elem.EXCEPTION) {
                    this.currentEx = new FakeException(new EnumMap<Elem, String>(this.values));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOG.log(Level.FINE, "Uknown tag " + string3, illegalArgumentException);
                this.current = null;
            }
            this.chars = new StringBuilder();
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            Iterator<String> iterator;
            String string4;
            if (this.current != null) {
                string4 = this.chars.toString();
                this.values.put(this.current, string4);
                if (this.current == Elem.PARAM) {
                    if (this.params == null) {
                        this.params = new ArrayList<String>();
                    }
                    this.params.add(string4);
                    if (this.params.size() > 1500) {
                        LOG.severe("Too long params when reading a record. Deleting few. Msg: " + Elem.MESSAGE.parse(this.values));
                        for (String string5 : this.params) {
                            LOG.fine(string5);
                        }
                        this.params.clear();
                    }
                }
            }
            this.current = null;
            this.chars = new StringBuilder();
            if (this.currentEx != null && this.currentEx.values != null) {
                if ("frame".equals(string3)) {
                    string4 = Elem.LINE.parse(this.values);
                    iterator = new StackTraceElement(Elem.CLASS.parse(this.values), Elem.METHOD.parse(this.values), Elem.FILE.parse(this.values), string4 == null ? -1 : Integer.parseInt(string4));
                    this.currentEx.trace.add((StackTraceElement)((Object)iterator));
                    this.values.remove((Object)Elem.CLASS);
                    this.values.remove((Object)Elem.METHOD);
                    this.values.remove((Object)Elem.LINE);
                }
                if ("exception".equals(string3)) {
                    this.currentEx.message = this.values.get((Object)Elem.MESSAGE);
                    string4 = this.values.get((Object)Elem.MORE);
                    if (string4 != null) {
                        this.currentEx.more = Integer.parseInt(string4);
                    }
                    if (this.exceptions == null) {
                        this.exceptions = new ArrayDeque<FakeException>();
                    }
                    this.exceptions.add(this.currentEx);
                    this.values = this.currentEx.values;
                    this.currentEx = null;
                }
                return;
            }
            if ("record".equals(string3)) {
                String string5;
                string4 = Elem.MILLIS.parse(this.values);
                iterator = Elem.SEQUENCE.parse(this.values);
                string5 = Elem.LEVEL.parse(this.values);
                String string6 = Elem.THREAD.parse(this.values);
                String string7 = Elem.MESSAGE.parse(this.values);
                String string8 = Elem.KEY.parse(this.values);
                String string9 = Elem.CATALOG.parse(this.values);
                if (string5 != null) {
                    LogRecord logRecord = new LogRecord(LogRecords.parseLevel(string5), string8 != null && string9 != null ? string8 : string7);
                    try {
                        logRecord.setThreadID(this.parseInt(string6));
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOG.log(Level.WARNING, numberFormatException.getMessage(), numberFormatException);
                    }
                    logRecord.setSequenceNumber(this.parseLong((String)((Object)iterator)));
                    logRecord.setMillis(this.parseLong(string4));
                    logRecord.setResourceBundleName(string8);
                    if (string9 != null && string8 != null) {
                        logRecord.setResourceBundleName(string9);
                        if (!"<null>".equals(string9)) {
                            try {
                                ResourceBundle resourceBundle = NbBundle.getBundle((String)string9);
                                resourceBundle.getObject(string8);
                                logRecord.setResourceBundle(resourceBundle);
                            }
                            catch (MissingResourceException missingResourceException) {
                                LOG.log(Level.CONFIG, "Cannot find resource bundle {0} for key {1}", new Object[]{string9, string8});
                                logRecord.setResourceBundle(new FakeBundle(string8, string7));
                            }
                        } else {
                            LOG.log(Level.CONFIG, "Cannot find resource bundle <null> for key {1}", string8);
                        }
                    }
                    if (this.params != null) {
                        logRecord.setParameters(this.params.toArray());
                    }
                    if (this.exceptions != null) {
                        logRecord.setThrown(this.createThrown(null));
                    }
                    this.callback.publish(logRecord);
                }
                this.currentEx = null;
                this.params = null;
                this.values.clear();
            }
        }

        private long parseLong(String string) {
            if (string == null) {
                return 0L;
            }
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
                return 0L;
            }
        }

        private int parseInt(String string) {
            if (string == null) {
                return 0;
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LOG.log(Level.INFO, numberFormatException.getMessage(), numberFormatException);
                return 0;
            }
        }

        private FakeException createThrown(FakeException fakeException) {
            StackTraceElement[] stackTraceElementArray;
            if (this.exceptions.size() == 0) {
                return null;
            }
            FakeException fakeException2 = this.exceptions.poll();
            if (fakeException2 != null && fakeException2.getMore() != 0) {
                assert (fakeException != null) : "IF MORE IS NOT 0, LAST MUST BE SET NOT NULL";
                stackTraceElementArray = fakeException.getStackTrace();
                for (int i = stackTraceElementArray.length - fakeException2.getMore(); i < stackTraceElementArray.length; ++i) {
                    fakeException2.trace.add(stackTraceElementArray[i]);
                }
            }
            stackTraceElementArray = this.createThrown(fakeException2);
            fakeException2.initCause((Throwable)stackTraceElementArray);
            return fakeException2;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.chars.append(cArray, n, n2);
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            if (this.fatalErrors++ > 1000) {
                throw sAXParseException;
            }
        }

        private static enum Elem {
            UIGESTURES,
            RECORD,
            DATE,
            MILLIS,
            SEQUENCE,
            LEVEL,
            THREAD,
            MESSAGE,
            KEY,
            PARAM,
            FRAME,
            CLASS,
            METHOD,
            LOGGER,
            EXCEPTION,
            LINE,
            CATALOG,
            MORE,
            FILE;


            public String parse(Map<Elem, String> map) {
                String string = map.get((Object)this);
                return string;
            }
        }
    }
}

