/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.sa;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class SAObject {
    final Object instance;
    Map<String, List<Method>> methodCache;
    private static Map<Class, Class> primitiveTypes = new HashMap<Class, Class>();

    SAObject(Object i) {
        this.instance = i;
        if (i != null) {
            this.methodCache = new HashMap<String, List<Method>>();
            Method[] methods = i.getClass().getMethods();
            for (int j = 0; j < methods.length; ++j) {
                List<Method> mlist;
                int pars;
                Method method = methods[j];
                String name = method.getName();
                String id = SAObject.methodId(name, pars = method.getParameterTypes().length);
                List<Method> oldlist = this.methodCache.put(id, mlist = Collections.singletonList(method));
                if (oldlist == null) continue;
                ArrayList<Method> unitedList = new ArrayList<Method>(mlist);
                unitedList.addAll(oldlist);
                this.methodCache.put(id, unitedList);
            }
        }
    }

    boolean isNull() {
        return this.instance == null;
    }

    Object invoke(String methodName, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
        String mid = SAObject.methodId(methodName, parameters.length);
        List<Method> methods = this.methodCache.get(mid);
        Method method = null;
        if (methods == null) {
            throw new IllegalAccessException("No method " + mid);
        }
        if (methods.size() == 1) {
            method = methods.get(0);
        } else {
            Object[] parClasses = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Class cl = parameters[i].getClass();
                if (primitiveTypes.containsKey(cl)) {
                    cl = primitiveTypes.get(cl);
                }
                parClasses[i] = cl;
            }
            for (Method m : methods) {
                if (!Arrays.deepEquals(m.getParameterTypes(), parClasses)) continue;
                method = m;
                break;
            }
        }
        if (method == null) {
            throw new IllegalArgumentException(this.instance + " " + methodName + " " + Arrays.toString(parameters));
        }
        return method.invoke(this.instance, parameters);
    }

    SAObject invokeSA(String methodName, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
        return new SAObject(this.invoke(methodName, parameters));
    }

    private static String methodId(String name, int pars) {
        return name.concat("#").concat(Integer.toString(pars));
    }

    public String toString() {
        if (this.instance != null) {
            return this.instance.toString();
        }
        return "<null>";
    }

    public int hashCode() {
        if (this.instance == null) {
            return 0;
        }
        return this.instance.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SAObject) {
            SAObject saobj = (SAObject)obj;
            if (this.instance == null) {
                return saobj.instance == null;
            }
            return this.instance.equals(saobj.instance);
        }
        return false;
    }

    static {
        primitiveTypes.put(Integer.class, Integer.TYPE);
    }
}

