/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.awt.datatransfer.Transferable;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectPool;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.LoaderTransfer;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;

abstract class DataTransferSupport {
    private static final Logger err = Logger.getLogger("org.openide.loaders.DataTransferSupport");

    DataTransferSupport() {
    }

    protected abstract PasteTypeExt[] definePasteTypes(int var1);

    protected abstract int[] defineOperations();

    protected void handleCreatePasteTypes(Transferable transferable, List<PasteType> list) {
    }

    public final void createPasteTypes(Transferable transferable, List<PasteType> list) {
        int[] nArray = this.defineOperations();
        for (int i = 0; i < nArray.length; ++i) {
            DataObject[] dataObjectArray = LoaderTransfer.getDataObjects(transferable, nArray[i]);
            if (dataObjectArray == null || dataObjectArray.length == 0) continue;
            PasteTypeExt[] pasteTypeExtArray = this.definePasteTypes(nArray[i]);
            for (int j = 0; j < pasteTypeExtArray.length; ++j) {
                pasteTypeExtArray[j].setDataObjects(dataObjectArray);
                if (!pasteTypeExtArray[j].canPaste()) continue;
                list.add(pasteTypeExtArray[j]);
            }
        }
        this.handleCreatePasteTypes(transferable, list);
    }

    static class InstantiatePaste
    extends PasteType {
        private InstanceCookie cookie;
        private DataFolder target;

        public InstantiatePaste(DataFolder dataFolder, InstanceCookie instanceCookie) {
            this.cookie = instanceCookie;
            this.target = dataFolder;
        }

        public String getName() {
            return DataObject.getString("PT_instance");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(InstantiatePaste.class);
        }

        public final Transferable paste() throws IOException {
            try {
                Class clazz = this.cookie.instanceClass();
                InstanceDataObject.create(this.getTargetFolder(), null, clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.getMessage());
            }
            return null;
        }

        protected DataFolder getTargetFolder() throws IOException {
            return this.target;
        }
    }

    static class SerializePaste
    extends PasteType {
        private InstanceCookie cookie;
        private DataFolder target;

        public SerializePaste(DataFolder dataFolder, InstanceCookie instanceCookie) {
            this.cookie = instanceCookie;
            this.target = dataFolder;
        }

        public String getName() {
            return DataObject.getString("PT_serialize");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(SerializePaste.class);
        }

        public final Transferable paste() throws IOException {
            final DataFolder dataFolder = this.getTargetFolder();
            String string = this.cookie.instanceName();
            int n = string.lastIndexOf(46) + 1;
            if (n != 0 && n != string.length()) {
                string = string.substring(n);
            }
            string = FileUtil.findFreeFileName((FileObject)dataFolder.getPrimaryFile(), (String)string, (String)"ser");
            final NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(DataObject.getString("SerializeBean_Text"), DataObject.getString("SerializeBean_Title"));
            inputLine.setInputText(string);
            if (NotifyDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine)) {
                DataObjectPool.getPOOL().runAtomicAction(dataFolder.getPrimaryFile(), new FileSystem.AtomicAction(){

                    public void run() throws IOException {
                        FileObject fileObject = dataFolder.getPrimaryFile().createData(inputLine.getInputText(), "ser");
                        FileLock fileLock = fileObject.lock();
                        ObjectOutputStream objectOutputStream = null;
                        try {
                            objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileObject.getOutputStream(fileLock)));
                            objectOutputStream.writeObject(SerializePaste.this.cookie.instanceCreate());
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new IOException(classNotFoundException.getMessage());
                        }
                        finally {
                            if (objectOutputStream != null) {
                                objectOutputStream.close();
                            }
                            fileLock.releaseLock();
                        }
                    }
                });
            }
            return null;
        }

        protected DataFolder getTargetFolder() throws IOException {
            return this.target;
        }
    }

    static abstract class PasteTypeExt
    extends PasteType {
        private static final RequestProcessor RP = new RequestProcessor("Paste Support");
        private DataObject[] objs;

        protected abstract boolean handleCanPaste(DataObject var1);

        protected abstract void handlePaste(DataObject var1) throws IOException;

        protected boolean cleanClipboard() {
            return false;
        }

        public final boolean canPaste() {
            for (int i = 0; i < this.objs.length; ++i) {
                if (this.handleCanPaste(this.objs[i])) continue;
                return false;
            }
            return true;
        }

        public final Transferable paste() throws IOException {
            if (SwingUtilities.isEventDispatchThread()) {
                RP.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        String string = Actions.cutAmpersand((String)PasteTypeExt.this.getName());
                        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
                        progressHandle.start();
                        progressHandle.switchToIndeterminate();
                        try {
                            PasteTypeExt.this.doPaste();
                        }
                        catch (IOException iOException) {
                            Exceptions.printStackTrace((Throwable)iOException);
                        }
                        finally {
                            progressHandle.finish();
                        }
                    }
                });
            } else {
                this.doPaste();
            }
            return this.cleanClipboard() ? ExTransferable.EMPTY : null;
        }

        private void doPaste() throws IOException {
            if (err.isLoggable(Level.FINE)) {
                err.log(Level.FINE, null, new Throwable("Issue #58666: Called " + (Object)((Object)this) + " doPaste() on objects " + Arrays.asList(this.objs)));
            }
            for (int i = 0; i < this.objs.length; ++i) {
                this.handlePaste(this.objs[i]);
            }
        }

        public final void setDataObjects(DataObject[] dataObjectArray) {
            this.objs = dataObjectArray;
        }
    }
}

