/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public enum SigningAlgorithm {
    HmacSHA1,
    HmacSHA256;

    private final ThreadLocal<Mac> macReference;

    private SigningAlgorithm() {
        final String algorithmName = this.toString();
        this.macReference = new ThreadLocal<Mac>(){

            @Override
            protected Mac initialValue() {
                try {
                    return Mac.getInstance(algorithmName);
                }
                catch (NoSuchAlgorithmException e2) {
                    throw new AmazonClientException("Unable to fetch Mac instance for Algorithm " + algorithmName + e2.getMessage(), e2);
                }
            }
        };
    }

    public Mac getMac() {
        return this.macReference.get();
    }
}

