/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.log.InternalLogFactory;
import com.amazonaws.util.Base64Codec;
import com.amazonaws.util.CodecUtils;
import javax.xml.bind.DatatypeConverter;

public enum Base64 {

    private static final Base64Codec codec = new Base64Codec();

    public static String encodeAsString(byte ... bytes2) {
        if (bytes2 == null) {
            return null;
        }
        try {
            return DatatypeConverter.printBase64Binary((byte[])bytes2);
        }
        catch (NullPointerException ex) {
            InternalLogFactory.getLog(Base64.class).debug("Recovering from JAXB bug: https://netbeans.org/bugzilla/show_bug.cgi?id=224923", ex);
            return bytes2.length == 0 ? "" : CodecUtils.toStringDirect(codec.encode(bytes2));
        }
    }

    public static byte[] encode(byte[] bytes2) {
        return bytes2 == null || bytes2.length == 0 ? bytes2 : codec.encode(bytes2);
    }

    public static byte[] decode(String b64) {
        if (b64 == null) {
            return null;
        }
        if (b64.length() == 0) {
            return new byte[0];
        }
        byte[] buf = new byte[b64.length()];
        int len = CodecUtils.sanitize(b64, buf);
        return codec.decode(buf, len);
    }

    public static byte[] decode(byte[] b64) {
        return b64 == null || b64.length == 0 ? b64 : codec.decode(b64, b64.length);
    }
}

