/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeKey;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSource;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSource;

final class CompositeValuesComparator {
    private final int size;
    private final CompositeValuesSource<?, ?>[] arrays;
    private boolean topValueSet = false;

    CompositeValuesComparator(IndexReader reader, CompositeValuesSourceConfig[] sources, int size) {
        this.size = size;
        this.arrays = new CompositeValuesSource[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            ValuesSource vs;
            int reverseMul = sources[i].reverseMul();
            if (sources[i].valuesSource() instanceof ValuesSource.Bytes.WithOrdinals && reader instanceof DirectoryReader) {
                vs = (ValuesSource.Bytes.WithOrdinals)sources[i].valuesSource();
                this.arrays[i] = CompositeValuesSource.wrapGlobalOrdinals((ValuesSource.Bytes.WithOrdinals)vs, size, reverseMul);
                continue;
            }
            if (sources[i].valuesSource() instanceof ValuesSource.Bytes) {
                vs = (ValuesSource.Bytes)sources[i].valuesSource();
                this.arrays[i] = CompositeValuesSource.wrapBinary((ValuesSource.Bytes)vs, size, reverseMul);
                continue;
            }
            if (!(sources[i].valuesSource() instanceof ValuesSource.Numeric)) continue;
            vs = (ValuesSource.Numeric)sources[i].valuesSource();
            this.arrays[i] = ((ValuesSource.Numeric)vs).isFloatingPoint() ? CompositeValuesSource.wrapDouble((ValuesSource.Numeric)vs, size, reverseMul) : CompositeValuesSource.wrapLong((ValuesSource.Numeric)vs, size, reverseMul);
        }
    }

    void move(int slot1, int slot2) {
        assert (slot1 < this.size && slot2 < this.size);
        for (int i = 0; i < this.arrays.length; ++i) {
            this.arrays[i].move(slot1, slot2);
        }
    }

    int compare(int slot1, int slot2) {
        assert (slot1 < this.size && slot2 < this.size);
        for (int i = 0; i < this.arrays.length; ++i) {
            int cmp = this.arrays[i].compare(slot1, slot2);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    boolean hasTop() {
        return this.topValueSet;
    }

    void setTop(Comparable<?>[] values) {
        assert (values.length == this.arrays.length);
        this.topValueSet = true;
        for (int i = 0; i < this.arrays.length; ++i) {
            this.arrays[i].setTop(values[i]);
        }
    }

    int compareTop(int slot) {
        assert (slot < this.size);
        for (int i = 0; i < this.arrays.length; ++i) {
            int cmp = this.arrays[i].compareTop(slot);
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    CompositeKey toCompositeKey(int slot) throws IOException {
        assert (slot < this.size);
        Comparable[] values = new Comparable[this.arrays.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.arrays[i].toComparable(slot);
        }
        return new CompositeKey(values);
    }

    CompositeValuesSource.Collector getLeafCollector(LeafReaderContext context, CompositeValuesSource.Collector in) throws IOException {
        int last = this.arrays.length - 1;
        CompositeValuesSource.Collector next = this.arrays[last].getLeafCollector(context, in);
        for (int i = last - 1; i >= 0; --i) {
            next = this.arrays[i].getLeafCollector(context, next);
        }
        return next;
    }
}

