/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.util.LongHash;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.internal.SearchContext;

public class LongTermsAggregator
extends TermsAggregator {
    protected final ValuesSource.Numeric valuesSource;
    protected final LongHash bucketOrds;
    private boolean showTermDocCountError;
    private IncludeExclude.LongFilter longFilter;

    public LongTermsAggregator(String name, AggregatorFactories factories, ValuesSource.Numeric valuesSource, DocValueFormat format, BucketOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, SearchContext aggregationContext, Aggregator parent, Aggregator.SubAggCollectionMode subAggCollectMode, boolean showTermDocCountError, IncludeExclude.LongFilter longFilter, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, aggregationContext, parent, bucketCountThresholds, order, format, subAggCollectMode, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.showTermDocCountError = showTermDocCountError;
        this.longFilter = longFilter;
        this.bucketOrds = new LongHash(1L, aggregationContext.bigArrays());
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores() || super.needsScores();
    }

    protected SortedNumericDocValues getValues(ValuesSource.Numeric valuesSource, LeafReaderContext ctx) throws IOException {
        return valuesSource.longValues(ctx);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedNumericDocValues values = this.getValues(this.valuesSource, ctx);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrdinal) throws IOException {
                assert (owningBucketOrdinal == 0L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    long previous = Long.MAX_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long val = values.nextValue();
                        if (previous == val && i != 0) continue;
                        if (LongTermsAggregator.this.longFilter == null || LongTermsAggregator.this.longFilter.accept(val)) {
                            long bucketOrdinal = LongTermsAggregator.this.bucketOrds.add(val);
                            if (bucketOrdinal < 0L) {
                                bucketOrdinal = -1L - bucketOrdinal;
                                LongTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                            } else {
                                LongTermsAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                            }
                        }
                        previous = val;
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        int i;
        assert (owningBucketOrdinal == 0L);
        if (!(this.bucketCountThresholds.getMinDocCount() != 0L || InternalOrder.isCountDesc(this.order) && this.bucketOrds.size() >= (long)this.bucketCountThresholds.getRequiredSize())) {
            for (LeafReaderContext ctx : this.context.searcher().getTopReaderContext().leaves()) {
                SortedNumericDocValues values = this.getValues(this.valuesSource, ctx);
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    if (!values.advanceExact(docId)) continue;
                    int valueCount = values.docValueCount();
                    for (int i2 = 0; i2 < valueCount; ++i2) {
                        long value = values.nextValue();
                        if (this.longFilter != null && !this.longFilter.accept(value)) continue;
                        this.bucketOrds.add(value);
                    }
                }
            }
        }
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        long otherDocCount = 0L;
        BucketPriorityQueue<MultiBucketsAggregation.Bucket> ordered = new BucketPriorityQueue<MultiBucketsAggregation.Bucket>(size, this.order.comparator(this));
        LongTerms.Bucket spare = null;
        for (long i3 = 0L; i3 < this.bucketOrds.size(); ++i3) {
            if (spare == null) {
                spare = new LongTerms.Bucket(0L, 0L, null, this.showTermDocCountError, 0L, this.format);
            }
            spare.term = this.bucketOrds.get(i3);
            spare.docCount = this.bucketDocCount(i3);
            otherDocCount += spare.docCount;
            spare.bucketOrd = i3;
            if (this.bucketCountThresholds.getShardMinDocCount() > spare.docCount) continue;
            spare = (LongTerms.Bucket)ordered.insertWithOverflow(spare);
        }
        LongTerms.Bucket[] list = new LongTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (i = ordered.size() - 1; i >= 0; --i) {
            LongTerms.Bucket bucket = (LongTerms.Bucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            list[i] = bucket;
            otherDocCount -= bucket.docCount;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (i = 0; i < list.length; ++i) {
            list[i].aggregations = this.bucketAggregations(list[i].bucketOrd);
            list[i].docCountError = 0L;
        }
        return new LongTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.pipelineAggregators(), this.metaData(), this.format, this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, Arrays.asList(list), 0L);
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new LongTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.pipelineAggregators(), this.metaData(), this.format, this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, 0L, Collections.emptyList(), 0L);
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

