/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.spatial4j;

import org.apache.lucene.spatial.spatial4j.Geo3dPointShape;
import org.apache.lucene.spatial.spatial4j.Geo3dShape;
import org.apache.lucene.spatial3d.geom.GeoCircle;
import org.apache.lucene.spatial3d.geom.GeoCircleFactory;
import org.apache.lucene.spatial3d.geom.GeoPointShapeFactory;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class Geo3dCircleShape
extends Geo3dShape<GeoCircle>
implements Circle {
    public Geo3dCircleShape(GeoCircle shape, SpatialContext spatialcontext) {
        super(shape, spatialcontext);
    }

    public void reset(double x, double y, double radiusDEG) {
        this.shape = GeoCircleFactory.makeGeoCircle((PlanetModel)((GeoCircle)this.shape).getPlanetModel(), (double)(y * (Math.PI / 180)), (double)(x * (Math.PI / 180)), (double)(radiusDEG * (Math.PI / 180)));
        this.center = null;
        this.boundingBox = null;
    }

    public double getRadius() {
        return ((GeoCircle)this.shape).getRadius() * 57.29577951308232;
    }

    @Override
    public Point getCenter() {
        Point center = this.center;
        if (center == null) {
            this.center = center = new Geo3dPointShape(GeoPointShapeFactory.makeGeoPointShape((PlanetModel)((GeoCircle)this.shape).getPlanetModel(), (double)((GeoCircle)this.shape).getCenter().getLatitude(), (double)((GeoCircle)this.shape).getCenter().getLongitude()), this.spatialcontext);
        }
        return center;
    }

    @Override
    public SpatialRelation relate(Shape other) {
        if (((GeoCircle)this.shape).getPlanetModel() != PlanetModel.SPHERE && other instanceof Point) {
            if (this.spatialcontext.getDistCalc().distance((Point)other, this.getCenter()) <= this.getRadius()) {
                return SpatialRelation.CONTAINS;
            }
            return SpatialRelation.DISJOINT;
        }
        return super.relate(other);
    }
}

