/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.DefaultLifecycles;
import org.apache.maven.lifecycle.MissingProjectException;
import org.apache.maven.lifecycle.NoGoalSpecifiedException;
import org.apache.maven.lifecycle.internal.BuildListCalculator;
import org.apache.maven.lifecycle.internal.ConcurrencyDependencyGraph;
import org.apache.maven.lifecycle.internal.ExecutionEventCatapult;
import org.apache.maven.lifecycle.internal.LifecycleDebugLogger;
import org.apache.maven.lifecycle.internal.LifecycleModuleBuilder;
import org.apache.maven.lifecycle.internal.LifecycleTaskSegmentCalculator;
import org.apache.maven.lifecycle.internal.LifecycleThreadedBuilder;
import org.apache.maven.lifecycle.internal.LifecycleWeaveBuilder;
import org.apache.maven.lifecycle.internal.ProjectBuildList;
import org.apache.maven.lifecycle.internal.ProjectIndex;
import org.apache.maven.lifecycle.internal.ProjectSegment;
import org.apache.maven.lifecycle.internal.ReactorBuildStatus;
import org.apache.maven.lifecycle.internal.ReactorContext;
import org.apache.maven.lifecycle.internal.TaskSegment;
import org.apache.maven.lifecycle.internal.ThreadConfigurationService;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=LifecycleStarter.class)
public class LifecycleStarter {
    @Requirement
    private ExecutionEventCatapult eventCatapult;
    @Requirement
    private DefaultLifecycles defaultLifeCycles;
    @Requirement
    private Logger logger;
    @Requirement
    private LifecycleModuleBuilder lifecycleModuleBuilder;
    @Requirement
    private LifecycleWeaveBuilder lifeCycleWeaveBuilder;
    @Requirement
    private LifecycleThreadedBuilder lifecycleThreadedBuilder;
    @Requirement
    private BuildListCalculator buildListCalculator;
    @Requirement
    private LifecycleDebugLogger lifecycleDebugLogger;
    @Requirement
    private LifecycleTaskSegmentCalculator lifecycleTaskSegmentCalculator;
    @Requirement
    private ThreadConfigurationService threadConfigService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MavenSession session) {
        block11: {
            this.eventCatapult.fire(ExecutionEvent.Type.SessionStarted, session, null);
            MavenExecutionResult result = session.getResult();
            try {
                if (!session.isUsingPOMsFromFilesystem() && this.lifecycleTaskSegmentCalculator.requiresProject(session)) {
                    throw new MissingProjectException("The goal you specified requires a project to execute but there is no POM in this directory (" + session.getExecutionRootDirectory() + ")." + " Please verify you invoked Maven from the correct directory.");
                }
                MavenExecutionRequest executionRequest = session.getRequest();
                boolean isThreaded = executionRequest.isThreadConfigurationPresent();
                session.setParallel(isThreaded);
                List<TaskSegment> taskSegments = this.lifecycleTaskSegmentCalculator.calculateTaskSegments(session);
                ProjectBuildList projectBuilds = this.buildListCalculator.calculateProjectBuilds(session, taskSegments);
                if (projectBuilds.isEmpty()) {
                    throw new NoGoalSpecifiedException("No goals have been specified for this build. You must specify a valid lifecycle phase or a goal in the format <plugin-prefix>:<goal> or <plugin-group-id>:<plugin-artifact-id>[:<plugin-version>]:<goal>. Available lifecycle phases are: " + this.defaultLifeCycles.getLifecyclePhaseList() + ".");
                }
                ProjectIndex projectIndex = new ProjectIndex(session.getProjects());
                if (this.logger.isDebugEnabled()) {
                    this.lifecycleDebugLogger.debugReactorPlan(projectBuilds);
                }
                ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
                ReactorBuildStatus reactorBuildStatus = new ReactorBuildStatus(session.getProjectDependencyGraph());
                ReactorContext callableContext = new ReactorContext(result, projectIndex, oldContextClassLoader, reactorBuildStatus);
                if (isThreaded) {
                    ExecutorService executor = this.threadConfigService.getExecutorService(executionRequest.getThreadCount(), executionRequest.isPerCoreThreadCount(), session.getProjects().size());
                    try {
                        boolean isWeaveMode = LifecycleWeaveBuilder.isWeaveMode(executionRequest);
                        if (isWeaveMode) {
                            this.lifecycleDebugLogger.logWeavePlan(session);
                            this.lifeCycleWeaveBuilder.build(projectBuilds, callableContext, taskSegments, session, executor, reactorBuildStatus);
                        } else {
                            ConcurrencyDependencyGraph analyzer = new ConcurrencyDependencyGraph(projectBuilds, session.getProjectDependencyGraph());
                            ExecutorCompletionService<ProjectSegment> service = new ExecutorCompletionService<ProjectSegment>(executor);
                            this.lifecycleThreadedBuilder.build(session, callableContext, projectBuilds, taskSegments, analyzer, service);
                        }
                        break block11;
                    }
                    finally {
                        executor.shutdown();
                        executor.awaitTermination(5L, TimeUnit.SECONDS);
                    }
                }
                this.singleThreadedBuild(session, callableContext, projectBuilds, taskSegments, reactorBuildStatus);
            }
            catch (Exception e) {
                result.addException(e);
            }
        }
        this.eventCatapult.fire(ExecutionEvent.Type.SessionEnded, session, null);
    }

    private void singleThreadedBuild(MavenSession session, ReactorContext callableContext, ProjectBuildList projectBuilds, List<TaskSegment> taskSegments, ReactorBuildStatus reactorBuildStatus) {
        block2: for (TaskSegment taskSegment : taskSegments) {
            for (ProjectSegment projectBuild : projectBuilds.getByTaskSegment(taskSegment)) {
                try {
                    this.lifecycleModuleBuilder.buildProject(session, callableContext, projectBuild.getProject(), taskSegment);
                    if (!reactorBuildStatus.isHalted()) continue;
                }
                catch (Exception e) {}
                continue block2;
            }
        }
    }
}

