/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.reflect.PropertyAccessorType;
import org.gradle.model.internal.manage.schema.extract.PropertyAccessorExtractionContext;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelPropertyExtractionContext {
    private final String propertyName;
    private Map<PropertyAccessorType, PropertyAccessorExtractionContext> accessors;

    public ModelPropertyExtractionContext(String propertyName) {
        this.propertyName = propertyName;
        this.accessors = Maps.newEnumMap(PropertyAccessorType.class);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isReadable() {
        return PropertyAccessorType.hasGetter(this.accessors.keySet());
    }

    public boolean isWritable() {
        return PropertyAccessorType.hasSetter(this.accessors.keySet());
    }

    public void addAccessor(PropertyAccessorExtractionContext accessor) {
        PropertyAccessorType type = accessor.getAccessorType();
        this.accessors.put(type, accessor);
    }

    @Nullable
    public PropertyAccessorExtractionContext getAccessor(PropertyAccessorType type) {
        return this.accessors.get(type);
    }

    public Collection<PropertyAccessorExtractionContext> getAccessors() {
        return this.accessors.values();
    }

    public void dropInvalidAccessor(PropertyAccessorType type, ImmutableCollection.Builder<Method> droppedMethods) {
        PropertyAccessorExtractionContext removedAccessor = this.accessors.remove(type);
        if (removedAccessor != null) {
            droppedMethods.add((Object)removedAccessor.getMostSpecificDeclaration());
        }
    }

    public Set<ModelType<?>> getDeclaredBy() {
        ImmutableSortedSet.Builder declaredBy = new ImmutableSortedSet.Builder((Comparator)Ordering.usingToString());
        for (PropertyAccessorExtractionContext accessor : this.accessors.values()) {
            for (Method method : accessor.getDeclaringMethods()) {
                declaredBy.add(ModelType.declaringType(method));
            }
        }
        return declaredBy.build();
    }

    @Nullable
    public PropertyAccessorExtractionContext mergeGetters() {
        PropertyAccessorExtractionContext getGetter = this.getAccessor(PropertyAccessorType.GET_GETTER);
        PropertyAccessorExtractionContext isGetter = this.getAccessor(PropertyAccessorType.IS_GETTER);
        if (getGetter == null && isGetter == null) {
            return null;
        }
        Collection<Object> getMethods = getGetter != null ? getGetter.getDeclaringMethods() : Collections.emptyList();
        Collection<Object> isMethods = isGetter != null ? isGetter.getDeclaringMethods() : Collections.emptyList();
        return new PropertyAccessorExtractionContext(PropertyAccessorType.GET_GETTER, Iterables.concat(getMethods, isMethods));
    }
}

