/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInferenceHelper;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSessionContainer;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiGraphInferenceHelper
implements PsiInferenceHelper {
    private final PsiManager myManager;

    public PsiGraphInferenceHelper(PsiManager manager) {
        this.myManager = manager;
    }

    @Override
    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy) {
        PsiSubstitutor substitutor2;
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeForMethodTypeParameter"));
        }
        if (parent2 != null) {
            substitutor2 = this.inferTypeArguments(new PsiTypeParameter[]{typeParameter}, parameters2, arguments2, partialSubstitutor, parent2, policy, PsiUtil.getLanguageLevel(parent2));
        } else {
            InferenceSession inferenceSession = new InferenceSession(new PsiTypeParameter[]{typeParameter}, partialSubstitutor, this.myManager, null);
            inferenceSession.initExpressionConstraints(parameters2, arguments2, null);
            substitutor2 = inferenceSession.infer();
        }
        return substitutor2.substitute(typeParameter);
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters2, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments2, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent2, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        if (typeParameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (partialSubstitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "partialSubstitutor", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (parent2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (typeParameters2.length == 0) {
            PsiSubstitutor psiSubstitutor = partialSubstitutor;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = InferenceSessionContainer.infer(typeParameters2, parameters2, arguments2, partialSubstitutor, parent2, policy);
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    @NotNull
    public PsiSubstitutor inferTypeArguments(@NotNull PsiTypeParameter[] typeParameters2, @NotNull PsiType[] leftTypes, @NotNull PsiType[] rightTypes, @NotNull LanguageLevel languageLevel) {
        if (typeParameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (leftTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftTypes", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (rightTypes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightTypes", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        if (typeParameters2.length == 0) {
            PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        InferenceSession session = new InferenceSession(typeParameters2, leftTypes, rightTypes, PsiSubstitutor.EMPTY, this.myManager, null);
        for (PsiType leftType : leftTypes) {
            if (session.isProperType(session.substituteWithInferenceVariables(leftType))) continue;
            PsiSubstitutor psiSubstitutor = session.infer();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        for (PsiType rightType : rightTypes) {
            if (session.isProperType(session.substituteWithInferenceVariables(rightType))) continue;
            PsiSubstitutor psiSubstitutor = session.infer();
            if (psiSubstitutor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
            }
            return psiSubstitutor;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        if (psiSubstitutor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/graphInference/PsiGraphInferenceHelper", "inferTypeArguments"));
        }
        return psiSubstitutor;
    }

    @Override
    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        PsiTypeParameter[] psiTypeParameterArray;
        PsiType[] rightTypes;
        PsiType[] leftTypes;
        if (PsiType.VOID.equals(arg) || PsiType.VOID.equals(param)) {
            return PsiType.NULL;
        }
        if (param instanceof PsiArrayType && arg instanceof PsiArrayType) {
            return this.getSubstitutionForTypeParameter(typeParam, ((PsiArrayType)param).getComponentType(), ((PsiArrayType)arg).getComponentType(), isContraVariantPosition, languageLevel);
        }
        if (!(param instanceof PsiClassType)) {
            return PsiType.NULL;
        }
        if (arg == null) {
            return PsiType.NULL;
        }
        if (isContraVariantPosition) {
            leftTypes = new PsiType[]{param};
            rightTypes = new PsiType[]{arg};
        } else {
            leftTypes = new PsiType[]{arg};
            rightTypes = new PsiType[]{param};
        }
        PsiTypeParameterListOwner owner = typeParam.getOwner();
        if (owner != null) {
            psiTypeParameterArray = owner.getTypeParameters();
        } else {
            PsiTypeParameter[] psiTypeParameterArray2 = new PsiTypeParameter[1];
            psiTypeParameterArray = psiTypeParameterArray2;
            psiTypeParameterArray2[0] = typeParam;
        }
        PsiTypeParameter[] typeParams = psiTypeParameterArray;
        InferenceSession inferenceSession = new InferenceSession(typeParams, leftTypes, rightTypes, PsiSubstitutor.EMPTY, this.myManager, null);
        if (inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(param)) && inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(arg))) {
            boolean proceed = false;
            for (PsiClassType classType : typeParam.getExtendsListTypes()) {
                if (inferenceSession.isProperType(inferenceSession.substituteWithInferenceVariables(classType))) continue;
                proceed = true;
                break;
            }
            if (!proceed) {
                return PsiType.NULL;
            }
        }
        PsiSubstitutor substitutor2 = inferenceSession.infer();
        return substitutor2.substitute(typeParam);
    }
}

