require 'msf/core'
require 'msf/core/exploit'
require 'rex/proto/http/response'
require 'msf/core/exploit/http/joomla'

RSpec.describe Msf::Exploit::Remote::HTTP::Joomla::Version do
  subject do
    mod = ::Msf::Exploit.new
    mod.extend ::Msf::Exploit::Remote::HTTP::Joomla
    mod.send(:initialize)
    mod
  end

  # From /joomla/language/en-GB/en-GB.xml
  let(:joomla_body) do
    %Q|
    <?xml version="1.0" encoding="utf-8"?>
    <metafile version="3.4" client="site">
    <name>English (en-GB)</name>
    <version>3.4.3</version>
    <creationDate>2013-03-07</creationDate>
    <author>Joomla! Project</author>
    <authorEmail>admin@joomla.org</authorEmail>
    <authorUrl>www.joomla.org</authorUrl>
    <copyright>Copyright (C) 2005 - 2015 Open Source Matters. All rights reserved.</copyright>
    <license>GNU General Public License version 2 or later; see LICENSE.txt</license>
    <description>en-GB site language</description>
    <metadata>
    <name>English (en-GB)</name>
    <tag>en-GB</tag>
    <rtl>0</rtl>
    <locale>en_GB.utf8, en_GB.UTF-8, en_GB, eng_GB, en, english, english-uk, uk, gbr, britain, england, great britain, uk, united kingdom, united-kingdom</locale>
    <firstDay>0</firstDay>
    <weekEnd>0,6</weekEnd>
    </metadata>
    <params />
    </metafile>
    |
  end

  let(:expected_version) do
    '3.4.3'
  end

  let(:version_file) do
    '/joomla/language/en-GB/en-GB.xml'
  end

  let(:rex_http_response) do
    res = Rex::Proto::Http::Response.new
    res.code = 200
    res.body = joomla_body
    res
  end

  before(:example) do
    allow(subject).to receive(:send_request_cgi) do |opts|
      rex_http_response
    end
  end

  describe '#joomla_version' do
    context 'When a version file is found' do
      it { expect(subject.joomla_version).to eq(expected_version) }
    end
  end

  describe '#fingerprint' do
    context 'When a version is found' do
      it { expect(subject.send(:fingerprint, rex_http_response)).to eq(expected_version) }
    end
  end

  describe '#check_file_version' do
    context 'When a version is found' do
      it { expect(subject.send(:check_file_version, version_file)).to eq(expected_version) }
    end
  end
end
