/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbEditablePanel;
import org.jetbrains.plugins.ipnb.editor.panels.IpnbFilePanel;
import org.jetbrains.plugins.ipnb.format.cells.IpnbCodeCell;

public class IpnbAddCellBelowAction
extends AnAction {
    private final IpnbFileEditor myFileEditor;

    public IpnbAddCellBelowAction(IpnbFileEditor fileEditor) {
        super("Insert Cell Below", "Insert Cell Below", AllIcons.General.Add);
        this.myFileEditor = fileEditor;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(61, 128);
        this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), this.myFileEditor.getIpnbFilePanel());
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            IpnbAddCellBelowAction.$$$reportNull$$$0(0);
        }
        IpnbAddCellBelowAction.addCell(this.myFileEditor.getIpnbFilePanel());
    }

    private static void addCell(@NotNull IpnbFilePanel ipnbFilePanel) {
        if (ipnbFilePanel == null) {
            IpnbAddCellBelowAction.$$$reportNull$$$0(1);
        }
        ipnbFilePanel.executeUndoableCommand(() -> {
            if (ipnbFilePanel == null) {
                IpnbAddCellBelowAction.$$$reportNull$$$0(2);
            }
            ipnbFilePanel.createAndAddCell(true, IpnbCodeCell.createEmptyCodeCell());
            ipnbFilePanel.saveToFile(false);
        }, "Create cell");
    }

    public void update(AnActionEvent e) {
        IpnbEditablePanel panel = this.myFileEditor.getIpnbFilePanel().getSelectedCellPanel();
        if (panel != null && panel.isEditing()) {
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setEnabled(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ipnbFilePanel";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/actions/IpnbAddCellBelowAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addCell";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$addCell$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

