/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.execution.CantRunException;
import com.intellij.execution.CommandLineWrapperUtil;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.JarUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.lang.UrlClassLoader;
import gnu.trove.THashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkUtil {
    public static final Key<Map<String, String>> COMMAND_LINE_CONTENT = Key.create((String)"command.line.content");
    public static final String PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL = "idea.do.not.escape.classpath.url";
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.JdkUtil");
    private static final String WRAPPER_CLASS = "com.intellij.rt.execution.CommandLineWrapper";

    private JdkUtil() {
    }

    @Nullable
    public static String getJdkMainAttribute(@NotNull Sdk jdk, @NotNull Attributes.Name attribute) {
        File signatureJar;
        String homePath;
        String versionString;
        if (jdk == null) {
            JdkUtil.$$$reportNull$$$0(0);
        }
        if (attribute == null) {
            JdkUtil.$$$reportNull$$$0(1);
        }
        if (attribute == Attributes.Name.IMPLEMENTATION_VERSION && (versionString = jdk.getVersionString()) != null) {
            int start = versionString.indexOf(34);
            int end = versionString.lastIndexOf(34);
            if (start >= 0 && end > start) {
                return versionString.substring(start + 1, end);
            }
        }
        if ((homePath = jdk.getHomePath()) != null && (signatureJar = FileUtil.findFirstThatExist((String[])new String[]{homePath + "/jre/lib/rt.jar", homePath + "/lib/rt.jar", homePath + "/lib/jrt-fs.jar", homePath + "/jre/lib/vm.jar", homePath + "/../Classes/classes.jar"})) != null) {
            return JarUtil.getJarAttribute((File)signatureJar, (Attributes.Name)attribute);
        }
        return null;
    }

    public static boolean checkForJdk(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(2);
        }
        return JdkUtil.checkForJdk(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJdk(@NotNull File homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(3);
        }
        return (new File(homePath, "bin/javac").isFile() || new File(homePath, "bin/javac.exe").isFile()) && JdkUtil.checkForRuntime(homePath.getAbsolutePath());
    }

    public static boolean checkForJre(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(4);
        }
        return JdkUtil.checkForJre(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean checkForJre(@NotNull File homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(5);
        }
        return new File(homePath, "bin/java").isFile() || new File(homePath, "bin/java.exe").isFile();
    }

    public static boolean checkForRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(6);
        }
        return new File(homePath, "jre/lib/rt.jar").exists() || new File(homePath, "lib/rt.jar").exists() || JdkUtil.isModularRuntime(homePath) || new File(homePath, "../Classes/classes.jar").exists() || new File(homePath, "jre/lib/vm.jar").exists() || new File(homePath, "classes").isDirectory();
    }

    public static boolean isModularRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(7);
        }
        return JdkUtil.isModularRuntime(new File(FileUtil.toSystemDependentName((String)homePath)));
    }

    public static boolean isModularRuntime(@NotNull File homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(8);
        }
        return new File(homePath, "lib/jrt-fs.jar").isFile() || JdkUtil.isExplodedModularRuntime(homePath.getPath());
    }

    public static boolean isExplodedModularRuntime(@NotNull String homePath) {
        if (homePath == null) {
            JdkUtil.$$$reportNull$$$0(9);
        }
        return new File(homePath, "modules/java.base").isDirectory();
    }

    public static GeneralCommandLine setupJVMCommandLine(@NotNull SimpleJavaParameters javaParameters) throws CantRunException {
        Sdk jdk;
        if (javaParameters == null) {
            JdkUtil.$$$reportNull$$$0(10);
        }
        if ((jdk = javaParameters.getJdk()) == null) {
            throw new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0]));
        }
        SdkTypeId type = jdk.getSdkType();
        if (!(type instanceof JavaSdkType)) {
            throw new CantRunException(ExecutionBundle.message("run.configuration.error.no.jdk.specified", new Object[0]));
        }
        String exePath = ((JavaSdkType)((Object)type)).getVMExecutablePath(jdk);
        if (exePath == null) {
            throw new CantRunException(ExecutionBundle.message("run.configuration.cannot.find.vm.executable", new Object[0]));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(exePath);
        JdkUtil.setupCommandLine(commandLine, javaParameters);
        return commandLine;
    }

    private static void setupCommandLine(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters) throws CantRunException {
        commandLine.withWorkDirectory(javaParameters.getWorkingDirectory());
        commandLine.withEnvironment(javaParameters.getEnv());
        commandLine.withParentEnvironmentType(javaParameters.isPassParentEnvs() ? GeneralCommandLine.ParentEnvironmentType.CONSOLE : GeneralCommandLine.ParentEnvironmentType.NONE);
        ParametersList vmParameters = javaParameters.getVMParametersList();
        boolean dynamicClasspath = javaParameters.isDynamicClasspath();
        boolean dynamicVMOptions = dynamicClasspath && javaParameters.isDynamicVMOptions() && JdkUtil.useDynamicVMOptions();
        boolean dynamicParameters = dynamicClasspath && javaParameters.isDynamicParameters() && JdkUtil.useDynamicParameters();
        boolean dynamicMainClass = false;
        if (dynamicClasspath) {
            Class commandLineWrapper;
            if (javaParameters.isArgFile()) {
                JdkUtil.setArgFileParams(commandLine, javaParameters, vmParameters, dynamicVMOptions, dynamicParameters);
                dynamicMainClass = dynamicParameters;
            } else if (!JdkUtil.explicitClassPath(vmParameters) && javaParameters.getJarPath() == null && (commandLineWrapper = JdkUtil.getCommandLineWrapperClass()) != null) {
                if (javaParameters.isUseClasspathJar()) {
                    JdkUtil.setClasspathJarParams(commandLine, javaParameters, vmParameters, commandLineWrapper, dynamicVMOptions, dynamicParameters);
                } else if (javaParameters.isClasspathFile()) {
                    JdkUtil.setCommandLineWrapperParams(commandLine, javaParameters, vmParameters, commandLineWrapper, dynamicVMOptions, dynamicParameters);
                }
            } else {
                dynamicParameters = false;
                dynamicClasspath = false;
            }
        }
        if (!dynamicClasspath) {
            JdkUtil.appendParamsEncodingClasspath(javaParameters, commandLine, vmParameters);
        }
        if (!dynamicMainClass) {
            commandLine.addParameters(JdkUtil.getMainClassParams(javaParameters));
        }
        if (!dynamicParameters) {
            commandLine.addParameters(javaParameters.getProgramParametersList().getList());
        }
    }

    private static boolean explicitClassPath(ParametersList vmParameters) {
        return vmParameters.hasParameter("-cp") || vmParameters.hasParameter("-classpath") || vmParameters.hasParameter("--class-path");
    }

    private static boolean explicitModulePath(ParametersList vmParameters) {
        return vmParameters.hasParameter("-p") || vmParameters.hasParameter("--module-path");
    }

    private static void setArgFileParams(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters, ParametersList vmParameters, boolean dynamicVMOptions, boolean dynamicParameters) throws CantRunException {
        try {
            File argFile = FileUtil.createTempFile((String)"idea_arg_file", null);
            try (PrintWriter writer = new PrintWriter(argFile);){
                PathsList modulePath;
                if (dynamicVMOptions) {
                    for (String param : vmParameters.getList()) {
                        writer.print(JdkUtil.quoteArg(param));
                        writer.print('\n');
                    }
                } else {
                    commandLine.addParameters(vmParameters.getList());
                }
                PathsList classPath = javaParameters.getClassPath();
                if (!classPath.isEmpty() && !JdkUtil.explicitClassPath(vmParameters)) {
                    writer.print("-classpath\n");
                    writer.print(JdkUtil.quoteArg(classPath.getPathsString()));
                    writer.print('\n');
                }
                if (!(modulePath = javaParameters.getModulePath()).isEmpty() && !JdkUtil.explicitModulePath(vmParameters)) {
                    writer.print("-p\n");
                    writer.print(JdkUtil.quoteArg(modulePath.getPathsString()));
                    writer.print('\n');
                }
                if (dynamicParameters) {
                    for (String parameter : JdkUtil.getMainClassParams(javaParameters)) {
                        writer.print(JdkUtil.quoteArg(parameter));
                        writer.print('\n');
                    }
                    for (String parameter : javaParameters.getProgramParametersList().getList()) {
                        writer.print(JdkUtil.quoteArg(parameter));
                        writer.print('\n');
                    }
                }
            }
            commandLine.putUserData(COMMAND_LINE_CONTENT, ContainerUtil.stringMap((String[])new String[]{argFile.getAbsolutePath(), FileUtil.loadFile((File)argFile)}));
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            commandLine.addParameter("@" + argFile.getAbsolutePath());
            OSProcessHandler.deleteFileOnTermination(commandLine, argFile);
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    private static String quoteArg(String arg) {
        if (StringUtil.containsAnyChar((String)arg, (String)" \"\n\r\t\f") || arg.endsWith("\\") || arg.startsWith("#")) {
            StringBuilder sb = new StringBuilder(arg.length() * 2);
            sb.append('\"');
            block8: for (int i = 0; i < arg.length(); ++i) {
                char c = arg.charAt(i);
                switch (c) {
                    case '\n': {
                        sb.append("\\n");
                        continue block8;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block8;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block8;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block8;
                    }
                    case '\"': {
                        sb.append("\\\"");
                        continue block8;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block8;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            sb.append('\"');
            return sb.toString();
        }
        return arg;
    }

    private static void setCommandLineWrapperParams(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters, ParametersList vmParameters, Class commandLineWrapper, boolean dynamicVMOptions, boolean dynamicParameters) throws CantRunException {
        try {
            File vmParamsFile = null;
            if (dynamicVMOptions) {
                vmParamsFile = FileUtil.createTempFile((String)"idea_vm_params", null);
                try (PrintWriter writer = new PrintWriter(vmParamsFile);){
                    for (String string : vmParameters.getList()) {
                        if (JdkUtil.isUserDefinedProperty(string)) {
                            writer.println(string);
                            continue;
                        }
                        commandLine.addParameter(string);
                    }
                }
            } else {
                commandLine.addParameters(vmParameters.getList());
            }
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            File appParamsFile = null;
            if (dynamicParameters) {
                appParamsFile = FileUtil.createTempFile((String)"idea_app_params", null);
                PrintWriter writer = new PrintWriter(appParamsFile);
                Object object = null;
                try {
                    for (String string : javaParameters.getProgramParametersList().getList()) {
                        writer.println(string);
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (object != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
            File classpathFile = FileUtil.createTempFile((String)"idea_classpath", null);
            PathsList classPath = javaParameters.getClassPath();
            Throwable throwable = null;
            try (PrintWriter printWriter = new PrintWriter(classpathFile);){
                for (String path2 : classPath.getPathList()) {
                    printWriter.println(path2);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            Map map = ContainerUtil.stringMap((String[])new String[]{classpathFile.getAbsolutePath(), classPath.getPathsString()});
            commandLine.putUserData(COMMAND_LINE_CONTENT, map);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            linkedHashSet.add(PathUtil.getJarPathForClass(commandLineWrapper));
            if (UrlClassLoader.class.getName().equals(vmParameters.getPropertyValue("java.system.class.loader"))) {
                linkedHashSet.add(PathUtil.getJarPathForClass(UrlClassLoader.class));
                linkedHashSet.add(PathUtil.getJarPathForClass(StringUtilRt.class));
                linkedHashSet.add(PathUtil.getJarPathForClass(THashMap.class));
            }
            commandLine.addParameter("-classpath");
            commandLine.addParameter(StringUtil.join(linkedHashSet, (String)File.pathSeparator));
            commandLine.addParameter(commandLineWrapper.getName());
            commandLine.addParameter(classpathFile.getAbsolutePath());
            OSProcessHandler.deleteFileOnTermination(commandLine, classpathFile);
            if (vmParamsFile != null) {
                commandLine.addParameter("@vm_params");
                commandLine.addParameter(vmParamsFile.getAbsolutePath());
                map.put(vmParamsFile.getAbsolutePath(), FileUtil.loadFile((File)vmParamsFile));
                OSProcessHandler.deleteFileOnTermination(commandLine, vmParamsFile);
            }
            if (appParamsFile != null) {
                commandLine.addParameter("@app_params");
                commandLine.addParameter(appParamsFile.getAbsolutePath());
                map.put(appParamsFile.getAbsolutePath(), FileUtil.loadFile((File)appParamsFile));
                OSProcessHandler.deleteFileOnTermination(commandLine, appParamsFile);
            }
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    private static void setClasspathJarParams(GeneralCommandLine commandLine, SimpleJavaParameters javaParameters, ParametersList vmParameters, Class commandLineWrapper, boolean dynamicVMOptions, boolean dynamicParameters) throws CantRunException {
        try {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().putValue("Created-By", ApplicationNamesInfo.getInstance().getFullProductName());
            String manifestText = "";
            if (dynamicVMOptions) {
                ArrayList<String> properties = new ArrayList<String>();
                for (String param : vmParameters.getList()) {
                    if (JdkUtil.isUserDefinedProperty(param)) {
                        properties.add(param);
                        continue;
                    }
                    commandLine.addParameter(param);
                }
                manifest.getMainAttributes().putValue("VM-Options", ParametersListUtil.join(properties));
                manifestText = manifestText + "VM-Options: " + ParametersListUtil.join(properties) + "\n";
            } else {
                commandLine.addParameters(vmParameters.getList());
            }
            JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
            if (dynamicParameters) {
                manifest.getMainAttributes().putValue("Program-Parameters", ParametersListUtil.join(javaParameters.getProgramParametersList().getList()));
                manifestText = manifestText + "Program-Parameters: " + ParametersListUtil.join(javaParameters.getProgramParametersList().getList()) + "\n";
            }
            boolean notEscape = vmParameters.hasParameter(PROPERTY_DO_NOT_ESCAPE_CLASSPATH_URL);
            PathsList path2 = javaParameters.getClassPath();
            File classpathJarFile = CommandLineWrapperUtil.createClasspathJarFile((Manifest)manifest, path2.getPathList(), (boolean)notEscape);
            String jarFilePath = classpathJarFile.getAbsolutePath();
            commandLine.addParameter("-classpath");
            if (dynamicVMOptions || dynamicParameters) {
                commandLine.addParameter(PathUtil.getJarPathForClass(commandLineWrapper) + File.pathSeparator + jarFilePath);
                commandLine.addParameter(commandLineWrapper.getName());
            }
            commandLine.addParameter(jarFilePath);
            commandLine.putUserData(COMMAND_LINE_CONTENT, ContainerUtil.stringMap((String[])new String[]{jarFilePath, manifestText + "Class-Path: " + path2.getPathsString()}));
            OSProcessHandler.deleteFileOnTermination(commandLine, classpathJarFile);
        }
        catch (IOException e) {
            JdkUtil.throwUnableToCreateTempFile(e);
        }
    }

    private static boolean isUserDefinedProperty(String param) {
        return param.startsWith("-D") && !param.startsWith("-Dsun.") && !param.startsWith("-Djava.");
    }

    private static void throwUnableToCreateTempFile(IOException cause) throws CantRunException {
        throw new CantRunException("Failed to a create temporary file in " + FileUtilRt.getTempDirectory(), cause);
    }

    private static void appendParamsEncodingClasspath(SimpleJavaParameters javaParameters, GeneralCommandLine commandLine, ParametersList vmParameters) {
        PathsList modulePath;
        commandLine.addParameters(vmParameters.getList());
        JdkUtil.appendEncoding(javaParameters, commandLine, vmParameters);
        PathsList classPath = javaParameters.getClassPath();
        if (!classPath.isEmpty() && !JdkUtil.explicitClassPath(vmParameters)) {
            commandLine.addParameter("-classpath");
            commandLine.addParameter(classPath.getPathsString());
        }
        if (!(modulePath = javaParameters.getModulePath()).isEmpty() && !JdkUtil.explicitModulePath(vmParameters)) {
            commandLine.addParameter("-p");
            commandLine.addParameter(modulePath.getPathsString());
        }
    }

    private static void appendEncoding(SimpleJavaParameters javaParameters, GeneralCommandLine commandLine, ParametersList parametersList) {
        String encoding = parametersList.getPropertyValue("file.encoding");
        if (encoding == null) {
            Charset charset = javaParameters.getCharset();
            if (charset == null) {
                charset = EncodingManager.getInstance().getDefaultCharset();
            }
            commandLine.addParameter("-Dfile.encoding=" + charset.name());
            commandLine.withCharset(charset);
        } else {
            try {
                Charset charset = Charset.forName(encoding);
                commandLine.withCharset(charset);
            }
            catch (IllegalCharsetNameException | UnsupportedCharsetException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private static List<String> getMainClassParams(SimpleJavaParameters javaParameters) throws CantRunException {
        String mainClass = javaParameters.getMainClass();
        String moduleName = javaParameters.getModuleName();
        String jarPath = javaParameters.getJarPath();
        if (mainClass != null && moduleName != null) {
            return Arrays.asList("-m", moduleName + '/' + mainClass);
        }
        if (mainClass != null) {
            return Collections.singletonList(mainClass);
        }
        if (jarPath != null) {
            return Arrays.asList("-jar", jarPath);
        }
        throw new CantRunException(ExecutionBundle.message("main.class.is.not.specified.error.message", new Object[0]));
    }

    @Nullable
    private static Class getCommandLineWrapperClass() {
        try {
            return Class.forName(WRAPPER_CLASS);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static boolean useDynamicClasspath(@Nullable Project project) {
        boolean hasDynamicProperty = Boolean.parseBoolean(System.getProperty("idea.dynamic.classpath", "false"));
        return project != null ? PropertiesComponent.getInstance(project).getBoolean("dynamic.classpath", hasDynamicProperty) : hasDynamicProperty;
    }

    public static boolean useDynamicVMOptions() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.vmoptions", true);
    }

    public static boolean useDynamicParameters() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.parameters", true);
    }

    public static boolean useClasspathJar() {
        return PropertiesComponent.getInstance().getBoolean("idea.dynamic.classpath.jar", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String getJarMainAttribute(@NotNull VirtualFile jarRoot, @NotNull Attributes.Name attribute) {
        VirtualFile manifestFile;
        if (jarRoot == null) {
            JdkUtil.$$$reportNull$$$0(11);
        }
        if (attribute == null) {
            JdkUtil.$$$reportNull$$$0(12);
        }
        if ((manifestFile = jarRoot.findFileByRelativePath("META-INF/MANIFEST.MF")) == null) return null;
        try (InputStream stream = manifestFile.getInputStream();){
            String string = new Manifest(stream).getMainAttributes().getValue(attribute);
            return string;
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
        return null;
    }

    public static GeneralCommandLine setupJVMCommandLine(String exePath, SimpleJavaParameters javaParameters, boolean forceDynamicClasspath) {
        try {
            javaParameters.setUseDynamicClasspath(forceDynamicClasspath);
            GeneralCommandLine commandLine = new GeneralCommandLine(exePath);
            JdkUtil.setupCommandLine(commandLine, javaParameters);
            return commandLine;
        }
        catch (CantRunException e) {
            throw new RuntimeException(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jdk";
                break;
            }
            case 1: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaParameters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jarRoot";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/projectRoots/JdkUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getJdkMainAttribute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForJdk";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForJre";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkForRuntime";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isModularRuntime";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isExplodedModularRuntime";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "setupJVMCommandLine";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getJarMainAttribute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

