/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.CommonBundle;
import com.intellij.openapi.util.SystemInfo;
import java.io.IOException;
import java.util.HashMap;

public class ExceptionMessages {
    static final HashMap<Integer, String> ourIOMessages = new HashMap();

    public static String getMessage(IOException exception) {
        String exceptionMessage = exception.getMessage();
        String detailedMessage = null;
        int idx = exceptionMessage.indexOf(61);
        if (idx != -1) {
            int endIdx;
            for (endIdx = idx + 1; endIdx < exceptionMessage.length() && Character.isDigit(exceptionMessage.charAt(endIdx)); ++endIdx) {
            }
            try {
                int errorNumber = Integer.parseInt(exceptionMessage.substring(idx + 1, endIdx));
                detailedMessage = ourIOMessages.get(new Integer(errorNumber));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        StringBuffer buf = new StringBuffer();
        buf.append(exceptionMessage);
        if (detailedMessage != null) {
            buf.append("\n");
            buf.append(detailedMessage);
        }
        return buf.toString();
    }

    static {
        if (SystemInfo.isWindows) {
            ourIOMessages.put(new Integer(1), CommonBundle.message((String)"incorrect.function.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(2), CommonBundle.message((String)"the.system.cannot.find.the.file.specified.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(3), CommonBundle.message((String)"the.system.cannot.find.the.path.specified.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(4), CommonBundle.message((String)"the.system.cannot.open.the.file.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(5), CommonBundle.message((String)"access.is.denied.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(6), CommonBundle.message((String)"the.handle.is.invalid.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(7), CommonBundle.message((String)"the.storage.control.blocks.were.destroyed.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(8), CommonBundle.message((String)"not.enough.storage.is.available.to.process.this.command.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(9), CommonBundle.message((String)"the.storage.control.block.address.is.invalid.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(10), CommonBundle.message((String)"the.environment.is.incorrect.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(11), CommonBundle.message((String)"an.attempt.was.made.to.load.a.program.with.an.incorrect.format.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(12), CommonBundle.message((String)"the.access.code.is.invalid.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(13), CommonBundle.message((String)"the.data.is.invalid.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(14), CommonBundle.message((String)"not.enough.storage.is.available.to.complete.this.operation.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(15), CommonBundle.message((String)"the.system.cannot.find.the.drive.specified.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(16), CommonBundle.message((String)"the.directory.cannot.be.removed.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(17), CommonBundle.message((String)"the.system.cannot.move.the.file.to.a.different.disk.drive.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(18), CommonBundle.message((String)"there.are.no.more.files.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(19), CommonBundle.message((String)"the.media.is.write.protected.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(20), CommonBundle.message((String)"the.system.cannot.find.the.device.specified.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(21), CommonBundle.message((String)"the.device.is.not.ready.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(22), CommonBundle.message((String)"the.device.does.not.recognize.the.command.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(23), CommonBundle.message((String)"data.error.cyclic.redundancy.check.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(24), CommonBundle.message((String)"the.program.issued.a.command.but.the.command.length.is.incorrect.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(25), CommonBundle.message((String)"the.drive.cannot.locate.a.specific.area.or.track.on.the.disk.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(26), CommonBundle.message((String)"the.specified.disk.or.diskette.cannot.be.accessed.error.message", (Object[])new Object[0]));
            ourIOMessages.put(new Integer(27), CommonBundle.message((String)"the.drive.cannot.find.the.sector.requested.error.message", (Object[])new Object[0]));
        }
    }
}

