/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.PathIterator;
import org.apache.batik.dom.svg.AbstractSVGPathSegList;
import org.apache.batik.dom.svg.ListHandler;
import org.apache.batik.ext.awt.geom.ExtendedGeneralPath;
import org.apache.batik.parser.DefaultPathHandler;
import org.apache.batik.parser.ParseException;
import org.apache.batik.parser.PathParser;

public abstract class AbstractSVGNormPathSegList
extends AbstractSVGPathSegList {
    protected AbstractSVGNormPathSegList() {
    }

    @Override
    protected void doParse(String string, ListHandler listHandler) throws ParseException {
        PathParser pathParser = new PathParser();
        NormalizedPathSegListBuilder normalizedPathSegListBuilder = new NormalizedPathSegListBuilder(listHandler);
        pathParser.setPathHandler(normalizedPathSegListBuilder);
        pathParser.parse(string);
    }

    protected class SVGPathSegGenericItem
    extends AbstractSVGPathSegList.SVGPathSegItem {
        public SVGPathSegGenericItem(short s, String string, float f, float f2, float f3, float f4, float f5, float f6) {
            super(AbstractSVGNormPathSegList.this, s, string);
            this.x1 = f3;
            this.y1 = f4;
            this.x2 = f3;
            this.y2 = f4;
            this.x = f5;
            this.y = f6;
        }

        public void setValue(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x1 = f3;
            this.y1 = f4;
            this.x2 = f3;
            this.y2 = f4;
            this.x = f5;
            this.y = f6;
        }

        public void setValue(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public void setPathSegType(short s) {
            this.type = s;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public void setX(float f) {
            this.x = f;
        }

        public void setY(float f) {
            this.y = f;
        }

        public float getX1() {
            return this.x1;
        }

        public float getY1() {
            return this.y1;
        }

        public void setX1(float f) {
            this.x1 = f;
        }

        public void setY1(float f) {
            this.y1 = f;
        }

        public float getX2() {
            return this.x2;
        }

        public float getY2() {
            return this.y2;
        }

        public void setX2(float f) {
            this.x2 = f;
        }

        public void setY2(float f) {
            this.y2 = f;
        }
    }

    protected class NormalizedPathSegListBuilder
    extends DefaultPathHandler {
        protected ListHandler listHandler;
        protected SVGPathSegGenericItem lastAbs;

        public NormalizedPathSegListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        @Override
        public void startPath() throws ParseException {
            this.listHandler.startList();
            this.lastAbs = new SVGPathSegGenericItem(2, "M", 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }

        @Override
        public void endPath() throws ParseException {
            this.listHandler.endList();
        }

        @Override
        public void movetoRel(float f, float f2) throws ParseException {
            this.movetoAbs(this.lastAbs.getX() + f, this.lastAbs.getY() + f2);
        }

        @Override
        public void movetoAbs(float f, float f2) throws ParseException {
            this.listHandler.item(new AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem(AbstractSVGNormPathSegList.this, 2, "M", f, f2));
            this.lastAbs.setX(f);
            this.lastAbs.setY(f2);
            this.lastAbs.setPathSegType((short)2);
        }

        @Override
        public void closePath() throws ParseException {
            this.listHandler.item(new AbstractSVGPathSegList.SVGPathSegItem(AbstractSVGNormPathSegList.this, 1, "z"));
        }

        @Override
        public void linetoRel(float f, float f2) throws ParseException {
            this.linetoAbs(this.lastAbs.getX() + f, this.lastAbs.getY() + f2);
        }

        @Override
        public void linetoAbs(float f, float f2) throws ParseException {
            this.listHandler.item(new AbstractSVGPathSegList.SVGPathSegMovetoLinetoItem(AbstractSVGNormPathSegList.this, 4, "L", f, f2));
            this.lastAbs.setX(f);
            this.lastAbs.setY(f2);
            this.lastAbs.setPathSegType((short)4);
        }

        @Override
        public void linetoHorizontalRel(float f) throws ParseException {
            this.linetoAbs(this.lastAbs.getX() + f, this.lastAbs.getY());
        }

        @Override
        public void linetoHorizontalAbs(float f) throws ParseException {
            this.linetoAbs(f, this.lastAbs.getY());
        }

        @Override
        public void linetoVerticalRel(float f) throws ParseException {
            this.linetoAbs(this.lastAbs.getX(), this.lastAbs.getY() + f);
        }

        @Override
        public void linetoVerticalAbs(float f) throws ParseException {
            this.linetoAbs(this.lastAbs.getX(), f);
        }

        @Override
        public void curvetoCubicRel(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
            this.curvetoCubicAbs(this.lastAbs.getX() + f, this.lastAbs.getY() + f2, this.lastAbs.getX() + f3, this.lastAbs.getY() + f4, this.lastAbs.getX() + f5, this.lastAbs.getY() + f6);
        }

        @Override
        public void curvetoCubicAbs(float f, float f2, float f3, float f4, float f5, float f6) throws ParseException {
            this.listHandler.item(new AbstractSVGPathSegList.SVGPathSegCurvetoCubicItem(AbstractSVGNormPathSegList.this, 6, "C", f, f2, f3, f4, f5, f6));
            this.lastAbs.setValue(f, f2, f3, f4, f5, f6);
            this.lastAbs.setPathSegType((short)6);
        }

        @Override
        public void curvetoCubicSmoothRel(float f, float f2, float f3, float f4) throws ParseException {
            this.curvetoCubicSmoothAbs(this.lastAbs.getX() + f, this.lastAbs.getY() + f2, this.lastAbs.getX() + f3, this.lastAbs.getY() + f4);
        }

        @Override
        public void curvetoCubicSmoothAbs(float f, float f2, float f3, float f4) throws ParseException {
            if (this.lastAbs.getPathSegType() == 6) {
                this.curvetoCubicAbs(this.lastAbs.getX() + (this.lastAbs.getX() - this.lastAbs.getX2()), this.lastAbs.getY() + (this.lastAbs.getY() - this.lastAbs.getY2()), f, f2, f3, f4);
            } else {
                this.curvetoCubicAbs(this.lastAbs.getX(), this.lastAbs.getY(), f, f2, f3, f4);
            }
        }

        @Override
        public void curvetoQuadraticRel(float f, float f2, float f3, float f4) throws ParseException {
            this.curvetoQuadraticAbs(this.lastAbs.getX() + f, this.lastAbs.getY() + f2, this.lastAbs.getX() + f3, this.lastAbs.getY() + f4);
        }

        @Override
        public void curvetoQuadraticAbs(float f, float f2, float f3, float f4) throws ParseException {
            this.curvetoCubicAbs(this.lastAbs.getX() + 2.0f * (f - this.lastAbs.getX()) / 3.0f, this.lastAbs.getY() + 2.0f * (f2 - this.lastAbs.getY()) / 3.0f, f3 + 2.0f * (f - f3) / 3.0f, f4 + 2.0f * (f2 - f4) / 3.0f, f3, f4);
            this.lastAbs.setX1(f);
            this.lastAbs.setY1(f2);
            this.lastAbs.setPathSegType((short)8);
        }

        @Override
        public void curvetoQuadraticSmoothRel(float f, float f2) throws ParseException {
            this.curvetoQuadraticSmoothAbs(this.lastAbs.getX() + f, this.lastAbs.getY() + f2);
        }

        @Override
        public void curvetoQuadraticSmoothAbs(float f, float f2) throws ParseException {
            if (this.lastAbs.getPathSegType() == 8) {
                this.curvetoQuadraticAbs(this.lastAbs.getX() + (this.lastAbs.getX() - this.lastAbs.getX1()), this.lastAbs.getY() + (this.lastAbs.getY() - this.lastAbs.getY1()), f, f2);
            } else {
                this.curvetoQuadraticAbs(this.lastAbs.getX(), this.lastAbs.getY(), f, f2);
            }
        }

        @Override
        public void arcRel(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) throws ParseException {
            this.arcAbs(f, f2, f3, bl, bl2, this.lastAbs.getX() + f4, this.lastAbs.getY() + f5);
        }

        @Override
        public void arcAbs(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) throws ParseException {
            if (f == 0.0f || f2 == 0.0f) {
                this.linetoAbs(f4, f5);
                return;
            }
            double d = this.lastAbs.getX();
            double d2 = this.lastAbs.getY();
            if (d == (double)f4 && d2 == (double)f5) {
                return;
            }
            Arc2D arc2D = ExtendedGeneralPath.computeArc(d, d2, f, f2, f3, bl, bl2, f4, f5);
            if (arc2D == null) {
                return;
            }
            AffineTransform affineTransform = AffineTransform.getRotateInstance(Math.toRadians(f3), arc2D.getCenterX(), arc2D.getCenterY());
            Shape shape = affineTransform.createTransformedShape(arc2D);
            PathIterator pathIterator = shape.getPathIterator(new AffineTransform());
            float[] fArray = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
            int n = -1;
            while (!pathIterator.isDone()) {
                n = pathIterator.currentSegment(fArray);
                switch (n) {
                    case 3: {
                        this.curvetoCubicAbs(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                    }
                }
                pathIterator.next();
            }
            this.lastAbs.setPathSegType((short)10);
        }
    }
}

