/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.CommonBundle;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.NewColorAndFontPanel;
import com.intellij.application.options.colors.SimpleEditorPreview;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.CreateDesktopEntryAction;
import com.intellij.ide.actions.CreateLauncherScriptAction;
import com.intellij.ide.customize.CustomizeDesktopEntryStep;
import com.intellij.ide.customize.CustomizeLauncherScriptStep;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.ui.LafComboBoxRenderer;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.LafManagerImpl;
import com.intellij.ide.ui.laf.darcula.DarculaLookAndFeelInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.changes.RefreshablePanel;
import com.intellij.ui.AbstractTitledSeparatorWithIcon;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class InitialConfigurationDialog
extends DialogWrapper {
    private final String myColorSettingsPage;
    private JPanel myMainPanel;
    private JComboBox<Keymap> myKeymapComboBox;
    private JComboBox<UIManager.LookAndFeelInfo> myAppearanceComboBox;
    private JComboBox<EditorColorsScheme> myColorSchemeComboBox;
    private JPanel myColorPreviewPanel;
    private JLabel myPreferencesLabel;
    private JCheckBox myCreateScriptCheckbox;
    private JPanel myCreateScriptPanel;
    private JTextField myScriptPathTextField;
    private JCheckBox myCreateEntryCheckBox;
    private JPanel myCreateEntryPanel;
    private JCheckBox myGlobalEntryCheckBox;

    public InitialConfigurationDialog(Component parent, String colorSettingsPage) {
        super(parent, true);
        this.myColorSettingsPage = colorSettingsPage;
        this.$$$setupUI$$$();
        this.setTitle(ApplicationNamesInfo.getInstance().getFullProductName() + " Initial Configuration");
        this.setResizable(false);
        this.setCancelButtonText("Skip");
        this.init();
        Keymap[] allKeymaps = ((KeymapManagerImpl)KeymapManager.getInstance()).getAllKeymaps();
        Keymap[] availableKeymaps = (Keymap[])Arrays.stream(allKeymaps).filter(DefaultKeymap::matchesPlatform).toArray(Keymap[]::new);
        UIManager.LookAndFeelInfo[] lookAndFeels = LafManager.getInstance().getInstalledLookAndFeels();
        EditorColorsScheme[] colorSchemes = EditorColorsManager.getInstance().getAllSchemes();
        this.myKeymapComboBox.setModel(new DefaultComboBoxModel<Keymap>(availableKeymaps));
        this.myKeymapComboBox.setRenderer((ListCellRenderer<Keymap>)new ListCellRendererWrapper<Keymap>(){

            public void customize(JList list2, Keymap keymap, int index, boolean selected, boolean hasFocus) {
                if (keymap != null) {
                    if ("$default".equals(keymap.getName())) {
                        this.setText("IntelliJ IDEA Classic");
                    } else if ("Mac OS X".equals(keymap.getName())) {
                        this.setText("IntelliJ IDEA Classic - Mac OS X");
                    } else {
                        this.setText(keymap.getPresentableName());
                    }
                }
            }
        });
        this.myAppearanceComboBox.setModel(new DefaultComboBoxModel<UIManager.LookAndFeelInfo>(lookAndFeels));
        this.myAppearanceComboBox.setRenderer((ListCellRenderer<UIManager.LookAndFeelInfo>)((Object)new LafComboBoxRenderer()));
        this.myAppearanceComboBox.setSelectedItem(LafManager.getInstance().getCurrentLookAndFeel());
        this.myAppearanceComboBox.addActionListener(event -> this.updateColorScheme(colorSchemes));
        this.myColorSchemeComboBox.setModel(new DefaultComboBoxModel<EditorColorsScheme>(colorSchemes));
        this.myColorSchemeComboBox.setRenderer((ListCellRenderer<EditorColorsScheme>)new ListCellRendererWrapper<EditorColorsScheme>(){

            public void customize(JList list2, EditorColorsScheme value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText(SchemeManager.getDisplayName((Scheme)value));
                }
            }
        });
        this.myColorSchemeComboBox.addActionListener(event -> ((MySeparatorPanel)this.myColorPreviewPanel).updatePreview());
        this.myPreferencesLabel.setText("You can use " + CommonBundle.settingsActionPath() + " to configure any of these settings later.");
        boolean canCreateLauncherScript = CustomizeLauncherScriptStep.isAvailable();
        this.myCreateScriptPanel.setVisible(canCreateLauncherScript);
        this.myCreateScriptCheckbox.setVisible(canCreateLauncherScript);
        this.myCreateScriptCheckbox.setSelected(false);
        if (canCreateLauncherScript) {
            this.myScriptPathTextField.setText(CreateLauncherScriptAction.defaultScriptPath());
            this.myScriptPathTextField.setEnabled(false);
            this.myCreateScriptCheckbox.addChangeListener(e -> this.myScriptPathTextField.setEnabled(this.myCreateScriptCheckbox.isSelected()));
        }
        boolean canCreateDesktopEntry = CustomizeDesktopEntryStep.isAvailable();
        this.myCreateEntryPanel.setVisible(canCreateDesktopEntry);
        this.myCreateEntryCheckBox.setVisible(canCreateDesktopEntry);
        this.myCreateEntryCheckBox.setSelected(canCreateDesktopEntry);
        this.myGlobalEntryCheckBox.setSelected(false);
        if (canCreateDesktopEntry) {
            this.myGlobalEntryCheckBox.setEnabled(true);
            this.myCreateEntryCheckBox.addChangeListener(e -> this.myGlobalEntryCheckBox.setEnabled(this.myCreateEntryCheckBox.isSelected()));
        }
        this.preselectKeyMap(availableKeymaps);
        this.updateColorScheme(colorSchemes);
        Disposer.register((Disposable)this.myDisposable, () -> ((MySeparatorPanel)this.myColorPreviewPanel).disposeUIResources());
    }

    private void createUIComponents() {
        this.myColorPreviewPanel = new MySeparatorPanel(this);
    }

    private void preselectKeyMap(Keymap[] keymaps) {
        Keymap defaultKeymap = KeymapManager.getInstance().getActiveKeymap();
        for (Keymap keymap : keymaps) {
            if (!(SystemInfo.isMac ? keymap.getName().contains("10.5+") : keymap.equals(defaultKeymap))) continue;
            this.myKeymapComboBox.setSelectedItem(keymap);
            break;
        }
    }

    private void updateColorScheme(EditorColorsScheme[] colorsSchemes) {
        UIManager.LookAndFeelInfo selectedLaf = (UIManager.LookAndFeelInfo)this.myAppearanceComboBox.getSelectedItem();
        if (selectedLaf != null) {
            String matchingScheme = selectedLaf.getName().contains("Darcula") ? "Darcula" : "Default";
            for (EditorColorsScheme colorsScheme : colorsSchemes) {
                if (!colorsScheme.getName().contains(matchingScheme)) continue;
                this.myColorSchemeComboBox.setSelectedItem(colorsScheme);
                break;
            }
        }
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    protected void doOKAction() {
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)this.myMainPanel));
        super.doOKAction();
        InitialConfigurationDialog.setAppearance(project, (Keymap)this.myKeymapComboBox.getSelectedItem(), (EditorColorsScheme)this.myColorSchemeComboBox.getSelectedItem(), (UIManager.LookAndFeelInfo)this.myAppearanceComboBox.getSelectedItem());
        InitialConfigurationDialog.makeLaunchers(project, this.getTitle(), this.myCreateScriptCheckbox.isSelected(), this.myCreateEntryCheckBox.isSelected(), this.myScriptPathTextField.getText(), this.myGlobalEntryCheckBox.isSelected());
    }

    private static void setAppearance(Project project, Keymap keymap, EditorColorsScheme colorScheme, UIManager.LookAndFeelInfo laf) {
        ((KeymapManagerImpl)KeymapManager.getInstance()).setActiveKeymap(keymap);
        EditorColorsManager.getInstance().setGlobalScheme(colorScheme);
        TodoConfiguration.getInstance().resetToDefaultTodoPatterns();
        LafManagerImpl lafManager = (LafManagerImpl)LafManager.getInstance();
        if (laf.getName().contains("Darcula") != LafManager.getInstance().getCurrentLookAndFeel() instanceof DarculaLookAndFeelInfo) {
            lafManager.setLookAndFeelAfterRestart(laf);
            String message = "IDE appearance settings will be applied after restart. Would you like to restart now?";
            int rc = Messages.showYesNoDialog((Project)project, (String)message, (String)"IDE Appearance", (Icon)Messages.getQuestionIcon());
            if (rc == 0) {
                ((ApplicationImpl)ApplicationManager.getApplication()).restart(true);
            }
        } else if (!laf.equals(lafManager.getCurrentLookAndFeel())) {
            lafManager.setCurrentLookAndFeel(laf);
            lafManager.updateUI();
        }
    }

    private static void makeLaunchers(Project project, String title, final boolean createScript, final boolean createEntry, final String pathName, final boolean globalEntry) {
        if (createScript || createEntry) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    indicator.setFraction(0.0);
                    if (createScript) {
                        indicator.setText("Creating launcher script...");
                        try {
                            CreateLauncherScriptAction.createLauncherScript(pathName);
                        }
                        catch (Exception e) {
                            CreateLauncherScriptAction.reportFailure(e, this.getProject());
                        }
                    }
                    indicator.setFraction(0.5);
                    if (createEntry) {
                        indicator.setText("Creating desktop entry...");
                        try {
                            CreateDesktopEntryAction.createDesktopEntry(globalEntry);
                        }
                        catch (Exception e) {
                            CreateDesktopEntryAction.reportFailure(e, this.getProject());
                        }
                    }
                    indicator.setFraction(1.0);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/application/options/InitialConfigurationDialog$3", "run"));
                }
            });
        }
    }

    private void resize(int dW, int dH) {
        Dimension size = this.getSize();
        this.setSize(size.width + dW, size.height + dH);
        this.getRootPane().revalidate();
        this.getRootPane().repaint();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JPanel jPanel2;
        JCheckBox jCheckBox3;
        JLabel jLabel;
        JPanel jPanel3;
        this.createUIComponents();
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Keymap scheme:");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox = new JComboBox();
        this.myKeymapComboBox = jComboBox;
        jPanel3.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("IDE theme:");
        jPanel3.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox2 = new JComboBox();
        this.myAppearanceComboBox = jComboBox2;
        jPanel3.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Editor colors and fonts:");
        jPanel3.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.myColorSchemeComboBox = jComboBox3;
        jPanel3.add(jComboBox3, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel4 = this.myColorPreviewPanel;
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 2, 0, 3, 7, 7, null, null, null, 1));
        this.myPreferencesLabel = jLabel = new JLabel();
        Font font = this.$$$getFont$$$(null, -1, 11, jLabel.getFont());
        if (font != null) {
            jLabel.setFont(font);
        }
        jLabel.setText("(preferences label)");
        jPanel3.add((Component)jLabel, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.myCreateScriptCheckbox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(false);
        jCheckBox3.setText("Enable opening files and projects from the command line");
        jPanel3.add((Component)jCheckBox3, new GridConstraints(5, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCreateScriptPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel2, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null, 2));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Script path:");
        jPanel2.add((Component)jLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myScriptPathTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myCreateEntryCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Create desktop entry (integrate in system menu)");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(7, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myCreateEntryPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null, 2));
        this.myGlobalEntryCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("For all  users");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jComboBox2);
        jLabel4.setLabelFor(jComboBox3);
        ButtonGroup buttonGroup2 = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }

    private static class MyColorPreviewPanel
    extends JPanel
    implements RefreshablePanel {
        private final InitialConfigurationDialog myDialog;
        private final JPanel myWrapper;
        private SimpleEditorPreview myPreviewEditor;
        private ColorAndFontOptions myPreviewOptions;
        private NewColorAndFontPanel myColorAndFontPanel;

        public MyColorPreviewPanel(InitialConfigurationDialog dialog2, JPanel wrapper2) {
            super(new BorderLayout());
            this.myDialog = dialog2;
            this.myWrapper = wrapper2;
            this.updateColorSchemePreview(false);
        }

        @Override
        public void refresh() {
            this.updateColorSchemePreview(false);
        }

        @Override
        public JPanel getPanel() {
            return (JPanel)this.myPreviewEditor.getPanel();
        }

        private void updateColorSchemePreview(boolean recalculateDialogSize) {
            if (!this.myWrapper.isVisible()) {
                return;
            }
            int wrapperHeight = 0;
            if (this.myPreviewEditor != null) {
                wrapperHeight = this.getPreviewPreferredHeight();
                this.myPreviewEditor.disposeUIResources();
                this.myWrapper.removeAll();
            }
            if (this.myPreviewOptions == null) {
                this.myPreviewOptions = new ColorAndFontOptions();
            }
            this.myPreviewOptions.reset();
            EditorColorsScheme scheme2 = (EditorColorsScheme)this.myDialog.myColorSchemeComboBox.getSelectedItem();
            assert (scheme2 != null);
            this.myPreviewOptions.selectScheme(scheme2.getName());
            this.myColorAndFontPanel = this.myPreviewOptions.findPage(this.myDialog.myColorSettingsPage);
            assert (this.myColorAndFontPanel != null) : InitialConfigurationDialog.access$500(this.myDialog);
            this.myPreviewEditor = new SimpleEditorPreview(this.myPreviewOptions, this.myColorAndFontPanel.getSettingsPage(), false);
            this.myPreviewEditor.updateView();
            this.myWrapper.add(this.myPreviewEditor.getPanel());
            if (recalculateDialogSize) {
                this.myDialog.resize(0, this.getPreviewPreferredHeight() - wrapperHeight);
            }
        }

        private void disposeUIResources() {
            if (this.myPreviewEditor != null) {
                this.myPreviewEditor.disposeUIResources();
            }
            if (this.myPreviewOptions != null) {
                this.myPreviewOptions.disposeUIResources();
            }
            if (this.myColorAndFontPanel != null) {
                this.myColorAndFontPanel.disposeUIResources();
            }
        }

        private int getPreviewPreferredHeight() {
            return this.myPreviewEditor.getPanel().getPreferredSize().height / 2;
        }

        private void inflate(int dW) {
            this.myDialog.resize(dW, this.getPreviewPreferredHeight());
        }

        private void deflate(int dW) {
            this.myDialog.resize(-dW, -this.getPreviewPreferredHeight());
        }
    }

    private static class MySeparatorPanel
    extends AbstractTitledSeparatorWithIcon {
        private static final String SHOW_TEXT = "Click to preview";
        private static final String HIDE_TEXT = "Click to hide preview";
        private final InitialConfigurationDialog myDialog;
        private int myAddedWidth;

        public MySeparatorPanel(InitialConfigurationDialog dialog2) {
            super(AllIcons.General.ComboArrowRight, AllIcons.General.ComboArrowDown, SHOW_TEXT);
            this.myDialog = dialog2;
        }

        @Override
        protected RefreshablePanel createPanel() {
            return new MyColorPreviewPanel(this.myDialog, this.myWrapper);
        }

        @Override
        protected void initOnImpl() {
        }

        @Override
        protected void onImpl() {
            this.myWrapper.setVisible(true);
            this.setText(HIDE_TEXT);
            this.initDetails();
            this.myLabel.setIcon(this.myIconOpen);
            this.myOn = true;
            this.revalidate();
            this.myAddedWidth = this.getPreferredSize().width - this.getSize().width;
            ((MyColorPreviewPanel)this.myDetailsComponent).inflate(this.myAddedWidth);
        }

        @Override
        protected void offImpl() {
            this.myLabel.setIcon(this.myIcon);
            this.setText(SHOW_TEXT);
            ((MyColorPreviewPanel)this.myDetailsComponent).deflate(this.myAddedWidth);
            this.myWrapper.removeAll();
            this.myWrapper.setVisible(false);
            this.myOn = false;
        }

        private void updatePreview() {
            RefreshablePanel previewPanel = this.myDetailsComponent;
            if (previewPanel != null) {
                ((MyColorPreviewPanel)previewPanel).updateColorSchemePreview(true);
            }
        }

        private void disposeUIResources() {
            RefreshablePanel previewPanel = this.myDetailsComponent;
            if (previewPanel != null) {
                ((MyColorPreviewPanel)previewPanel).disposeUIResources();
            }
        }
    }
}

