/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeEditor.printing;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.LineMarkersPass;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSeparatorProvider {
    @Nullable
    public static List<LineMarkerInfo> getFileSeparators(PsiFile file2, Document document) {
        ArrayList<LineMarkerInfo> result2 = new ArrayList<LineMarkerInfo>();
        for (LineMarkerInfo lineMarkerInfo : LineMarkersPass.queryLineMarkers(file2, document)) {
            if (lineMarkerInfo.separatorColor == null) continue;
            result2.add(lineMarkerInfo);
        }
        Collections.sort(result2, (i1, i2) -> FileSeparatorProvider.getDisplayLine(i1, document) - FileSeparatorProvider.getDisplayLine(i2, document));
        return result2;
    }

    public static int getDisplayLine(@NotNull LineMarkerInfo lineMarkerInfo, @NotNull Document document) {
        if (lineMarkerInfo == null) {
            FileSeparatorProvider.$$$reportNull$$$0(0);
        }
        if (document == null) {
            FileSeparatorProvider.$$$reportNull$$$0(1);
        }
        int offset = lineMarkerInfo.separatorPlacement == SeparatorPlacement.TOP ? lineMarkerInfo.startOffset : lineMarkerInfo.endOffset;
        return document.getLineNumber(Math.min(document.getTextLength(), Math.max(0, offset))) + (lineMarkerInfo.separatorPlacement == SeparatorPlacement.TOP ? 0 : 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "lineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "document";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeEditor/printing/FileSeparatorProvider";
        objectArray[2] = "getDisplayLine";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

