/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.AppTopics;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DelayedDocumentWatcher
implements AutoTestWatcher {
    private final Project myProject;
    private final Alarm myAlarm;
    private final int myDelayMillis;
    private final Consumer<Integer> myModificationStampConsumer;
    private final Condition<VirtualFile> myChangedFileFilter;
    private final MyDocumentAdapter myListener;
    private final Runnable myAlarmRunnable;
    private final Set<VirtualFile> myChangedFiles;
    private boolean myDocumentSavingInProgress;
    private MessageBusConnection myConnection;
    private int myModificationStamp;
    private Disposable myListenerDisposable;

    public DelayedDocumentWatcher(@NotNull Project project, int delayMillis, @NotNull Consumer<Integer> modificationStampConsumer, @Nullable Condition<VirtualFile> changedFileFilter) {
        if (project == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(0);
        }
        if (modificationStampConsumer == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(1);
        }
        this.myChangedFiles = new THashSet();
        this.myDocumentSavingInProgress = false;
        this.myModificationStamp = 0;
        this.myProject = project;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
        this.myDelayMillis = delayMillis;
        this.myModificationStampConsumer = modificationStampConsumer;
        this.myChangedFileFilter = changedFileFilter;
        this.myListener = new MyDocumentAdapter();
        this.myAlarmRunnable = new MyRunnable();
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(2);
        }
        return project;
    }

    @Override
    public void activate() {
        if (this.myConnection == null) {
            this.myListenerDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this.myProject, (Disposable)this.myListenerDisposable);
            EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this.myListener, this.myListenerDisposable);
            this.myConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject);
            this.myConnection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(){

                public void beforeAllDocumentsSaving() {
                    DelayedDocumentWatcher.this.myDocumentSavingInProgress = true;
                    ApplicationManager.getApplication().invokeLater(() -> DelayedDocumentWatcher.this.myDocumentSavingInProgress = false, ModalityState.any());
                }
            });
        }
    }

    @Override
    public void deactivate() {
        if (this.myConnection != null) {
            if (this.myListenerDisposable != null) {
                Disposer.dispose((Disposable)this.myListenerDisposable);
                this.myListenerDisposable = null;
            }
            this.myConnection.disconnect();
            this.myConnection = null;
        }
    }

    @Override
    public boolean isUpToDate(int modificationStamp) {
        return this.myModificationStamp == modificationStamp;
    }

    private void asyncCheckErrors(@NotNull Collection<VirtualFile> files, @NotNull Consumer<Boolean> errorsFoundConsumer) {
        if (files == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(3);
        }
        if (errorsFoundConsumer == null) {
            DelayedDocumentWatcher.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (files == null) {
                DelayedDocumentWatcher.$$$reportNull$$$0(5);
            }
            if (errorsFoundConsumer == null) {
                DelayedDocumentWatcher.$$$reportNull$$$0(6);
            }
            boolean errorsFound = (Boolean)ReadAction.compute(() -> {
                if (files == null) {
                    DelayedDocumentWatcher.$$$reportNull$$$0(8);
                }
                for (VirtualFile file2 : files) {
                    if (!PsiErrorElementUtil.hasErrors(this.myProject, file2)) continue;
                    return true;
                }
                return false;
            });
            ApplicationManager.getApplication().invokeLater(() -> {
                if (errorsFoundConsumer == null) {
                    DelayedDocumentWatcher.$$$reportNull$$$0(7);
                }
                errorsFoundConsumer.consume((Object)errorsFound);
            }, ModalityState.any());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificationStampConsumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/DelayedDocumentWatcher";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorsFoundConsumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/DelayedDocumentWatcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "asyncCheckErrors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "lambda$asyncCheckErrors$2";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        @Override
        public void run() {
            int oldModificationStamp = DelayedDocumentWatcher.this.myModificationStamp;
            DelayedDocumentWatcher.this.asyncCheckErrors(DelayedDocumentWatcher.this.myChangedFiles, (Consumer<Boolean>)errorsFound -> {
                if (DelayedDocumentWatcher.this.myModificationStamp != oldModificationStamp) {
                    return;
                }
                if (errorsFound.booleanValue()) {
                    return;
                }
                DelayedDocumentWatcher.this.myChangedFiles.clear();
                DelayedDocumentWatcher.this.myModificationStampConsumer.consume((Object)DelayedDocumentWatcher.this.myModificationStamp);
            });
        }
    }

    private class MyDocumentAdapter
    implements DocumentListener {
        private MyDocumentAdapter() {
        }

        public void documentChanged(DocumentEvent event) {
            if (DelayedDocumentWatcher.this.myDocumentSavingInProgress) {
                return;
            }
            Document document = event.getDocument();
            VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
            if (file2 == null) {
                return;
            }
            if (!DelayedDocumentWatcher.this.myChangedFiles.contains(file2)) {
                if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file2)) {
                    return;
                }
                if (DelayedDocumentWatcher.this.myChangedFileFilter != null && !DelayedDocumentWatcher.this.myChangedFileFilter.value((Object)file2)) {
                    return;
                }
                DelayedDocumentWatcher.this.myChangedFiles.add(file2);
            }
            DelayedDocumentWatcher.this.myAlarm.cancelRequest(DelayedDocumentWatcher.this.myAlarmRunnable);
            DelayedDocumentWatcher.this.myAlarm.addRequest(DelayedDocumentWatcher.this.myAlarmRunnable, DelayedDocumentWatcher.this.myDelayMillis);
            DelayedDocumentWatcher.this.myModificationStamp++;
        }
    }
}

