/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class FileTemplateTab {
    protected final List<FileTemplateBase> myTemplates = new ArrayList<FileTemplateBase>();
    private final String myTitle;
    protected static final Color MODIFIED_FOREGROUND = JBColor.BLUE;

    protected FileTemplateTab(String title) {
        this.myTitle = title;
    }

    public abstract JComponent getComponent();

    @Nullable
    public abstract FileTemplate getSelectedTemplate();

    public abstract void selectTemplate(FileTemplate var1);

    public abstract void removeSelected();

    public abstract void onTemplateSelected();

    public void init(FileTemplate[] templates) {
        FileTemplate oldSelection = this.getSelectedTemplate();
        String oldSelectionName = oldSelection != null ? ((FileTemplateBase)oldSelection).getQualifiedName() : null;
        this.myTemplates.clear();
        FileTemplateBase newSelection = null;
        for (FileTemplate original : templates) {
            FileTemplateBase copy = (FileTemplateBase)original.clone();
            if (oldSelectionName != null && oldSelectionName.equals(copy.getQualifiedName())) {
                newSelection = copy;
            }
            this.myTemplates.add(copy);
        }
        this.initSelection(newSelection);
    }

    protected abstract void initSelection(FileTemplate var1);

    public abstract void fireDataChanged();

    @NotNull
    public FileTemplate[] getTemplates() {
        FileTemplate[] fileTemplateArray = this.myTemplates.toArray(new FileTemplate[this.myTemplates.size()]);
        if (fileTemplateArray == null) {
            FileTemplateTab.$$$reportNull$$$0(0);
        }
        return fileTemplateArray;
    }

    public abstract void addTemplate(FileTemplate var1);

    public String getTitle() {
        return this.myTitle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/FileTemplateTab", "getTemplates"));
    }
}

