/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.CommonBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ConfigurationErrorType;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.module.impl.RemoveInvalidElementsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class ProjectLoadingErrorsNotifierImpl
extends ProjectLoadingErrorsNotifier {
    private final MultiMap<ConfigurationErrorType, ConfigurationErrorDescription> myErrors = new MultiMap();
    private final Object myLock = new Object();
    private final Project myProject;

    public ProjectLoadingErrorsNotifierImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public void registerError(@NotNull ConfigurationErrorDescription errorDescription) {
        if (errorDescription == null) {
            ProjectLoadingErrorsNotifierImpl.$$$reportNull$$$0(0);
        }
        this.registerErrors(Collections.singletonList(errorDescription));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerErrors(@NotNull Collection<? extends ConfigurationErrorDescription> errorDescriptions) {
        boolean first;
        if (errorDescriptions == null) {
            ProjectLoadingErrorsNotifierImpl.$$$reportNull$$$0(1);
        }
        if (this.myProject.isDisposed() || this.myProject.isDefault() || errorDescriptions.isEmpty()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            first = this.myErrors.isEmpty();
            for (ConfigurationErrorDescription configurationErrorDescription : errorDescriptions) {
                this.myErrors.putValue((Object)configurationErrorDescription.getErrorType(), (Object)configurationErrorDescription);
            }
        }
        if (this.myProject.isInitialized()) {
            this.fireNotifications();
        } else if (first) {
            StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(() -> this.fireNotifications());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNotifications() {
        MultiMap descriptionsMap = new MultiMap();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            if (this.myErrors.isEmpty()) {
                return;
            }
            descriptionsMap.putAllValues(this.myErrors);
            this.myErrors.clear();
        }
        for (final ConfigurationErrorType type : descriptionsMap.keySet()) {
            final Collection descriptions = descriptionsMap.get((Object)type);
            if (descriptions.isEmpty()) continue;
            final String invalidElements = ProjectLoadingErrorsNotifierImpl.getInvalidElementsString(type, descriptions);
            String errorText = ProjectBundle.message((String)"error.message.configuration.cannot.load", (Object[])new Object[0]) + " " + invalidElements + " <a href=\"\">Details...</a>";
            Notifications.Bus.notify((Notification)new Notification("Project Loading Error", "Error Loading Project", errorText, NotificationType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    List validDescriptions = ContainerUtil.findAll((Collection)descriptions, errorDescription -> errorDescription.isValid());
                    if (RemoveInvalidElementsDialog.showDialog(ProjectLoadingErrorsNotifierImpl.this.myProject, CommonBundle.getErrorTitle(), type, invalidElements, validDescriptions)) {
                        notification.expire();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/openapi/module/impl/ProjectLoadingErrorsNotifierImpl$1";
                    objectArray[2] = "hyperlinkUpdate";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }), (Project)this.myProject);
        }
    }

    private static String getInvalidElementsString(ConfigurationErrorType type, Collection<ConfigurationErrorDescription> descriptions) {
        if (descriptions.size() == 1) {
            ConfigurationErrorDescription description = (ConfigurationErrorDescription)ContainerUtil.getFirstItem(descriptions);
            return type.getElementKind() + " " + description.getElementName();
        }
        return descriptions.size() + " " + StringUtil.pluralize((String)type.getElementKind());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorDescription";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorDescriptions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/module/impl/ProjectLoadingErrorsNotifierImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerError";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerErrors";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

