/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.OrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleOrderEntryImpl
extends OrderEntryBaseImpl
implements ModuleOrderEntry,
WritableOrderEntry,
ClonableOrderEntry {
    @NonNls
    public static final String ENTRY_TYPE = "module";
    @NonNls
    public static final String MODULE_NAME_ATTR = "module-name";
    @NonNls
    private static final String EXPORTED_ATTR = "exported";
    @NonNls
    private static final String PRODUCTION_ON_TEST_ATTRIBUTE = "production-on-test";
    private final ModulePointer myModulePointer;
    private boolean myExported;
    @NotNull
    private DependencyScope myScope;
    private boolean myProductionOnTestDependency;

    ModuleOrderEntryImpl(@NotNull Module module2, @NotNull RootModelImpl rootModel) {
        if (module2 == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(0);
        }
        if (rootModel == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(1);
        }
        super(rootModel);
        this.myModulePointer = ModulePointerManager.getInstance((Project)module2.getProject()).create(module2);
        this.myScope = DependencyScope.COMPILE;
    }

    ModuleOrderEntryImpl(@NotNull String moduleName, @NotNull RootModelImpl rootModel) {
        if (moduleName == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(2);
        }
        if (rootModel == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(3);
        }
        super(rootModel);
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(moduleName);
        this.myScope = DependencyScope.COMPILE;
    }

    ModuleOrderEntryImpl(@NotNull Element element, @NotNull RootModelImpl rootModel) throws InvalidDataException {
        if (element == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(4);
        }
        if (rootModel == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(5);
        }
        super(rootModel);
        this.myExported = element.getAttributeValue(EXPORTED_ATTR) != null;
        String moduleName = element.getAttributeValue(MODULE_NAME_ATTR);
        if (moduleName == null) {
            throw new InvalidDataException();
        }
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(moduleName);
        this.myScope = DependencyScope.readExternal((Element)element);
        this.myProductionOnTestDependency = element.getAttributeValue(PRODUCTION_ON_TEST_ATTRIBUTE) != null;
    }

    private ModuleOrderEntryImpl(@NotNull ModuleOrderEntryImpl that, @NotNull RootModelImpl rootModel) {
        if (that == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(6);
        }
        if (rootModel == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(7);
        }
        super(rootModel);
        this.myModulePointer = ModulePointerManager.getInstance((Project)rootModel.getProject()).create(that.myModulePointer.getModuleName());
        this.myExported = that.myExported;
        this.myProductionOnTestDependency = that.myProductionOnTestDependency;
        this.myScope = that.myScope;
    }

    @NotNull
    public Module getOwnerModule() {
        Module module2 = this.getRootModel().getModule();
        if (module2 == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(8);
        }
        return module2;
    }

    public boolean isProductionOnTestDependency() {
        return this.myProductionOnTestDependency;
    }

    public void setProductionOnTestDependency(boolean productionOnTestDependency) {
        this.myProductionOnTestDependency = productionOnTestDependency;
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType type) {
        OrderRootsEnumerator enumerator;
        if (type == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(9);
        }
        VirtualFile[] virtualFileArray = (enumerator = this.getEnumerator(type)) != null ? enumerator.getRoots() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(10);
        }
        return virtualFileArray;
    }

    @Nullable
    private OrderRootsEnumerator getEnumerator(@NotNull OrderRootType type) {
        Module module2;
        if (type == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(11);
        }
        if ((module2 = this.myModulePointer.getModule()) == null) {
            return null;
        }
        return ModuleRootManagerImpl.getCachingEnumeratorForType(type, module2);
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        OrderRootsEnumerator enumerator;
        if (rootType == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(12);
        }
        String[] stringArray = (enumerator = this.getEnumerator(rootType)) != null ? enumerator.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(13);
        }
        return stringArray;
    }

    public boolean isValid() {
        return !this.isDisposed() && this.getModule() != null;
    }

    public <R> R accept(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(14);
        }
        return (R)policy.visitModuleOrderEntry((ModuleOrderEntry)this, initialValue);
    }

    @NotNull
    public String getPresentableName() {
        String string = this.getModuleName();
        if (string == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    public boolean isSynthetic() {
        return false;
    }

    @Nullable
    public Module getModule() {
        return this.getRootModel().getConfigurationAccessor().getModule(this.myModulePointer.getModule(), this.myModulePointer.getModuleName());
    }

    @Override
    public void writeExternal(Element rootElement) throws WriteExternalException {
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        element.setAttribute(MODULE_NAME_ATTR, this.getModuleName());
        if (this.myExported) {
            element.setAttribute(EXPORTED_ATTR, "");
        }
        this.myScope.writeExternal(element);
        if (this.myProductionOnTestDependency) {
            element.setAttribute(PRODUCTION_ON_TEST_ATTRIBUTE, "");
        }
        rootElement.addContent(element);
    }

    public String getModuleName() {
        return this.myModulePointer.getModuleName();
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        if (rootModel == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(16);
        }
        if (projectRootManager == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(17);
        }
        if (filePointerManager == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(18);
        }
        ModuleOrderEntryImpl moduleOrderEntryImpl = new ModuleOrderEntryImpl(this, rootModel);
        if (moduleOrderEntryImpl == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(19);
        }
        return moduleOrderEntryImpl;
    }

    public boolean isExported() {
        return this.myExported;
    }

    public void setExported(boolean value) {
        this.getRootModel().assertWritable();
        this.myExported = value;
    }

    @NotNull
    public DependencyScope getScope() {
        DependencyScope dependencyScope = this.myScope;
        if (dependencyScope == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(20);
        }
        return dependencyScope;
    }

    public void setScope(@NotNull DependencyScope scope) {
        if (scope == null) {
            ModuleOrderEntryImpl.$$$reportNull$$$0(21);
        }
        this.getRootModel().assertWritable();
        this.myScope = scope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = ENTRY_TYPE;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointerManager";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/ModuleOrderEntryImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getOwnerModule";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneEntry";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 20: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEnumerator";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "cloneEntry";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 13: 
            case 15: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

