/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.BinaryContentRevision;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListData;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeListsIndexes;
import com.intellij.openapi.vcs.changes.ChangesDelta;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.LocalChangeListImpl;
import com.intellij.openapi.vcs.changes.VcsModifiableDirtyScope;
import com.intellij.openapi.vcs.changes.ui.PlusMinusModify;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeListWorker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.ChangeListWorker");
    private final Project myProject;
    private final Map<String, LocalChangeListImpl> myMap;
    private LocalChangeListImpl myDefault;
    private final ChangeListsIndexes myIdx;
    private final ChangesDelta myDelta;
    private final Set<String> myListsToDisappear;
    private final Map<String, OpenTHashSet<Change>> myChangesBeforeUpdateMap;
    private final Comparator<Pair<Change, String>> CHANGES_AFTER_REVISION_COMPARATOR;

    public ChangeListWorker(@NotNull Project project, @NotNull PlusMinusModify<BaseRevision> deltaListener) {
        if (project == null) {
            ChangeListWorker.$$$reportNull$$$0(0);
        }
        if (deltaListener == null) {
            ChangeListWorker.$$$reportNull$$$0(1);
        }
        this.myChangesBeforeUpdateMap = new HashMap<String, OpenTHashSet<Change>>();
        this.CHANGES_AFTER_REVISION_COMPARATOR = (o1, o2) -> {
            String s1 = ((Change)o1.getFirst()).getAfterRevision().getFile().getPresentableUrl();
            String s2 = ((Change)o2.getFirst()).getAfterRevision().getFile().getPresentableUrl();
            return SystemInfo.isFileSystemCaseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        };
        this.myProject = project;
        this.myMap = new LinkedHashMap<String, LocalChangeListImpl>();
        this.myIdx = new ChangeListsIndexes();
        this.myDelta = new ChangesDelta(deltaListener);
        this.myListsToDisappear = ContainerUtil.newLinkedHashSet();
        this.ensureDefaultListExists();
    }

    private ChangeListWorker(ChangeListWorker worker) {
        this.myChangesBeforeUpdateMap = new HashMap<String, OpenTHashSet<Change>>();
        this.CHANGES_AFTER_REVISION_COMPARATOR = (o1, o2) -> {
            String s1 = ((Change)o1.getFirst()).getAfterRevision().getFile().getPresentableUrl();
            String s2 = ((Change)o2.getFirst()).getAfterRevision().getFile().getPresentableUrl();
            return SystemInfo.isFileSystemCaseSensitive ? s1.compareTo(s2) : s1.compareToIgnoreCase(s2);
        };
        this.myProject = worker.myProject;
        this.myMap = new LinkedHashMap<String, LocalChangeListImpl>();
        this.myIdx = new ChangeListsIndexes(worker.myIdx);
        this.myDelta = worker.myDelta;
        this.myListsToDisappear = ContainerUtil.newLinkedHashSet(worker.myListsToDisappear);
        for (LocalChangeListImpl list2 : worker.myMap.values()) {
            LocalChangeListImpl copy = list2.copy();
            this.myMap.put(copy.getName(), copy);
            if (!copy.isDefault()) continue;
            if (this.myDefault != null) {
                LOG.error("multiple default lists found when copy");
                copy.setDefault(false);
                continue;
            }
            this.myDefault = copy;
        }
        this.ensureDefaultListExists();
    }

    private void ensureDefaultListExists() {
        if (this.myDefault != null) {
            return;
        }
        if (!this.myMap.isEmpty()) {
            this.myDefault = this.myMap.values().iterator().next();
            this.myDefault.setDefault(true);
        } else {
            this.myDefault = LocalChangeListImpl.createEmptyChangeListImpl(this.myProject, LocalChangeList.DEFAULT_NAME, null);
            this.myDefault.setDefault(true);
            this.myMap.put(this.myDefault.getName(), this.myDefault);
        }
    }

    public void onAfterWorkerSwitch(@NotNull ChangeListWorker previous) {
        if (previous == null) {
            ChangeListWorker.$$$reportNull$$$0(2);
        }
        boolean somethingChanged = this.myDelta.notifyPathsChanged(previous.myIdx, this.myIdx);
        if (somethingChanged |= this.checkForMultipleCopiesNotMove()) {
            FileStatusManager.getInstance((Project)this.myProject).fileStatusesChanged();
        }
    }

    private boolean checkForMultipleCopiesNotMove() {
        boolean somethingChanged = false;
        MultiMap moves = new MultiMap();
        for (LocalChangeList localChangeList : this.myMap.values()) {
            Collection changes = localChangeList.getChanges();
            for (Change change : changes) {
                if (!change.isMoved() && !change.isRenamed()) continue;
                moves.putValue((Object)change.getBeforeRevision().getFile(), (Object)Pair.create((Object)change, (Object)localChangeList.getName()));
            }
        }
        for (FilePath filePath : moves.keySet()) {
            List copies = (List)moves.get((Object)filePath);
            if (copies.size() == 1) continue;
            copies.sort(this.CHANGES_AFTER_REVISION_COMPARATOR);
            for (int i = 0; i < copies.size() - 1; ++i) {
                somethingChanged = true;
                Pair item = (Pair)copies.get(i);
                Change oldChange = (Change)item.getFirst();
                Change newChange = new Change(null, oldChange.getAfterRevision());
                LocalChangeListImpl list2 = this.myMap.get(item.getSecond());
                list2.removeChange(oldChange);
                list2.addChange(newChange);
                VcsKey key = this.myIdx.getVcsFor(oldChange);
                this.myIdx.changeRemoved(oldChange);
                this.myIdx.changeAdded(newChange, key);
            }
        }
        return somethingChanged;
    }

    public ChangeListWorker copy() {
        return new ChangeListWorker(this);
    }

    @Nullable
    public LocalChangeList getChangeListByName(@Nullable String name) {
        return this.myMap.get(name);
    }

    @Nullable
    public LocalChangeList getChangeListCopyByName(@Nullable String name) {
        LocalChangeList list2 = this.getChangeListByName(name);
        return list2 != null ? list2.copy() : null;
    }

    @Nullable
    public LocalChangeList getChangeListById(@Nullable String id) {
        for (LocalChangeList localChangeList : this.myMap.values()) {
            if (!localChangeList.getId().equals(id)) continue;
            return localChangeList;
        }
        return null;
    }

    @Nullable
    public String setDefault(String name) {
        LocalChangeListImpl newDefault = this.myMap.get(name);
        if (newDefault == null) {
            return null;
        }
        String previousName = this.myDefault.getName();
        this.myDefault.setDefault(false);
        newDefault.setDefault(true);
        this.myDefault = newDefault;
        return previousName;
    }

    public boolean setReadOnly(String name, boolean value) {
        LocalChangeListImpl list2 = this.myMap.get(name);
        if (list2 != null) {
            list2.setReadOnlyImpl(value);
        }
        return list2 != null;
    }

    @NotNull
    public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment, @Nullable String id, @Nullable ChangeListData data) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(3);
        }
        LocalChangeList localChangeList = this.addChangeList(name, comment, id, data, false);
        if (localChangeList == null) {
            ChangeListWorker.$$$reportNull$$$0(4);
        }
        return localChangeList;
    }

    @NotNull
    private LocalChangeList addChangeList(@NotNull String name, @Nullable String description, @Nullable String id, @Nullable ChangeListData data, boolean inUpdate) {
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(5);
        }
        if (this.myMap.containsKey(name)) {
            LOG.error("Attempt to create duplicate changelist " + name);
            LocalChangeList localChangeList = this.myMap.get(name);
            if (localChangeList == null) {
                ChangeListWorker.$$$reportNull$$$0(6);
            }
            return localChangeList;
        }
        LocalChangeListImpl newList = LocalChangeListImpl.createEmptyChangeListImpl(this.myProject, name, id);
        newList.setCommentImpl(description);
        newList.setData(data);
        this.myMap.put(name, newList);
        if (inUpdate) {
            this.startProcessingChanges(newList);
        }
        LocalChangeListImpl localChangeListImpl = newList;
        if (localChangeListImpl == null) {
            ChangeListWorker.$$$reportNull$$$0(7);
        }
        return localChangeListImpl;
    }

    void setChangeLists(@NotNull Collection<LocalChangeListImpl> lists) {
        if (lists == null) {
            ChangeListWorker.$$$reportNull$$$0(8);
        }
        this.myDefault = null;
        this.myMap.clear();
        this.myIdx.clear();
        for (LocalChangeListImpl list2 : lists) {
            this.myMap.put(list2.getName(), list2);
            if (list2.isDefault()) {
                if (this.myDefault != null) {
                    LOG.error("multiple default lists found");
                    list2.setDefault(false);
                } else {
                    this.myDefault = list2;
                }
            }
            for (Change change : list2.getChanges()) {
                this.myIdx.changeAdded(change, null);
            }
        }
        this.ensureDefaultListExists();
    }

    private void addChangeToList(@NotNull LocalChangeListImpl list2, @NotNull Change change, VcsKey vcsKey) {
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(9);
        }
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(10);
        }
        list2.addChange(change);
        this.myIdx.changeAdded(change, vcsKey);
    }

    public void addChangeToList(@NotNull String name, @NotNull Change change, VcsKey vcsKey) {
        LocalChangeListImpl changeList;
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(11);
        }
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(12);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("[addChangeToList] name: " + name + " change: " + ChangesUtil.getFilePath((Change)change).getPath() + " vcs: " + (vcsKey == null ? null : vcsKey.getName()));
        }
        if ((changeList = this.myMap.get(name)) == null) {
            return;
        }
        this.addChangeToList(changeList, change, vcsKey);
    }

    public void addChangeToCorrespondingList(@NotNull Change change, VcsKey vcsKey) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(13);
        }
        if (LOG.isDebugEnabled()) {
            String path = ChangesUtil.getFilePath((Change)change).getPath();
            LOG.debug("[addChangeToCorrespondingList] for change " + path + " type: " + change.getType() + " have before revision: " + (change.getBeforeRevision() != null));
        }
        for (LocalChangeListImpl list2 : this.myMap.values()) {
            OpenTHashSet<Change> changesBeforeUpdate = this.myChangesBeforeUpdateMap.get(list2.getName());
            if (!changesBeforeUpdate.contains((Object)change)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("[addChangeToCorrespondingList] matched: " + list2.getName());
            }
            this.addChangeToList(list2, change, vcsKey);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("[addChangeToCorrespondingList] added to default list");
        }
        this.addChangeToList(this.myDefault, change, vcsKey);
    }

    public boolean removeChangeList(@NotNull String name) {
        LocalChangeList list2;
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(14);
        }
        if ((list2 = (LocalChangeList)this.myMap.get(name)) == null) {
            return false;
        }
        if (list2.isDefault()) {
            LOG.error("Cannot remove default changelist");
            return false;
        }
        for (Change change : list2.getChanges()) {
            this.myDefault.addChange(change);
        }
        this.myMap.remove(name);
        return true;
    }

    @Nullable
    public MultiMap<LocalChangeList, Change> moveChangesTo(String name, @NotNull Change[] changes) {
        LocalChangeListImpl changeList;
        if (changes == null) {
            ChangeListWorker.$$$reportNull$$$0(15);
        }
        if ((changeList = this.myMap.get(name)) != null) {
            MultiMap result2 = new MultiMap();
            for (LocalChangeListImpl list2 : this.myMap.values()) {
                if (list2.equals((Object)changeList)) continue;
                for (Change change : changes) {
                    Change removedChange = list2.removeChange(change);
                    if (removedChange == null) continue;
                    changeList.addChange(removedChange);
                    result2.putValue((Object)list2, (Object)removedChange);
                }
            }
            return result2;
        }
        return null;
    }

    public boolean editName(@NotNull String fromName, @NotNull String toName) {
        OpenTHashSet<Change> changesBeforeUpdateFrom;
        OpenTHashSet<Change> changesBeforeUpdateTo;
        if (fromName == null) {
            ChangeListWorker.$$$reportNull$$$0(16);
        }
        if (toName == null) {
            ChangeListWorker.$$$reportNull$$$0(17);
        }
        if (fromName.equals(toName)) {
            return false;
        }
        if (this.myMap.containsKey(toName)) {
            return false;
        }
        LocalChangeListImpl list2 = this.myMap.get(fromName);
        if (list2 == null || list2.isReadOnly()) {
            return false;
        }
        LocalChangeListImpl newList = list2.copy(toName);
        this.myMap.remove(fromName);
        this.myMap.put(toName, newList);
        if (newList.isDefault()) {
            this.myDefault = newList;
        }
        LOG.assertTrue((changesBeforeUpdateTo = this.myChangesBeforeUpdateMap.put(toName, changesBeforeUpdateFrom = this.myChangesBeforeUpdateMap.remove(fromName))) == null, (Object)"old changes for new changelist name found during rename");
        return true;
    }

    @Nullable
    public String editComment(@NotNull String name, @Nullable String newComment) {
        LocalChangeListImpl list2;
        if (name == null) {
            ChangeListWorker.$$$reportNull$$$0(18);
        }
        if ((list2 = this.myMap.get(name)) == null) {
            return null;
        }
        String oldComment = list2.getComment();
        if (!Comparing.equal((String)oldComment, (String)newComment)) {
            list2.setCommentImpl(newComment);
        }
        return oldComment;
    }

    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @NotNull
    public LocalChangeList getDefaultList() {
        LocalChangeListImpl localChangeListImpl = this.myDefault;
        if (localChangeListImpl == null) {
            ChangeListWorker.$$$reportNull$$$0(19);
        }
        return localChangeListImpl;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            ChangeListWorker.$$$reportNull$$$0(20);
        }
        return project;
    }

    public void notifyStartProcessingChanges(@Nullable VcsModifiableDirtyScope scope) {
        ArrayList<Change> removedChanges = new ArrayList<Change>();
        for (LocalChangeListImpl list2 : this.myMap.values()) {
            this.startProcessingChanges(list2);
            removedChanges.addAll(this.removeChangesUnderScope(list2, scope));
        }
        if (scope != null) {
            for (Change change : removedChanges) {
                if (!change.isMoved() && !change.isRenamed()) continue;
                scope.addDirtyFile(change.getBeforeRevision().getFile());
                scope.addDirtyFile(change.getAfterRevision().getFile());
            }
        }
    }

    public void notifyDoneProcessingChanges(ChangeListListener dispatcher) {
        ArrayList<LocalChangeListImpl> changedLists = new ArrayList<LocalChangeListImpl>();
        HashMap<LocalChangeListImpl, ArrayList<Change>> removedChanges = new HashMap<LocalChangeListImpl, ArrayList<Change>>();
        HashMap<LocalChangeListImpl, ArrayList<Change>> addedChanges = new HashMap<LocalChangeListImpl, ArrayList<Change>>();
        for (LocalChangeListImpl localChangeListImpl : this.myMap.values()) {
            ArrayList<Change> added;
            ArrayList<Change> removed;
            if (this.doneProcessingChanges(localChangeListImpl, removed = new ArrayList<Change>(), added = new ArrayList<Change>())) {
                changedLists.add(localChangeListImpl);
            }
            if (!removed.isEmpty()) {
                removedChanges.put(localChangeListImpl, removed);
            }
            if (added.isEmpty()) continue;
            addedChanges.put(localChangeListImpl, added);
        }
        for (Map.Entry entry : removedChanges.entrySet()) {
            dispatcher.changesRemoved((Collection)entry.getValue(), (ChangeList)entry.getKey());
        }
        for (Map.Entry entry : addedChanges.entrySet()) {
            dispatcher.changesAdded((Collection)entry.getValue(), (ChangeList)entry.getKey());
        }
        for (ChangeList changeList : changedLists) {
            dispatcher.changeListChanged(changeList);
        }
        for (String string : this.myListsToDisappear) {
            LocalChangeList changeList = this.myMap.get(string);
            if (changeList == null || !changeList.getChanges().isEmpty() || changeList.isReadOnly() || changeList.isDefault()) continue;
            this.removeChangeList(string);
        }
        this.myListsToDisappear.clear();
        this.myChangesBeforeUpdateMap.clear();
    }

    private void startProcessingChanges(@NotNull LocalChangeListImpl list2) {
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(21);
        }
        OpenTHashSet changesBeforeUpdate = new OpenTHashSet(list2.getChanges());
        this.myChangesBeforeUpdateMap.put(list2.getName(), (OpenTHashSet<Change>)changesBeforeUpdate);
    }

    @NotNull
    private List<Change> removeChangesUnderScope(@NotNull LocalChangeListImpl list2, @Nullable VcsModifiableDirtyScope scope) {
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(22);
        }
        ArrayList<Change> removed = new ArrayList<Change>();
        for (Change change : list2.getChanges()) {
            ContentRevision before = change.getBeforeRevision();
            ContentRevision after = change.getAfterRevision();
            boolean isUnderScope = scope == null || before != null && scope.belongsTo(before.getFile()) || after != null && scope.belongsTo(after.getFile()) || ChangeListWorker.isIgnoredChange(before, after, this.myProject);
            if (!isUnderScope) continue;
            list2.removeChange(change);
            this.myIdx.changeRemoved(change);
            removed.add(change);
        }
        ArrayList<Change> arrayList = removed;
        if (arrayList == null) {
            ChangeListWorker.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    private static boolean isIgnoredChange(@Nullable ContentRevision before, @Nullable ContentRevision after, @NotNull Project project) {
        if (project == null) {
            ChangeListWorker.$$$reportNull$$$0(24);
        }
        return ChangeListWorker.isIgnoredRevision(before, project) && ChangeListWorker.isIgnoredRevision(after, project);
    }

    private static boolean isIgnoredRevision(@Nullable ContentRevision revision, @NotNull Project project) {
        if (project == null) {
            ChangeListWorker.$$$reportNull$$$0(25);
        }
        if (revision == null) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project == null) {
                ChangeListWorker.$$$reportNull$$$0(49);
            }
            if (project.isDisposed()) {
                return false;
            }
            VirtualFile vFile = revision.getFile().getVirtualFile();
            return vFile != null && ProjectLevelVcsManager.getInstance((Project)project).isIgnored(vFile);
        });
    }

    private boolean doneProcessingChanges(@NotNull LocalChangeListImpl list2, @NotNull List<Change> removedChanges, @NotNull List<Change> addedChanges) {
        if (list2 == null) {
            ChangeListWorker.$$$reportNull$$$0(26);
        }
        if (removedChanges == null) {
            ChangeListWorker.$$$reportNull$$$0(27);
        }
        if (addedChanges == null) {
            ChangeListWorker.$$$reportNull$$$0(28);
        }
        OpenTHashSet<Change> changesBeforeUpdate = this.myChangesBeforeUpdateMap.get(list2.getName());
        Collection changes = list2.getChanges();
        for (Change newChange : changes) {
            Change oldChange = ChangeListWorker.findOldChange(changesBeforeUpdate, newChange);
            if (oldChange != null) continue;
            addedChanges.add(newChange);
        }
        removedChanges.addAll((Collection<Change>)changesBeforeUpdate);
        removedChanges.removeAll(changes);
        return changes.size() != changesBeforeUpdate.size() || !addedChanges.isEmpty() || !removedChanges.isEmpty();
    }

    @Nullable
    private static Change findOldChange(@NotNull OpenTHashSet<Change> changesBeforeUpdate, @NotNull Change newChange) {
        Change oldChange;
        if (changesBeforeUpdate == null) {
            ChangeListWorker.$$$reportNull$$$0(29);
        }
        if (newChange == null) {
            ChangeListWorker.$$$reportNull$$$0(30);
        }
        if ((oldChange = (Change)changesBeforeUpdate.get((Object)newChange)) != null && ChangeListWorker.sameBeforeRevision(oldChange, newChange) && newChange.getFileStatus().equals(oldChange.getFileStatus())) {
            return oldChange;
        }
        return null;
    }

    private static boolean sameBeforeRevision(@NotNull Change change1, @NotNull Change change2) {
        if (change1 == null) {
            ChangeListWorker.$$$reportNull$$$0(31);
        }
        if (change2 == null) {
            ChangeListWorker.$$$reportNull$$$0(32);
        }
        ContentRevision b1 = change1.getBeforeRevision();
        ContentRevision b2 = change2.getBeforeRevision();
        if (b1 != null && b2 != null) {
            VcsRevisionNumber rn1 = b1.getRevisionNumber();
            VcsRevisionNumber rn2 = b2.getRevisionNumber();
            boolean isBinary1 = b1 instanceof BinaryContentRevision;
            boolean isBinary2 = b2 instanceof BinaryContentRevision;
            return rn1 != VcsRevisionNumber.NULL && rn2 != VcsRevisionNumber.NULL && rn1.compareTo((Object)rn2) == 0 && isBinary1 == isBinary2;
        }
        return b1 == null && b2 == null;
    }

    @NotNull
    public List<LocalChangeList> getChangeLists() {
        ArrayList<LocalChangeList> arrayList = new ArrayList<LocalChangeList>(this.myMap.values());
        if (arrayList == null) {
            ChangeListWorker.$$$reportNull$$$0(33);
        }
        return arrayList;
    }

    @NotNull
    public List<File> getAffectedPaths() {
        Set<FilePath> set2 = this.myIdx.getAffectedPaths();
        ArrayList<File> result2 = new ArrayList<File>(set2.size());
        for (FilePath path : set2) {
            result2.add(path.getIOFile());
        }
        ArrayList<File> arrayList = result2;
        if (arrayList == null) {
            ChangeListWorker.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    public List<VirtualFile> getAffectedFiles() {
        LinkedHashSet result2 = ContainerUtil.newLinkedHashSet();
        for (LocalChangeList localChangeList : this.myMap.values()) {
            for (Change change : localChangeList.getChanges()) {
                VirtualFile file2;
                VirtualFile file22;
                ContentRevision before = change.getBeforeRevision();
                ContentRevision after = change.getAfterRevision();
                if (before != null && (file22 = before.getFile().getVirtualFile()) != null) {
                    result2.add(file22);
                }
                if (after == null || (file2 = after.getFile().getVirtualFile()) == null) continue;
                result2.add(file2);
            }
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>(result2);
        if (arrayList == null) {
            ChangeListWorker.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    @Nullable
    public LocalChangeList getChangeListFor(@NotNull VirtualFile file2) {
        FilePath filePath;
        Pair<LocalChangeListImpl, Change> pair;
        if (file2 == null) {
            ChangeListWorker.$$$reportNull$$$0(36);
        }
        if ((pair = this.getChangeAndListByPath(filePath = VcsUtil.getFilePath((VirtualFile)file2))) == null) {
            return null;
        }
        return (LocalChangeList)pair.first;
    }

    public void removeRegisteredChangeFor(@Nullable FilePath filePath) {
        this.myIdx.remove(filePath);
        Pair<LocalChangeListImpl, Change> pair = this.getChangeAndListByPath(filePath);
        if (pair == null) {
            return;
        }
        LocalChangeListImpl list2 = (LocalChangeListImpl)((Object)pair.first);
        Change change = (Change)pair.second;
        list2.removeChange(change);
    }

    @Nullable
    public Change getChangeForPath(@Nullable FilePath filePath) {
        Pair<LocalChangeListImpl, Change> pair = this.getChangeAndListByPath(filePath);
        if (pair == null) {
            return null;
        }
        return (Change)pair.second;
    }

    @Nullable
    private Pair<LocalChangeListImpl, Change> getChangeAndListByPath(@Nullable FilePath filePath) {
        if (filePath == null) {
            return null;
        }
        for (LocalChangeListImpl list2 : this.myMap.values()) {
            for (Change change : list2.getChanges()) {
                ContentRevision before = change.getBeforeRevision();
                ContentRevision after = change.getAfterRevision();
                if ((before == null || !before.getFile().equals(filePath)) && (after == null || !after.getFile().equals(filePath))) continue;
                return Pair.create((Object)((Object)list2), (Object)change);
            }
        }
        return null;
    }

    @Nullable
    public FileStatus getStatus(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ChangeListWorker.$$$reportNull$$$0(37);
        }
        return this.myIdx.getStatus(file2);
    }

    @Nullable
    public FileStatus getStatus(@NotNull FilePath file2) {
        if (file2 == null) {
            ChangeListWorker.$$$reportNull$$$0(38);
        }
        return this.myIdx.getStatus(file2);
    }

    @NotNull
    public Collection<Change> getAllChanges() {
        HashSet<Change> changes = new HashSet<Change>();
        for (LocalChangeList localChangeList : this.myMap.values()) {
            changes.addAll(localChangeList.getChanges());
        }
        HashSet<Change> hashSet = changes;
        if (hashSet == null) {
            ChangeListWorker.$$$reportNull$$$0(39);
        }
        return hashSet;
    }

    public int getChangeListsNumber() {
        return this.myMap.size();
    }

    @NotNull
    public Collection<LocalChangeList> getInvolvedListsFilterChanges(@NotNull Collection<Change> changes, @NotNull List<Change> validChanges) {
        if (changes == null) {
            ChangeListWorker.$$$reportNull$$$0(40);
        }
        if (validChanges == null) {
            ChangeListWorker.$$$reportNull$$$0(41);
        }
        HashSet<LocalChangeList> includedListsCopies = new HashSet<LocalChangeList>();
        HashMap<Change, LocalChangeList> internalMap = new HashMap<Change, LocalChangeList>();
        for (LocalChangeList localChangeList : this.myMap.values()) {
            for (Change change : localChangeList.getChanges()) {
                internalMap.put(change, localChangeList);
            }
        }
        for (Change change : changes) {
            LocalChangeList list3 = (LocalChangeList)internalMap.get(change);
            if (list3 == null) continue;
            includedListsCopies.add(list3);
            validChanges.add(change);
        }
        HashSet<LocalChangeList> hashSet = includedListsCopies;
        if (hashSet == null) {
            ChangeListWorker.$$$reportNull$$$0(42);
        }
        return hashSet;
    }

    @Nullable
    public LocalChangeList getChangeListForChange(Change change) {
        for (LocalChangeList localChangeList : this.myMap.values()) {
            if (!localChangeList.getChanges().contains(change)) continue;
            return localChangeList;
        }
        return null;
    }

    @Nullable
    public LocalChangeList getChangeListIfOnlyOne(@Nullable Change[] changes) {
        if (changes == null || changes.length == 0) {
            return null;
        }
        Change first = changes[0];
        for (LocalChangeList localChangeList : this.myMap.values()) {
            Collection listChanges = localChangeList.getChanges();
            if (!listChanges.contains(first)) continue;
            for (int i = 1; i < changes.length; ++i) {
                Change change = changes[i];
                if (listChanges.contains(change)) continue;
                return null;
            }
            return localChangeList;
        }
        return null;
    }

    public ThreeState haveChangesUnder(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            ChangeListWorker.$$$reportNull$$$0(43);
        }
        FilePath dir = VcsUtil.getFilePath((VirtualFile)virtualFile);
        return this.myIdx.haveChangesUnder(dir);
    }

    @NotNull
    public List<Change> getChangesIn(@NotNull FilePath dirPath) {
        if (dirPath == null) {
            ChangeListWorker.$$$reportNull$$$0(44);
        }
        ArrayList<Change> changes = new ArrayList<Change>();
        for (ChangeList changeList : this.myMap.values()) {
            for (Change change : changeList.getChanges()) {
                ContentRevision after = change.getAfterRevision();
                ContentRevision before = change.getBeforeRevision();
                if ((after == null || !after.getFile().isUnder(dirPath, false)) && (before == null || !before.getFile().isUnder(dirPath, false))) continue;
                changes.add(change);
            }
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            ChangeListWorker.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    @Nullable
    public VcsKey getVcsFor(@NotNull Change change) {
        if (change == null) {
            ChangeListWorker.$$$reportNull$$$0(46);
        }
        return this.myIdx.getVcsFor(change);
    }

    public void setListsToDisappear(@NotNull Collection<String> names) {
        if (names == null) {
            ChangeListWorker.$$$reportNull$$$0(47);
        }
        this.myListsToDisappear.addAll(names);
    }

    @NotNull
    public ChangeListManagerGate createGate() {
        MyGate myGate = new MyGate(this);
        if (myGate == null) {
            ChangeListWorker.$$$reportNull$$$0(48);
        }
        return myGate;
    }

    public String toString() {
        return String.format("ChangeListWorker{myMap=%s}", StringUtil.join(this.myMap.values(), list2 -> String.format("list: %s changes: %s", list2.getName(), StringUtil.join((Iterable)list2.getChanges(), (String)", ")), (String)"\n"));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 42: 
            case 45: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 42: 
            case 45: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deltaListener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previous";
                break;
            }
            case 3: 
            case 5: 
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListWorker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 9: 
            case 21: 
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 15: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toName";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removedChanges";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedChanges";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesBeforeUpdate";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChange";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change1";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change2";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validChanges";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirPath";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListWorker";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "addChangeList";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultList";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "removeChangesUnderScope";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeLists";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedPaths";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedFiles";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllChanges";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvolvedListsFilterChanges";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesIn";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createGate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "onAfterWorkerSwitch";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addChangeList";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 42: 
            case 45: 
            case 48: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setChangeLists";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addChangeToList";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addChangeToCorrespondingList";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeChangeList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "moveChangesTo";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "editName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "editComment";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "startProcessingChanges";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeChangesUnderScope";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredChange";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredRevision";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doneProcessingChanges";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findOldChange";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "sameBeforeRevision";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getChangeListFor";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getStatus";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getInvolvedListsFilterChanges";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "haveChangesUnder";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getChangesIn";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getVcsFor";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "setListsToDisappear";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isIgnoredRevision$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 23: 
            case 33: 
            case 34: 
            case 35: 
            case 39: 
            case 42: 
            case 45: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyGate
    implements ChangeListManagerGate {
        private final ChangeListWorker myWorker;

        private MyGate(ChangeListWorker worker) {
            this.myWorker = worker;
        }

        @NotNull
        public List<LocalChangeList> getListsCopy() {
            List list2 = ContainerUtil.map(this.myWorker.getChangeLists(), LocalChangeList::copy);
            if (list2 == null) {
                MyGate.$$$reportNull$$$0(0);
            }
            return list2;
        }

        @Nullable
        public LocalChangeList findChangeList(String name) {
            return this.myWorker.getChangeListCopyByName(name);
        }

        @NotNull
        public LocalChangeList addChangeList(@NotNull String name, @Nullable String comment) {
            if (name == null) {
                MyGate.$$$reportNull$$$0(1);
            }
            LocalChangeList localChangeList = this.myWorker.addChangeList(name, comment, null, null, true).copy();
            if (localChangeList == null) {
                MyGate.$$$reportNull$$$0(2);
            }
            return localChangeList;
        }

        @NotNull
        public LocalChangeList findOrCreateList(@NotNull String name, String comment) {
            LocalChangeList list2;
            if (name == null) {
                MyGate.$$$reportNull$$$0(3);
            }
            if ((list2 = this.myWorker.getChangeListByName(name)) == null) {
                list2 = this.addChangeList(name, comment);
            }
            LocalChangeList localChangeList = list2.copy();
            if (localChangeList == null) {
                MyGate.$$$reportNull$$$0(4);
            }
            return localChangeList;
        }

        public void editComment(@NotNull String name, String comment) {
            if (name == null) {
                MyGate.$$$reportNull$$$0(5);
            }
            this.myWorker.editComment(name, comment);
        }

        public void editName(@NotNull String oldName, @NotNull String newName) {
            if (oldName == null) {
                MyGate.$$$reportNull$$$0(6);
            }
            if (newName == null) {
                MyGate.$$$reportNull$$$0(7);
            }
            this.myWorker.editName(oldName, newName);
        }

        public void setListsToDisappear(@NotNull Collection<String> names) {
            if (names == null) {
                MyGate.$$$reportNull$$$0(8);
            }
            this.myWorker.setListsToDisappear(names);
        }

        public FileStatus getStatus(@NotNull VirtualFile file2) {
            if (file2 == null) {
                MyGate.$$$reportNull$$$0(9);
            }
            return this.myWorker.getStatus(file2);
        }

        @Deprecated
        public FileStatus getStatus(@NotNull File file2) {
            if (file2 == null) {
                MyGate.$$$reportNull$$$0(10);
            }
            return this.myWorker.getStatus(VcsUtil.getFilePath((File)file2));
        }

        public FileStatus getStatus(@NotNull FilePath filePath) {
            if (filePath == null) {
                MyGate.$$$reportNull$$$0(11);
            }
            return this.myWorker.getStatus(filePath);
        }

        public void setDefaultChangeList(@NotNull String list2) {
            if (list2 == null) {
                MyGate.$$$reportNull$$$0(12);
            }
            this.myWorker.setDefault(list2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate";
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getListsCopy";
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/changes/ChangeListWorker$MyGate";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "addChangeList";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findOrCreateList";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "addChangeList";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findOrCreateList";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "editComment";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "editName";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "setListsToDisappear";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getStatus";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "setDefaultChangeList";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

