/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.xml.impl.events;

import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomChangeSet;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlAttributeSet;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;

public class XmlAttributeSetImpl
implements XmlAttributeSet {
    private final String myName;
    private final String myValue;
    private final XmlTag myTag;

    public XmlAttributeSetImpl(XmlTag xmlTag, String name, String value) {
        this.myName = name;
        this.myValue = value;
        this.myTag = xmlTag;
    }

    public String getName() {
        return this.myName;
    }

    public String getValue() {
        return this.myValue;
    }

    public XmlTag getTag() {
        return this.myTag;
    }

    public static PomModelEvent createXmlAttributeSet(PomModel model, XmlTag xmlTag, String name, String value) {
        PomModelEvent event = new PomModelEvent(model);
        XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(model, (XmlFile)PsiTreeUtil.getParentOfType((PsiElement)xmlTag, XmlFile.class));
        xmlAspectChangeSet.add((XmlChange)new XmlAttributeSetImpl(xmlTag, name, value));
        event.registerChangeSet(model.getModelAspect(XmlAspect.class), (PomChangeSet)xmlAspectChangeSet);
        return event;
    }

    public String toString() {
        return "Attribute \"" + this.getName() + "\" for tag \"" + this.getTag().getName() + "\" set to \"" + this.getValue() + "\"";
    }
}

