/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl.id;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ThreadLocalCachedIntArray;
import com.intellij.psi.impl.cache.impl.id.IdIndex;
import com.intellij.psi.impl.cache.impl.id.IdIndexEntry;
import com.intellij.psi.impl.cache.impl.id.IdIndexer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.util.indexing.CustomInputsIndexFileBasedIndexExtension;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class IdIndexImpl
extends IdIndex
implements CustomInputsIndexFileBasedIndexExtension<IdIndexEntry> {
    private static final ThreadLocalCachedIntArray spareBufferLocal = new ThreadLocalCachedIntArray();
    private final FileTypeRegistry myFileTypeManager;

    public IdIndexImpl(FileTypeRegistry manager) {
        this.myFileTypeManager = manager;
    }

    @Override
    public int getVersion() {
        FileType[] types = this.myFileTypeManager.getRegisteredFileTypes();
        Arrays.sort(types, (o1, o2) -> Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName())));
        int version = super.getVersion();
        for (FileType fileType : types) {
            IdIndexer indexer;
            if (!IdIndexImpl.isIndexable(fileType) || (indexer = IdTableBuilding.getFileTypeIndexer(fileType)) == null) continue;
            version = version * 31 + (indexer.getVersion() ^ indexer.getClass().getName().hashCode());
        }
        return version;
    }

    @Override
    @NotNull
    public DataExternalizer<Collection<IdIndexEntry>> createExternalizer() {
        DataExternalizer<Collection<IdIndexEntry>> dataExternalizer = new DataExternalizer<Collection<IdIndexEntry>>(){

            public void save(@NotNull DataOutput out, @NotNull Collection<IdIndexEntry> value) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                int size = value.size();
                int[] values = spareBufferLocal.getBuffer(size);
                int ptr = 0;
                for (IdIndexEntry ie : value) {
                    values[ptr++] = ie.getWordHashCode();
                }
                Arrays.sort(values, 0, size);
                DataInputOutputUtil.writeINT((DataOutput)out, (int)size);
                int prev = 0;
                for (int i = 0; i < size; ++i) {
                    DataInputOutputUtil.writeLONG((DataOutput)out, (long)((long)values[i] - (long)prev));
                    prev = values[i];
                }
            }

            public Collection<IdIndexEntry> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(2);
                }
                int length = DataInputOutputUtil.readINT((DataInput)in);
                ArrayList<IdIndexEntry> entries = new ArrayList<IdIndexEntry>(length);
                int prev = 0;
                while (length-- > 0) {
                    int l = (int)(DataInputOutputUtil.readLONG((DataInput)in) + (long)prev);
                    entries.add(new IdIndexEntry(l));
                    prev = l;
                }
                return entries;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/id/IdIndexImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dataExternalizer == null) {
            IdIndexImpl.$$$reportNull$$$0(0);
        }
        return dataExternalizer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/cache/impl/id/IdIndexImpl", "createExternalizer"));
    }
}

