/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.smartPointers.Identikit;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerTracker;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class AnchorElementInfo
extends SelfElementInfo {
    private volatile long myStubElementTypeAndId;

    AnchorElementInfo(@NotNull PsiElement anchor, @NotNull PsiFile containingFile, Identikit.ByAnchor identikit) {
        if (anchor == null) {
            AnchorElementInfo.$$$reportNull$$$0(0);
        }
        if (containingFile == null) {
            AnchorElementInfo.$$$reportNull$$$0(1);
        }
        super(containingFile.getProject(), ProperTextRange.create((Segment)anchor.getTextRange()), identikit, containingFile, false);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    AnchorElementInfo(@NotNull PsiElement anchor, @NotNull PsiFileWithStubSupport containingFile, int stubId, @NotNull IStubElementType stubElementType) {
        if (anchor == null) {
            AnchorElementInfo.$$$reportNull$$$0(2);
        }
        if (containingFile == null) {
            AnchorElementInfo.$$$reportNull$$$0(3);
        }
        if (stubElementType == null) {
            AnchorElementInfo.$$$reportNull$$$0(4);
        }
        super(containingFile.getProject(), null, Identikit.fromTypes(anchor.getClass(), (IElementType)stubElementType, LanguageUtil.getRootLanguage((PsiElement)containingFile)), containingFile, false);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(stubId, stubElementType);
        assert (!(anchor instanceof PsiFile)) : "FileElementInfo must be used for file: " + anchor;
    }

    private static long pack(int stubId, IStubElementType stubElementType) {
        short index;
        short s = index = stubElementType == null ? (short)0 : stubElementType.getIndex();
        assert (index >= 0) : "Unregistered token types not allowed here: " + stubElementType;
        return (long)stubId | (long)index << 32;
    }

    private int getStubId() {
        return (int)this.myStubElementTypeAndId;
    }

    @Override
    @Nullable
    public PsiElement restoreElement() {
        long typeAndId = this.myStubElementTypeAndId;
        int stubId = (int)typeAndId;
        if (stubId != -1) {
            PsiFile file2 = this.restoreFile();
            if (!(file2 instanceof PsiFileWithStubSupport)) {
                return null;
            }
            short index = (short)(typeAndId >> 32);
            IStubElementType stubElementType = (IStubElementType)IElementType.find((short)index);
            return PsiAnchor.restoreFromStubIndex((PsiFileWithStubSupport)file2, stubId, stubElementType, false);
        }
        return super.restoreElement();
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            AnchorElementInfo.$$$reportNull$$$0(5);
        }
        if (other instanceof AnchorElementInfo) {
            if (!this.getVirtualFile().equals(other.getVirtualFile())) {
                return false;
            }
            long packed1 = this.myStubElementTypeAndId;
            long packed2 = ((AnchorElementInfo)other).myStubElementTypeAndId;
            if (packed1 != -1L && packed2 != -1L) {
                return packed1 == packed2;
            }
            if (packed1 != -1L || packed2 != -1L) {
                return (Boolean)ReadAction.compute(() -> {
                    if (other == null) {
                        AnchorElementInfo.$$$reportNull$$$0(7);
                    }
                    return Comparing.equal((Object)this.restoreElement(), (Object)other.restoreElement());
                });
            }
        }
        return super.pointsToTheSameElementAs(other);
    }

    @Override
    public void fastenBelt() {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        super.fastenBelt();
    }

    private void switchToTree() {
        PsiElement element = this.restoreElement();
        SmartPointerTracker tracker = this.myManager.getTracker(this.getVirtualFile());
        if (element != null && tracker != null) {
            tracker.switchStubToAst(this, element);
        }
    }

    void switchToTreeRange(@NotNull PsiElement element) {
        if (element == null) {
            AnchorElementInfo.$$$reportNull$$$0(6);
        }
        this.switchToAnchor(element);
        this.myStubElementTypeAndId = AnchorElementInfo.pack(-1, null);
    }

    @Override
    public Segment getRange() {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        return super.getRange();
    }

    @Override
    @Nullable
    public TextRange getPsiRange() {
        if (this.getStubId() != -1) {
            this.switchToTree();
        }
        return super.getPsiRange();
    }

    @Override
    public String toString() {
        return super.toString() + ",stubId=" + this.getStubId();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubElementType";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/smartPointers/AnchorElementInfo";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "pointsToTheSameElementAs";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "switchToTreeRange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$pointsToTheSameElementAs$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

