/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.stripe;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.stripe.ErrorStripe;
import com.intellij.ui.stripe.ErrorStripePainter;
import com.intellij.ui.stripe.ExtraErrorStripePainter;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.RegionPainter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;

public abstract class Updater<Painter extends ErrorStripePainter>
implements Disposable {
    private final Painter myPainter;
    private final JScrollBar myScrollBar;
    private final MergingUpdateQueue myQueue;
    private final MouseAdapter myMouseAdapter;

    protected Updater(@NotNull Painter painter, JScrollPane pane) {
        if (painter == null) {
            Updater.$$$reportNull$$$0(0);
        }
        this(painter, pane.getVerticalScrollBar());
    }

    protected Updater(@NotNull Painter painter, JScrollBar bar) {
        if (painter == null) {
            Updater.$$$reportNull$$$0(1);
        }
        this.myMouseAdapter = new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                Updater.this.onMouseMove(Updater.this.myPainter, event.getX(), event.getY());
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                Updater.this.onMouseClick(Updater.this.myPainter, event.getX(), event.getY());
            }
        };
        this.myPainter = painter;
        this.myScrollBar = bar;
        this.myScrollBar.addMouseListener(this.myMouseAdapter);
        this.myScrollBar.addMouseMotionListener(this.myMouseAdapter);
        this.myQueue = new MergingUpdateQueue("ErrorStripeUpdater", 100, true, (JComponent)this.myScrollBar, (Disposable)this);
        UIUtil.putClientProperty((JComponent)this.myScrollBar, (Key)JBScrollBar.TRACK, (Object)new RegionPainter<Object>(){

            public void paint(Graphics2D g, int x, int y, int width, int height, Object object) {
                DaemonCodeAnalyzerSettings settings = DaemonCodeAnalyzerSettings.getInstance();
                Updater.this.myPainter.setMinimalThickness(settings == null ? 2 : Math.min(settings.ERROR_STRIPE_MARK_MIN_HEIGHT, JBUI.scale((int)4)));
                Updater.this.myPainter.setErrorStripeGap(Registry.intValue((String)"error.stripe.gap", (int)0));
                if (Updater.this.myPainter instanceof ExtraErrorStripePainter) {
                    ExtraErrorStripePainter extra = (ExtraErrorStripePainter)Updater.this.myPainter;
                    extra.setGroupSwap(!Updater.this.myScrollBar.getComponentOrientation().isLeftToRight());
                }
                Updater.this.myPainter.paint(g, x, y, width, height, object);
            }
        });
    }

    public void dispose() {
        this.myScrollBar.removeMouseListener(this.myMouseAdapter);
        this.myScrollBar.removeMouseMotionListener(this.myMouseAdapter);
        UIUtil.putClientProperty((JComponent)this.myScrollBar, (Key)JBScrollBar.TRACK, null);
    }

    private int findErrorStripeIndex(Painter painter, int x, int y) {
        int index = ((ErrorStripePainter)((Object)painter)).findIndex(x, y);
        if (null != ((ErrorStripePainter)((Object)painter)).getErrorStripe(index)) {
            return index;
        }
        index = ((ErrorStripePainter)((Object)painter)).findIndex(x, y + 1);
        if (null != ((ErrorStripePainter)((Object)painter)).getErrorStripe(index)) {
            return index;
        }
        index = ((ErrorStripePainter)((Object)painter)).findIndex(x, y - 1);
        if (null != ((ErrorStripePainter)((Object)painter)).getErrorStripe(index)) {
            return index;
        }
        index = ((ErrorStripePainter)((Object)painter)).findIndex(x, y + 2);
        if (null != ((ErrorStripePainter)((Object)painter)).getErrorStripe(index)) {
            return index;
        }
        return -1;
    }

    protected void onMouseMove(Painter painter, int x, int y) {
        this.onMouseMove(painter, this.findErrorStripeIndex(painter, x, y));
    }

    protected void onMouseMove(Painter painter, int index) {
        this.myScrollBar.setCursor(index < 0 ? null : Cursor.getPredefinedCursor(12));
    }

    protected void onMouseClick(Painter painter, int x, int y) {
        this.onMouseClick(painter, this.findErrorStripeIndex(painter, x, y));
    }

    protected void onMouseClick(Painter painter, int index) {
        this.onSelect(painter, index);
    }

    protected void onSelect(Painter painter, int index) {
    }

    protected ShortcutSet getNextErrorShortcut() {
        return KeymapUtil.getActiveKeymapShortcuts((String)"GotoNextError");
    }

    public void selectNext(int index) {
        this.onSelect(this.myPainter, this.findNextIndex(index));
    }

    protected ShortcutSet getPreviousErrorShortcut() {
        return KeymapUtil.getActiveKeymapShortcuts((String)"GotoPreviousError");
    }

    public void selectPrevious(int index) {
        this.onSelect(this.myPainter, this.findPreviousIndex(index));
    }

    protected abstract void update(Painter var1);

    protected void update(Painter painter, int index, Object object) {
        ((ErrorStripePainter)((Object)painter)).setErrorStripe(index, this.getErrorStripe(object));
    }

    protected ErrorStripe getErrorStripe(Object object) {
        return object instanceof ErrorStripe ? (ErrorStripe)object : null;
    }

    public final void update() {
        this.myQueue.cancelAllUpdates();
        this.myQueue.queue(new Update("update"){

            public void run() {
                Updater.this.update(Updater.this.myPainter);
                if (Updater.this.myPainter.isModified()) {
                    Updater.this.myScrollBar.invalidate();
                    Updater.this.myScrollBar.repaint();
                }
            }
        });
    }

    public int findNextIndex(int current) {
        int count = ((ErrorStripePainter)((Object)this.myPainter)).getErrorStripeCount();
        int foundIndex = -1;
        int foundLayer = 0;
        if (0 <= current && current < count) {
            int layer;
            int index;
            for (index = ++current; index < count; ++index) {
                layer = this.getLayer(index);
                if (layer <= foundLayer) continue;
                foundIndex = index;
                foundLayer = layer;
            }
            for (index = 0; index < current; ++index) {
                layer = this.getLayer(index);
                if (layer <= foundLayer) continue;
                foundIndex = index;
                foundLayer = layer;
            }
        } else {
            for (int index = 0; index < count; ++index) {
                int layer = this.getLayer(index);
                if (layer <= foundLayer) continue;
                foundIndex = index;
                foundLayer = layer;
            }
        }
        return foundIndex;
    }

    public int findPreviousIndex(int current) {
        int count = ((ErrorStripePainter)((Object)this.myPainter)).getErrorStripeCount();
        int foundIndex = -1;
        int foundLayer = 0;
        if (0 <= current && current < count) {
            int layer;
            int index;
            --current;
            for (index = count - 1; index >= 0; ++index) {
                layer = this.getLayer(index);
                if (layer <= foundLayer) continue;
                foundIndex = index;
                foundLayer = layer;
            }
            for (index = current - 1; index >= 0; ++index) {
                layer = this.getLayer(index);
                if (layer <= foundLayer) continue;
                foundIndex = index;
                foundLayer = layer;
            }
        } else {
            for (int index = count - 1; index >= 0; --index) {
                int layer = this.getLayer(index);
                if (layer <= foundLayer) continue;
                foundIndex = index;
                foundLayer = layer;
            }
        }
        return foundIndex;
    }

    private int getLayer(int index) {
        ErrorStripe stripe = ((ErrorStripePainter)((Object)this.myPainter)).getErrorStripe(index);
        return stripe == null ? -1 : stripe.getLayer();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "painter", "com/intellij/ui/stripe/Updater", "<init>"));
    }
}

