/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.NullableFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.elements.GraphElement;
import com.intellij.vcs.log.graph.api.elements.GraphNode;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.AbstractPrintElementGenerator;
import com.intellij.vcs.log.graph.impl.print.EdgesInRowGenerator;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.NormalEdge;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrintElementGeneratorImpl
extends AbstractPrintElementGenerator {
    @NotNull
    private static final Logger LOG = Logger.getInstance(PrintElementGeneratorImpl.class);
    public static final int LONG_EDGE_SIZE = 30;
    private static final int LONG_EDGE_PART_SIZE = 1;
    private static final int VERY_LONG_EDGE_SIZE = 1000;
    private static final int VERY_LONG_EDGE_PART_SIZE = 250;
    private static final int CACHE_SIZE = 100;
    private static final boolean SHOW_ARROW_WHEN_SHOW_LONG_EDGES = true;
    private static final int SAMPLE_SIZE = 20000;
    private static final double K = 0.1;
    @NotNull
    private final SLRUMap<Integer, List<GraphElement>> myCache;
    @NotNull
    private final EdgesInRowGenerator myEdgesInRowGenerator;
    @NotNull
    private final Comparator<GraphElement> myGraphElementComparator;
    private final int myLongEdgeSize;
    private final int myVisiblePartSize;
    private final int myEdgeWithArrowSize;
    private int myRecommendedWidth;

    public PrintElementGeneratorImpl(@NotNull LinearGraph graph, @NotNull PrintElementManager printElementManager, boolean showLongEdges) {
        if (graph == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(0);
        }
        if (printElementManager == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(1);
        }
        super(graph, printElementManager);
        this.myCache = new SLRUMap(100, 200);
        this.myRecommendedWidth = 0;
        this.myEdgesInRowGenerator = new EdgesInRowGenerator(graph);
        this.myGraphElementComparator = printElementManager.getGraphElementComparator();
        if (showLongEdges) {
            this.myLongEdgeSize = 1000;
            this.myVisiblePartSize = 250;
            this.myEdgeWithArrowSize = 30;
        } else {
            this.myLongEdgeSize = 30;
            this.myVisiblePartSize = 1;
            this.myEdgeWithArrowSize = Integer.MAX_VALUE;
        }
    }

    public PrintElementGeneratorImpl(@NotNull LinearGraph graph, @NotNull PrintElementManager printElementManager, int longEdgeSize, int visiblePartSize, int edgeWithArrowSize) {
        if (graph == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(2);
        }
        if (printElementManager == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(3);
        }
        super(graph, printElementManager);
        this.myCache = new SLRUMap(100, 200);
        this.myRecommendedWidth = 0;
        this.myEdgesInRowGenerator = new EdgesInRowGenerator(graph);
        this.myGraphElementComparator = printElementManager.getGraphElementComparator();
        this.myLongEdgeSize = longEdgeSize;
        this.myVisiblePartSize = visiblePartSize;
        this.myEdgeWithArrowSize = edgeWithArrowSize;
    }

    public int getRecommendedWidth() {
        if (this.myRecommendedWidth <= 0) {
            int n = Math.min(20000, this.myLinearGraph.nodesCount());
            double sum = 0.0;
            double sumSquares = 0.0;
            int edgesCount = 0;
            HashSet currentNormalEdges = ContainerUtil.newHashSet();
            for (int i = 0; i < n; ++i) {
                List<GraphEdge> adjacentEdges = this.myLinearGraph.getAdjacentEdges(i, EdgeFilter.ALL);
                int upArrows = 0;
                int downArrows = 0;
                for (GraphEdge graphEdge : adjacentEdges) {
                    NormalEdge normalEdge = LinearGraphUtils.asNormalEdge(graphEdge);
                    if (normalEdge != null) {
                        if (LinearGraphUtils.isEdgeUp(graphEdge, i)) {
                            currentNormalEdges.remove(normalEdge);
                            continue;
                        }
                        currentNormalEdges.add(normalEdge);
                        continue;
                    }
                    if (graphEdge.getType() == GraphEdgeType.DOTTED_ARROW_UP) {
                        ++upArrows;
                        continue;
                    }
                    ++downArrows;
                }
                int newEdgesCount = 0;
                for (NormalEdge e3 : currentNormalEdges) {
                    if (this.isEdgeVisibleInRow(e3, i)) {
                        ++newEdgesCount;
                        continue;
                    }
                    AbstractPrintElementGenerator.RowElementType arrow = this.getArrowType(e3, i);
                    if (arrow == AbstractPrintElementGenerator.RowElementType.DOWN_ARROW) {
                        ++downArrows;
                        continue;
                    }
                    if (arrow != AbstractPrintElementGenerator.RowElementType.UP_ARROW) continue;
                    ++upArrows;
                }
                int n2 = Math.max(edgesCount + upArrows, newEdgesCount + downArrows);
                double weight = 2.0 / ((double)n * 1.1) * (1.0 + -0.9 * (double)i / (double)(n - 1));
                sum += (double)n2 * weight;
                sumSquares += (double)(n2 * n2) * weight;
                edgesCount = newEdgesCount;
            }
            double average = sum;
            double deviation = Math.sqrt(sumSquares - average * average);
            this.myRecommendedWidth = (int)Math.round(average + deviation);
        }
        return this.myRecommendedWidth;
    }

    @NotNull
    protected List<AbstractPrintElementGenerator.ShortEdge> getDownShortEdges(int rowIndex) {
        NullableFunction<GraphEdge, Integer> endPosition = this.createEndPositionFunction(rowIndex);
        ArrayList<AbstractPrintElementGenerator.ShortEdge> result2 = new ArrayList<AbstractPrintElementGenerator.ShortEdge>();
        List<GraphElement> visibleElements = this.getSortedVisibleElementsInRow(rowIndex);
        for (int startPosition = 0; startPosition < visibleElements.size(); ++startPosition) {
            GraphEdge edge;
            Integer endPos;
            GraphElement element = visibleElements.get(startPosition);
            if (element instanceof GraphNode) {
                int nodeIndex = ((GraphNode)element).getNodeIndex();
                for (GraphEdge edge2 : this.myLinearGraph.getAdjacentEdges(nodeIndex, EdgeFilter.ALL)) {
                    Integer endPos2;
                    if (!LinearGraphUtils.isEdgeDown(edge2, nodeIndex) || (endPos2 = (Integer)endPosition.fun((Object)edge2)) == null) continue;
                    result2.add(new AbstractPrintElementGenerator.ShortEdge(edge2, startPosition, endPos2));
                }
            }
            if (!(element instanceof GraphEdge) || (endPos = (Integer)endPosition.fun((Object)(edge = (GraphEdge)element))) == null) continue;
            result2.add(new AbstractPrintElementGenerator.ShortEdge(edge, startPosition, endPos));
        }
        ArrayList<AbstractPrintElementGenerator.ShortEdge> arrayList = result2;
        if (arrayList == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private NullableFunction<GraphEdge, Integer> createEndPositionFunction(int visibleRowIndex) {
        List<GraphElement> visibleElementsInNextRow = this.getSortedVisibleElementsInRow(visibleRowIndex + 1);
        HashMap<GraphElement, Integer> toPosition = new HashMap<GraphElement, Integer>();
        for (int position = 0; position < visibleElementsInNextRow.size(); ++position) {
            toPosition.put(visibleElementsInNextRow.get(position), position);
        }
        NullableFunction nullableFunction = edge -> {
            Integer downNodeIndex;
            Integer position = (Integer)toPosition.get(edge);
            if (position == null && (downNodeIndex = edge.getDownNodeIndex()) != null) {
                position = (Integer)toPosition.get(this.myLinearGraph.getGraphNode(downNodeIndex));
            }
            return position;
        };
        if (nullableFunction == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(5);
        }
        return nullableFunction;
    }

    @NotNull
    protected List<AbstractPrintElementGenerator.SimpleRowElement> getSimpleRowElements(int visibleRowIndex) {
        SmartList result2 = new SmartList();
        List<GraphElement> sortedVisibleElementsInRow = this.getSortedVisibleElementsInRow(visibleRowIndex);
        for (int position = 0; position < sortedVisibleElementsInRow.size(); ++position) {
            GraphEdge edge;
            AbstractPrintElementGenerator.RowElementType arrowType;
            GraphElement element = sortedVisibleElementsInRow.get(position);
            if (element instanceof GraphNode) {
                result2.add(new AbstractPrintElementGenerator.SimpleRowElement(element, AbstractPrintElementGenerator.RowElementType.NODE, position));
            }
            if (!(element instanceof GraphEdge) || (arrowType = this.getArrowType(edge = (GraphEdge)element, visibleRowIndex)) == null) continue;
            result2.add(new AbstractPrintElementGenerator.SimpleRowElement(edge, arrowType, position));
        }
        SmartList smartList = result2;
        if (smartList == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @Nullable
    private AbstractPrintElementGenerator.RowElementType getArrowType(@NotNull GraphEdge edge, int rowIndex) {
        NormalEdge normalEdge;
        if (edge == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(7);
        }
        if ((normalEdge = LinearGraphUtils.asNormalEdge(edge)) != null) {
            return this.getArrowType(normalEdge, rowIndex);
        }
        switch (edge.getType()) {
            case DOTTED_ARROW_DOWN: 
            case NOT_LOAD_COMMIT: {
                if (!LinearGraphUtils.intEqual(edge.getUpNodeIndex(), rowIndex - 1)) break;
                return AbstractPrintElementGenerator.RowElementType.DOWN_ARROW;
            }
            case DOTTED_ARROW_UP: {
                if (!LinearGraphUtils.intEqual(edge.getDownNodeIndex(), rowIndex + 1)) break;
                return AbstractPrintElementGenerator.RowElementType.UP_ARROW;
            }
            default: {
                LOG.error("Unknown special edge type " + (Object)((Object)edge.getType()) + " at row " + rowIndex);
            }
        }
        return null;
    }

    @Nullable
    private AbstractPrintElementGenerator.RowElementType getArrowType(@NotNull NormalEdge normalEdge, int rowIndex) {
        if (normalEdge == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(8);
        }
        int edgeSize = normalEdge.down - normalEdge.up;
        int upOffset = rowIndex - normalEdge.up;
        int downOffset = normalEdge.down - rowIndex;
        if (edgeSize >= this.myLongEdgeSize) {
            if (upOffset == this.myVisiblePartSize) {
                LOG.assertTrue(downOffset != this.myVisiblePartSize, (Object)("Both up and down arrow at row " + rowIndex));
                return AbstractPrintElementGenerator.RowElementType.DOWN_ARROW;
            }
            if (downOffset == this.myVisiblePartSize) {
                return AbstractPrintElementGenerator.RowElementType.UP_ARROW;
            }
        }
        if (edgeSize >= this.myEdgeWithArrowSize) {
            if (upOffset == 1) {
                LOG.assertTrue(downOffset != 1, (Object)("Both up and down arrow at row " + rowIndex));
                return AbstractPrintElementGenerator.RowElementType.DOWN_ARROW;
            }
            if (downOffset == 1) {
                return AbstractPrintElementGenerator.RowElementType.UP_ARROW;
            }
        }
        return null;
    }

    private boolean isEdgeVisibleInRow(@NotNull GraphEdge edge, int visibleRowIndex) {
        NormalEdge normalEdge;
        if (edge == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(9);
        }
        if ((normalEdge = LinearGraphUtils.asNormalEdge(edge)) == null) {
            return false;
        }
        return this.isEdgeVisibleInRow(normalEdge, visibleRowIndex);
    }

    private boolean isEdgeVisibleInRow(@NotNull NormalEdge normalEdge, int visibleRowIndex) {
        if (normalEdge == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(10);
        }
        return normalEdge.down - normalEdge.up < this.myLongEdgeSize || PrintElementGeneratorImpl.getAttachmentDistance(normalEdge, visibleRowIndex) <= this.myVisiblePartSize;
    }

    private void addSpecialEdges(@NotNull List<GraphElement> result2, int rowIndex) {
        if (result2 == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(11);
        }
        if (rowIndex > 0) {
            for (GraphEdge edge : this.myLinearGraph.getAdjacentEdges(rowIndex - 1, EdgeFilter.SPECIAL)) {
                assert (!edge.getType().isNormalEdge());
                if (!LinearGraphUtils.isEdgeDown(edge, rowIndex - 1)) continue;
                result2.add(edge);
            }
        }
        if (rowIndex < this.myLinearGraph.nodesCount() - 1) {
            for (GraphEdge edge : this.myLinearGraph.getAdjacentEdges(rowIndex + 1, EdgeFilter.SPECIAL)) {
                assert (!edge.getType().isNormalEdge());
                if (!LinearGraphUtils.isEdgeUp(edge, rowIndex + 1)) continue;
                result2.add(edge);
            }
        }
    }

    @NotNull
    private List<GraphElement> getSortedVisibleElementsInRow(int rowIndex) {
        List graphElements = (List)this.myCache.get((Object)rowIndex);
        if (graphElements != null) {
            List list2 = graphElements;
            if (list2 == null) {
                PrintElementGeneratorImpl.$$$reportNull$$$0(12);
            }
            return list2;
        }
        ArrayList<GraphElement> result2 = new ArrayList<GraphElement>();
        result2.add(this.myLinearGraph.getGraphNode(rowIndex));
        for (GraphEdge edge : this.myEdgesInRowGenerator.getEdgesInRow(rowIndex)) {
            if (!this.isEdgeVisibleInRow(edge, rowIndex)) continue;
            result2.add(edge);
        }
        this.addSpecialEdges(result2, rowIndex);
        Collections.sort(result2, this.myGraphElementComparator);
        this.myCache.put((Object)rowIndex, result2);
        ArrayList<GraphElement> arrayList = result2;
        if (arrayList == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    private static int getAttachmentDistance(@NotNull NormalEdge e1, int rowIndex) {
        if (e1 == null) {
            PrintElementGeneratorImpl.$$$reportNull$$$0(14);
        }
        return Math.min(rowIndex - e1.up, e1.down - rowIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printElementManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalEdge";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e1";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/impl/print/PrintElementGeneratorImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownShortEdges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEndPositionFunction";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleRowElements";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedVisibleElementsInRow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getArrowType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEdgeVisibleInRow";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addSpecialEdges";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAttachmentDistance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

