/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.util.regex.Pattern;

public class PyMethodNameTypedHandler
extends TypedHandlerDelegate {
    private static final Pattern DEF_THEN_IDENTIFIER = Pattern.compile(".*\\bdef\\s+\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");

    public TypedHandlerDelegate.Result beforeCharTyped(char character, Project project, Editor editor, PsiFile file2, FileType fileType) {
        if (DumbService.isDumb((Project)project) || !(fileType instanceof PythonFileType)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (character == '(') {
            PyFunction func;
            PyUtil.MethodFlags flags;
            PsiElement maybeFunc;
            ASTNode defNode;
            PsiElement maybeDef;
            if (!PyCodeInsightSettings.getInstance().INSERT_SELF_FOR_METHODS) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            Document document = editor.getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            int offset = editor.getCaretModel().getOffset();
            int lineNumber = document.getLineNumber(offset);
            String linePrefix = document.getText(TextRange.create((int)document.getLineStartOffset(lineNumber), (int)offset));
            if (!DEF_THEN_IDENTIFIER.matcher(linePrefix).matches()) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            documentManager.commitDocument(document);
            PsiElement token = file2.findElementAt(offset - 1);
            if (token == null) {
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            ASTNode tokenNode = token.getNode();
            if (tokenNode != null && tokenNode.getElementType() == PyTokenTypes.IDENTIFIER && (maybeDef = PyPsiUtils.getPrevNonCommentSibling(token.getPrevSibling(), false)) != null && (defNode = maybeDef.getNode()) != null && defNode.getElementType() == PyTokenTypes.DEF_KEYWORD && (maybeFunc = token.getParent()) instanceof PyFunction && (flags = PyUtil.MethodFlags.of(func = (PyFunction)maybeFunc)) != null) {
                String paramName = flags.isClassMethod() || flags.isMetaclassMethod() ? "cls" : "self";
                boolean isNew = "__new__".equals(func.getName());
                if (flags.isMetaclassMethod() && isNew) {
                    paramName = "typ";
                } else if (flags.isClassMethod() || isNew) {
                    paramName = "cls";
                } else if (flags.isStaticMethod()) {
                    paramName = "";
                }
                CodeStyleSettings settingsManager = CodeStyleSettingsManager.getSettings((Project)project);
                CommonCodeStyleSettings settings = settingsManager.getCommonSettings((Language)PythonLanguage.getInstance());
                StringBuilder textToType = new StringBuilder();
                textToType.append("(");
                if (!paramName.isEmpty()) {
                    if (settings.SPACE_WITHIN_METHOD_PARENTHESES) {
                        textToType.append(" ");
                    }
                    textToType.append(paramName);
                    if (settings.SPACE_WITHIN_METHOD_PARENTHESES) {
                        textToType.append(" ");
                    }
                } else if (settings.SPACE_WITHIN_EMPTY_METHOD_PARENTHESES) {
                    textToType.append(" ");
                }
                textToType.append(")");
                int caretOffset = editor.getCaretModel().getOffset();
                CharSequence chars = editor.getDocument().getCharsSequence();
                if (caretOffset == chars.length() || chars.charAt(caretOffset) != ':') {
                    textToType.append(':');
                }
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)textToType.toString(), (boolean)true, (int)(1 + paramName.length()));
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }
}

