/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.inspections.PyIncorrectDocstringInspection;
import com.jetbrains.python.inspections.PyMissingOrEmptyDocstringInspection;
import com.jetbrains.python.inspections.quickfix.PySuppressInspectionFix;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyInspectionsSuppressor
implements InspectionSuppressor {
    private static final Pattern SUPPRESS_PATTERN = Pattern.compile("\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*");
    private static final String PY_INCORRECT_DOCSTRING_INSPECTION_ID = new PyIncorrectDocstringInspection().getID();
    private static final String PY_MISSING_OR_EMPTY_DOCSTRING_INSPECTION_ID = new PyMissingOrEmptyDocstringInspection().getID();

    @NotNull
    public SuppressQuickFix[] getSuppressActions(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            PyInspectionsSuppressor.$$$reportNull$$$0(0);
        }
        if (PY_INCORRECT_DOCSTRING_INSPECTION_ID.equals(toolId) || PY_MISSING_OR_EMPTY_DOCSTRING_INSPECTION_ID.equals(toolId)) {
            SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new PySuppressInspectionFix(toolId, "Suppress for function", PyFunction.class), new PySuppressInspectionFix(toolId, "Suppress for class", PyClass.class)};
            if (suppressQuickFixArray == null) {
                PyInspectionsSuppressor.$$$reportNull$$$0(1);
            }
            return suppressQuickFixArray;
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new PySuppressInspectionFix(toolId, "Suppress for statement", PyStatement.class){

            @Override
            public PsiElement getContainer(PsiElement context) {
                if (PsiTreeUtil.getParentOfType((PsiElement)context, PyStatementList.class, (boolean)false, (Class[])new Class[]{ScopeOwner.class}) != null || PsiTreeUtil.getParentOfType((PsiElement)context, (Class[])new Class[]{PyFunction.class, PyClass.class}) == null) {
                    return super.getContainer(context);
                }
                return null;
            }
        }, new PySuppressInspectionFix(toolId, "Suppress for function", PyFunction.class), new PySuppressInspectionFix(toolId, "Suppress for class", PyClass.class)};
        if (suppressQuickFixArray == null) {
            PyInspectionsSuppressor.$$$reportNull$$$0(2);
        }
        return suppressQuickFixArray;
    }

    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            PyInspectionsSuppressor.$$$reportNull$$$0(3);
        }
        if (toolId == null) {
            PyInspectionsSuppressor.$$$reportNull$$$0(4);
        }
        return PyInspectionsSuppressor.isSuppressedForParent(element, PyStatement.class, toolId) || PyInspectionsSuppressor.isSuppressedForParent(element, PyFunction.class, toolId) || PyInspectionsSuppressor.isSuppressedForParent(element, PyClass.class, toolId);
    }

    private static boolean isSuppressedForParent(@NotNull PsiElement element, @NotNull Class<? extends PyElement> parentClass, @NotNull String suppressId) {
        PyElement parent;
        if (element == null) {
            PyInspectionsSuppressor.$$$reportNull$$$0(5);
        }
        if (parentClass == null) {
            PyInspectionsSuppressor.$$$reportNull$$$0(6);
        }
        if (suppressId == null) {
            PyInspectionsSuppressor.$$$reportNull$$$0(7);
        }
        if ((parent = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, parentClass, (boolean)false)) == null) {
            return false;
        }
        return PyInspectionsSuppressor.isSuppressedForElement(parent, suppressId);
    }

    private static boolean isSuppressedForElement(@NotNull PyElement stmt, @NotNull String suppressId) {
        PsiElement parent;
        PsiElement prevSibling;
        if (stmt == null) {
            PyInspectionsSuppressor.$$$reportNull$$$0(8);
        }
        if (suppressId == null) {
            PyInspectionsSuppressor.$$$reportNull$$$0(9);
        }
        if ((prevSibling = stmt.getPrevSibling()) == null && (parent = stmt.getParent()) != null) {
            prevSibling = parent.getPrevSibling();
        }
        while (prevSibling instanceof PsiComment || prevSibling instanceof PsiWhiteSpace) {
            if (prevSibling instanceof PsiComment && PyInspectionsSuppressor.isSuppressedInComment(prevSibling.getText().substring(1).trim(), suppressId)) {
                return true;
            }
            prevSibling = prevSibling.getPrevSibling();
        }
        return false;
    }

    private static boolean isSuppressedInComment(@NotNull String commentText, @NotNull String suppressId) {
        Matcher m;
        if (commentText == null) {
            PyInspectionsSuppressor.$$$reportNull$$$0(10);
        }
        if (suppressId == null) {
            PyInspectionsSuppressor.$$$reportNull$$$0(11);
        }
        return (m = SUPPRESS_PATTERN.matcher(commentText)).matches() && SuppressionUtil.isInspectionToolIdMentioned(m.group(1), suppressId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyInspectionsSuppressor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suppressId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyInspectionsSuppressor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedForParent";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedForElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedInComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

