/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ui.ListEditForm;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPlainTextFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibUtil;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.ui.PyChooseRequirementsDialog;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageRequirementsInspection
extends PyInspection {
    public JDOMExternalizableStringList ignoredPackages = new JDOMExternalizableStringList();

    @NotNull
    public String getDisplayName() {
        if ("Package requirements" == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(0);
        }
        return "Package requirements";
    }

    public JComponent createOptionsPanel() {
        ListEditForm form = new ListEditForm("Ignore packages", (List)this.ignoredPackages);
        return form.getContentPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        if (holder == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(1);
        }
        if (session2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(2);
        }
        if (!(holder.getFile() instanceof PyFile) && !(holder.getFile() instanceof PsiPlainTextFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PyPackageRequirementsInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        Visitor visitor2 = new Visitor(holder, session2, (Collection<String>)this.ignoredPackages);
        if (visitor2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(4);
        }
        return visitor2;
    }

    @Nullable
    public static PyPackageRequirementsInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(5);
        }
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance(element.getProject()).getCurrentProfile();
        String toolName = PyPackageRequirementsInspection.class.getSimpleName();
        return (PyPackageRequirementsInspection)inspectionProfile.getUnwrappedTool(toolName, element);
    }

    @Nullable
    private static Set<PyRequirement> getRequirementsInclTransitive(@NotNull Module module2) {
        Sdk sdk;
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(6);
        }
        if ((sdk = PythonSdkType.findPythonSdk(module2)) == null) {
            return null;
        }
        List<PyRequirement> requirements = PyPackageManager.getInstance(sdk).getRequirements(module2);
        if (requirements == null) {
            return null;
        }
        if (requirements.isEmpty()) {
            return Collections.emptySet();
        }
        List<PyPackage> packages = PyPackageManager.getInstance(sdk).getPackages();
        if (packages == null) {
            return null;
        }
        HashSet<PyRequirement> result2 = new HashSet<PyRequirement>(requirements);
        result2.addAll(PyPackageRequirementsInspection.getTransitiveRequirements(packages, requirements, new HashSet<PyPackage>()));
        return result2;
    }

    @NotNull
    private static Set<PyRequirement> getTransitiveRequirements(@NotNull List<PyPackage> packages, @NotNull Collection<PyRequirement> requirements, @NotNull Set<PyPackage> visited) {
        if (packages == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(7);
        }
        if (requirements == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(8);
        }
        if (visited == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(9);
        }
        HashSet<PyRequirement> result2 = new HashSet<PyRequirement>();
        for (PyRequirement req : requirements) {
            PyPackage pkg = req.match(packages);
            if (pkg == null || !visited.add(pkg)) continue;
            result2.addAll(PyPackageRequirementsInspection.getTransitiveRequirements(packages, pkg.getRequirements(), visited));
        }
        HashSet<PyRequirement> hashSet = result2;
        if (hashSet == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(10);
        }
        return hashSet;
    }

    @Nullable
    private static List<PyRequirement> findUnsatisfiedRequirements(@NotNull Module module2, @NotNull Sdk sdk, @NotNull Set<String> ignoredPackages) {
        PyPackageManager manager;
        List<PyRequirement> requirements;
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(11);
        }
        if (sdk == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(12);
        }
        if (ignoredPackages == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(13);
        }
        if ((requirements = (manager = PyPackageManager.getInstance(sdk)).getRequirements(module2)) != null) {
            List<PyPackage> packages = manager.getPackages();
            if (packages == null) {
                return null;
            }
            List<PyPackage> packagesInModule = PyPackageRequirementsInspection.collectPackagesInModule(module2);
            ArrayList<PyRequirement> unsatisfied = new ArrayList<PyRequirement>();
            for (PyRequirement req : requirements) {
                if (ignoredPackages.contains(req.getName()) || req.match(packages) != null || req.match(packagesInModule) != null) continue;
                unsatisfied.add(req);
            }
            return unsatisfied;
        }
        return null;
    }

    @NotNull
    private static List<PyPackage> collectPackagesInModule(@NotNull Module module2) {
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(14);
        }
        String[] metadataExtensions = new String[]{"egg-info", "dist-info"};
        SmartList result2 = new SmartList();
        for (VirtualFile srcRoot : PyUtil.getSourceRoots(module2)) {
            for (VirtualFile metadata : VfsUtil.getChildren((VirtualFile)srcRoot, file2 -> ArrayUtil.contains((String)file2.getExtension(), (String[])metadataExtensions))) {
                String[] nameAndVersionAndRest = metadata.getNameWithoutExtension().split("-", 3);
                if (nameAndVersionAndRest.length < 2) continue;
                result2.add(new PyPackage(nameAndVersionAndRest[0], nameAndVersionAndRest[1], null, Collections.emptyList()));
            }
        }
        SmartList smartList = result2;
        if (smartList == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(15);
        }
        return smartList;
    }

    private static void setRunningPackagingTasks(@NotNull Module module2, boolean value) {
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(16);
        }
        module2.putUserData(PyPackageManager.RUNNING_PACKAGING_TASKS, (Object)value);
    }

    private static boolean isRunningPackagingTasks(@NotNull Module module2) {
        Boolean value;
        if (module2 == null) {
            PyPackageRequirementsInspection.$$$reportNull$$$0(17);
        }
        return (value = (Boolean)module2.getUserData(PyPackageManager.RUNNING_PACKAGING_TASKS)) != null && value != false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirements";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredPackages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransitiveRequirements";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackagesInModule";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRequirementsInclTransitive";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTransitiveRequirements";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findUnsatisfiedRequirements";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collectPackagesInModule";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setRunningPackagingTasks";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isRunningPackagingTasks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddToRequirementsFix
    implements LocalQuickFix {
        @NotNull
        private final Module myModule;
        @NotNull
        private final String myPackageName;
        @NotNull
        private final LanguageLevel myLanguageLevel;

        private AddToRequirementsFix(@NotNull Module module2, @NotNull String packageName, @NotNull LanguageLevel languageLevel) {
            if (module2 == null) {
                AddToRequirementsFix.$$$reportNull$$$0(0);
            }
            if (packageName == null) {
                AddToRequirementsFix.$$$reportNull$$$0(1);
            }
            if (languageLevel == null) {
                AddToRequirementsFix.$$$reportNull$$$0(2);
            }
            this.myModule = module2;
            this.myPackageName = packageName;
            this.myLanguageLevel = languageLevel;
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getFamilyName() {
            String string = String.format("Add requirement '%s' to %s", this.myPackageName, this.calculateTarget());
            if (string == null) {
                AddToRequirementsFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                AddToRequirementsFix.$$$reportNull$$$0(4);
            }
            if (descriptor2 == null) {
                AddToRequirementsFix.$$$reportNull$$$0(5);
            }
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> PyPackageUtil.addRequirementToTxtOrSetupPy(this.myModule, this.myPackageName, this.myLanguageLevel)), this.getName(), null);
        }

        @NotNull
        private String calculateTarget() {
            VirtualFile requirementsTxt = PyPackageUtil.findRequirementsTxt(this.myModule);
            if (requirementsTxt != null) {
                String string = requirementsTxt.getName();
                if (string == null) {
                    AddToRequirementsFix.$$$reportNull$$$0(6);
                }
                return string;
            }
            if (PyPackageUtil.findSetupCall(this.myModule) != null) {
                if ("setup.py" == null) {
                    AddToRequirementsFix.$$$reportNull$$$0(7);
                }
                return "setup.py";
            }
            if ("project requirements" == null) {
                AddToRequirementsFix.$$$reportNull$$$0(8);
            }
            return "project requirements";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "languageLevel";
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$AddToRequirementsFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calculateTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class IgnoreRequirementFix
    implements LocalQuickFix {
        @NotNull
        private final Set<String> myPackageNames;

        public IgnoreRequirementFix(@NotNull Set<String> packageNames) {
            if (packageNames == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(0);
            }
            this.myPackageNames = packageNames;
        }

        @NotNull
        public String getFamilyName() {
            boolean plural = this.myPackageNames.size() > 1;
            String string = String.format("Ignore requirement%s", plural ? "s" : "");
            if (string == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PyPackageRequirementsInspection inspection;
            PsiElement element;
            if (project == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                IgnoreRequirementFix.$$$reportNull$$$0(3);
            }
            if ((element = descriptor2.getPsiElement()) != null && (inspection = PyPackageRequirementsInspection.getInstance(element)) != null) {
                JDOMExternalizableStringList ignoredPackages = inspection.ignoredPackages;
                boolean changed = false;
                for (String name : this.myPackageNames) {
                    if (ignoredPackages.contains((Object)name)) continue;
                    ignoredPackages.add((Object)name);
                    changed = true;
                }
                if (changed) {
                    ProjectInspectionProfileManager.getInstance(project).fireProfileChanged();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageNames";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$IgnoreRequirementFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UIListener
    implements PyPackageManagerUI.Listener {
        private final Module myModule;

        public UIListener(Module module2) {
            this.myModule = module2;
        }

        @Override
        public void started() {
            PyPackageRequirementsInspection.setRunningPackagingTasks(this.myModule, true);
        }

        @Override
        public void finished(List<ExecutionException> exceptions) {
            PyPackageRequirementsInspection.setRunningPackagingTasks(this.myModule, false);
        }
    }

    public static class InstallAndImportQuickFix
    implements LocalQuickFix {
        private final Sdk mySdk;
        private final Module myModule;
        private String myPackageName;
        @Nullable
        private final String myAsName;
        @NotNull
        private final SmartPsiElementPointer<PyElement> myNode;

        public InstallAndImportQuickFix(@NotNull String packageName, @Nullable String asName, @NotNull PyElement node) {
            if (packageName == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(0);
            }
            if (node == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(1);
            }
            this.myPackageName = packageName;
            this.myAsName = asName;
            this.myNode = SmartPointerManager.getInstance((Project)node.getProject()).createSmartPsiElementPointer((PsiElement)node, node.getContainingFile());
            this.myModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)node);
            this.mySdk = PythonSdkType.findPythonSdk(this.myModule);
        }

        @Nls
        @NotNull
        public String getName() {
            String string = PyBundle.message("QFIX.NAME.install.and.import.package", this.myPackageName);
            if (string == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PyBundle.message("QFIX.install.and.import.package", new Object[0]);
            if (string == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            if (project == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor2 == null) {
                InstallAndImportQuickFix.$$$reportNull$$$0(5);
            }
            PyPackageManagerUI ui = new PyPackageManagerUI(project, this.mySdk, new UIListener(this.myModule){

                @Override
                public void finished(List<ExecutionException> exceptions) {
                    super.finished(exceptions);
                    if (exceptions.isEmpty()) {
                        PyElement element = (PyElement)myNode.getElement();
                        if (element == null) {
                            return;
                        }
                        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> AddImportHelper.addImportStatement(element.getContainingFile(), myPackageName, myAsName, AddImportHelper.ImportPriority.THIRD_PARTY, (PsiElement)element)), "Add import", (Object)"Add import");
                    }
                }
            });
            ui.install(Collections.singletonList(new PyRequirement(this.myPackageName)), Collections.emptyList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallAndImportQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$InstallAndImportQuickFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PyInstallRequirementsFix
    implements LocalQuickFix {
        @NotNull
        private String myName;
        @NotNull
        private final Module myModule;
        @NotNull
        private Sdk mySdk;
        @NotNull
        private final List<PyRequirement> myUnsatisfied;

        public PyInstallRequirementsFix(@Nullable String name, @NotNull Module module2, @NotNull Sdk sdk, @NotNull List<PyRequirement> unsatisfied) {
            boolean plural;
            if (module2 == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(0);
            }
            if (sdk == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(1);
            }
            if (unsatisfied == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(2);
            }
            boolean bl = plural = unsatisfied.size() > 1;
            this.myName = name != null ? name : String.format("Install requirement%s", plural ? "s" : "");
            this.myModule = module2;
            this.mySdk = sdk;
            this.myUnsatisfied = unsatisfied;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PyChooseRequirementsDialog dialog2;
            if (project == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(4);
            }
            if (descriptor2 == null) {
                PyInstallRequirementsFix.$$$reportNull$$$0(5);
            }
            boolean installManagement = false;
            PyPackageManager manager = PyPackageManager.getInstance(this.mySdk);
            List<PyPackage> packages = manager.getPackages();
            if (packages == null) {
                return;
            }
            if (!PyPackageUtil.hasManagement(packages)) {
                int result2 = Messages.showYesNoDialog((Project)project, (String)"Python packaging tools are required for installing packages. Do you want to install 'pip' and 'setuptools' for your interpreter?", (String)"Install Python Packaging Tools", (Icon)Messages.getQuestionIcon());
                if (result2 == 0) {
                    installManagement = true;
                } else {
                    return;
                }
            }
            final List<PyRequirement> chosen = this.myUnsatisfied.size() > 1 ? ((dialog2 = new PyChooseRequirementsDialog(project, this.myUnsatisfied)).showAndGet() ? dialog2.getMarkedElements() : Collections.emptyList()) : this.myUnsatisfied;
            if (chosen.isEmpty()) {
                return;
            }
            if (installManagement) {
                PyPackageManagerUI ui = new PyPackageManagerUI(project, this.mySdk, new UIListener(this.myModule){

                    @Override
                    public void finished(List<ExecutionException> exceptions) {
                        super.finished(exceptions);
                        if (exceptions.isEmpty()) {
                            this.installRequirements(project, chosen);
                        }
                    }
                });
                ui.installManagement();
            } else {
                this.installRequirements(project, chosen);
            }
        }

        private void installRequirements(Project project, List<PyRequirement> requirements) {
            PyPackageManagerUI ui = new PyPackageManagerUI(project, this.mySdk, new UIListener(this.myModule));
            ui.install(requirements, Collections.emptyList());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unsatisfied";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$PyInstallRequirementsFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private final Set<String> myIgnoredPackages;

        public Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session2, Collection<String> ignoredPackages) {
            if (session2 == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, session2);
            this.myIgnoredPackages = ImmutableSet.copyOf(ignoredPackages);
        }

        @Override
        public void visitPyFile(PyFile node) {
            this.checkPackagesHaveBeenInstalled((PsiElement)node, ModuleUtilCore.findModuleForPsiElement((PsiElement)node));
        }

        public void visitPlainTextFile(PsiPlainTextFile file2) {
            Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)file2);
            if (module2 != null && file2.getVirtualFile().equals(PyPackageUtil.findRequirementsTxt(module2))) {
                this.checkPackagesHaveBeenInstalled((PsiElement)file2, module2);
            }
        }

        private void checkPackagesHaveBeenInstalled(@NotNull PsiElement file2, @Nullable Module module2) {
            List unsatisfied;
            Sdk sdk;
            if (file2 == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if (module2 != null && !PyPackageRequirementsInspection.isRunningPackagingTasks(module2) && (sdk = PythonSdkType.findPythonSdk(module2)) != null && (unsatisfied = PyPackageRequirementsInspection.findUnsatisfiedRequirements(module2, sdk, this.myIgnoredPackages)) != null && !unsatisfied.isEmpty()) {
                boolean plural = unsatisfied.size() > 1;
                String msg = String.format("Package requirement%s %s %s not satisfied", plural ? "s" : "", PyPackageUtil.requirementsToString(unsatisfied), plural ? "are" : "is");
                HashSet<String> unsatisfiedNames = new HashSet<String>();
                for (PyRequirement req : unsatisfied) {
                    unsatisfiedNames.add(req.getFullName());
                }
                ArrayList<Object> quickFixes = new ArrayList<Object>();
                quickFixes.add(new PyInstallRequirementsFix(null, module2, sdk, unsatisfied));
                quickFixes.add(new IgnoreRequirementFix(unsatisfiedNames));
                this.registerProblem(file2, msg, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, null, quickFixes.toArray(new LocalQuickFix[quickFixes.size()]));
            }
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            PyReferenceExpression expr = node.getImportSource();
            if (expr != null) {
                this.checkPackageNameInRequirements(expr);
            }
        }

        @Override
        public void visitPyImportStatement(PyImportStatement node) {
            for (PyImportElement element : node.getImportElements()) {
                PyReferenceExpression expr = element.getImportReferenceExpression();
                if (expr == null) continue;
                this.checkPackageNameInRequirements(expr);
            }
        }

        private void checkPackageNameInRequirements(@NotNull PyQualifiedExpression importedExpression) {
            block15: {
                VirtualFile virtualFile;
                PsiFile file2;
                PsiElement element;
                PsiReference reference;
                if (importedExpression == null) {
                    Visitor.$$$reportNull$$$0(2);
                }
                for (PyInspectionExtension extension : (PyInspectionExtension[])Extensions.getExtensions(PyInspectionExtension.EP_NAME)) {
                    if (!extension.ignorePackageNameInRequirements(importedExpression)) continue;
                    return;
                }
                PyExpression packageReferenceExpression = PyPsiUtils.getFirstQualifier(importedExpression);
                String packageName = packageReferenceExpression.getName();
                if (packageName == null || this.myIgnoredPackages.contains(packageName)) break block15;
                List possiblePyPIPackageNames = (List)PyPIPackageUtil.PACKAGES_TOPLEVEL.getOrDefault((Object)packageName, Collections.emptyList());
                if (!ApplicationManager.getApplication().isUnitTestMode() && !PyPIPackageUtil.INSTANCE.isInPyPI(packageName)) {
                    if (!ContainerUtil.exists((Iterable)possiblePyPIPackageNames, PyPIPackageUtil.INSTANCE::isInPyPI)) {
                        return;
                    }
                }
                if ("setuptools".equals(packageName)) {
                    return;
                }
                Collection<String> stdlibPackages = PyStdlibUtil.getPackages();
                if (stdlibPackages != null && stdlibPackages.contains(packageName)) {
                    return;
                }
                Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)packageReferenceExpression);
                if (module2 == null) {
                    return;
                }
                Set requirements = PyPackageRequirementsInspection.getRequirementsInclTransitive(module2);
                if (requirements == null) {
                    return;
                }
                for (PyRequirement req : requirements) {
                    String name2;
                    block17: {
                        block16: {
                            name2 = req.getName();
                            if (name2.equalsIgnoreCase(packageName)) break block16;
                            if (!ContainerUtil.exists((Iterable)possiblePyPIPackageNames, name2::equalsIgnoreCase)) break block17;
                        }
                        return;
                    }
                    String nameWhereUnderscoreReplacedWithHyphen = name2.replaceAll("_", "-");
                    if (ContainerUtil.exists((Iterable)possiblePyPIPackageNames, nameWhereUnderscoreReplacedWithHyphen::equalsIgnoreCase)) {
                        return;
                    }
                    String nameWhereHyphenReplacedWithUnderscore = name2.replaceAll("-", "_");
                    if (!nameWhereHyphenReplacedWithUnderscore.equalsIgnoreCase(packageName)) {
                        if (!ContainerUtil.exists((Iterable)possiblePyPIPackageNames, nameWhereHyphenReplacedWithUnderscore::equalsIgnoreCase)) continue;
                    }
                    return;
                }
                if (!ApplicationManager.getApplication().isUnitTestMode() && (reference = packageReferenceExpression.getReference()) != null && (element = reference.resolve()) != null && (file2 = element.getContainingFile()) != null && ModuleUtilCore.moduleContainsFile((Module)module2, (VirtualFile)(virtualFile = file2.getVirtualFile()), (boolean)false)) {
                    return;
                }
                ArrayList<IgnoreRequirementFix> quickFixes = new ArrayList<IgnoreRequirementFix>();
                ((StreamEx)StreamEx.of((Object)packageName).append((Collection)possiblePyPIPackageNames).filter(PyPIPackageUtil.INSTANCE::isInPyPI)).map(name -> {
                    if (importedExpression == null) {
                        Visitor.$$$reportNull$$$0(3);
                    }
                    return new AddToRequirementsFix(module2, (String)name, LanguageLevel.forElement((PsiElement)importedExpression));
                }).forEach(quickFixes::add);
                quickFixes.add(new IgnoreRequirementFix(Collections.singleton(packageName)));
                this.registerProblem((PsiElement)packageReferenceExpression, String.format("Package containing module '%s' is not listed in project requirements", packageName), ProblemHighlightType.WEAK_WARNING, null, quickFixes.toArray(new LocalQuickFix[quickFixes.size()]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedExpression";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyPackageRequirementsInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPackagesHaveBeenInstalled";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkPackageNameInRequirements";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$checkPackageNameInRequirements$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

