/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.types.PyImportedModuleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyImportedModule
extends LightElement
implements PyTypedElement {
    @Nullable
    private final PyImportElement myImportElement;
    @NotNull
    private final PyFile myContainingFile;
    @NotNull
    private final QualifiedName myImportedPrefix;

    public PyImportedModule(@Nullable PyImportElement importElement, @NotNull PyFile containingFile, @NotNull QualifiedName importedPrefix) {
        if (containingFile == null) {
            PyImportedModule.$$$reportNull$$$0(0);
        }
        if (importedPrefix == null) {
            PyImportedModule.$$$reportNull$$$0(1);
        }
        super(containingFile.getManager(), PythonLanguage.getInstance());
        this.myImportElement = importElement;
        this.myContainingFile = containingFile;
        this.myImportedPrefix = importedPrefix;
    }

    @Override
    @NotNull
    public PyFile getContainingFile() {
        PyFile pyFile = this.myContainingFile;
        if (pyFile == null) {
            PyImportedModule.$$$reportNull$$$0(2);
        }
        return pyFile;
    }

    @NotNull
    public QualifiedName getImportedPrefix() {
        QualifiedName qualifiedName = this.myImportedPrefix;
        if (qualifiedName == null) {
            PyImportedModule.$$$reportNull$$$0(3);
        }
        return qualifiedName;
    }

    @Override
    public String getText() {
        return "import " + this.myImportedPrefix;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PyImportedModule.$$$reportNull$$$0(4);
        }
        visitor2.visitElement((PsiElement)this);
    }

    @Override
    public PsiElement copy() {
        return new PyImportedModule(this.myImportElement, this.myContainingFile, this.myImportedPrefix);
    }

    @Override
    public String toString() {
        return "PyImportedModule:" + this.myImportedPrefix;
    }

    @Override
    @NotNull
    public PsiElement getNavigationElement() {
        PsiElement element;
        if (this.myImportElement != null && (element = PyImportedModule.resolve(this.myImportElement, this.myImportedPrefix)) != null) {
            PsiElement psiElement = element;
            if (psiElement == null) {
                PyImportedModule.$$$reportNull$$$0(5);
            }
            return psiElement;
        }
        PsiElement psiElement = super.getNavigationElement();
        if (psiElement == null) {
            PyImportedModule.$$$reportNull$$$0(6);
        }
        return psiElement;
    }

    @Nullable
    public PyImportElement getImportElement() {
        return this.myImportElement;
    }

    @Nullable
    public PsiElement resolve() {
        PsiElement element = this.myImportElement != null ? ResolveImportUtil.resolveImportElement(this.myImportElement, this.myImportedPrefix) : ResolveImportUtil.resolveModuleInRoots(this.myImportedPrefix, (PsiElement)this.myContainingFile);
        if (element instanceof PsiDirectory) {
            return PyUtil.getPackageElement((PsiDirectory)element, (PsiElement)this);
        }
        return element;
    }

    @Override
    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        if (context == null) {
            PyImportedModule.$$$reportNull$$$0(7);
        }
        if (key == null) {
            PyImportedModule.$$$reportNull$$$0(8);
        }
        return new PyImportedModuleType(this);
    }

    @Nullable
    private static PsiElement resolve(PyImportElement importElement, @NotNull QualifiedName prefix) {
        PsiElement resolved;
        PsiElement packageInit;
        if (prefix == null) {
            PyImportedModule.$$$reportNull$$$0(9);
        }
        return (packageInit = PyUtil.turnDirIntoInit(resolved = ResolveImportUtil.resolveImportElement(importElement, prefix))) != null ? packageInit : resolved;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedPrefix";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyImportedModule";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyImportedModule";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportedPrefix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

