/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.index;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.intellij.images.fileTypes.ImageFileTypeManager;
import org.intellij.images.util.ImageInfoReader;
import org.jetbrains.annotations.NotNull;

public class ImageInfoIndex
extends SingleEntryFileBasedIndexExtension<ImageInfo> {
    private static final int ourMaxImageSize;
    public static final ID<Integer, ImageInfo> INDEX_ID;
    private final DataExternalizer<ImageInfo> myValueExternalizer = new DataExternalizer<ImageInfo>(){

        public void save(@NotNull DataOutput out, ImageInfo info) throws IOException {
            if (out == null) {
                1.$$$reportNull$$$0(0);
            }
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.width);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.height);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)info.bpp);
        }

        public ImageInfo read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                1.$$$reportNull$$$0(1);
            }
            return new ImageInfo(DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "in";
                    break;
                }
            }
            objectArray2[1] = "org/intellij/images/index/ImageInfoIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "save";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "read";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private final SingleEntryIndexer<ImageInfo> myDataIndexer = new SingleEntryIndexer<ImageInfo>(false){

        @Override
        protected ImageInfo computeValue(@NotNull FileContent inputData) {
            ImageInfoReader.Info info;
            if (inputData == null) {
                2.$$$reportNull$$$0(0);
            }
            return (info = ImageInfoReader.getInfo(inputData.getContent())) != null ? new ImageInfo(info.width, info.height, info.bpp) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/intellij/images/index/ImageInfoIndex$2", "computeValue"));
        }
    };

    @NotNull
    public ID<Integer, ImageInfo> getName() {
        ID<Integer, ImageInfo> iD = INDEX_ID;
        if (iD == null) {
            ImageInfoIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    @NotNull
    public SingleEntryIndexer<ImageInfo> getIndexer() {
        SingleEntryIndexer<ImageInfo> singleEntryIndexer = this.myDataIndexer;
        if (singleEntryIndexer == null) {
            ImageInfoIndex.$$$reportNull$$$0(1);
        }
        return singleEntryIndexer;
    }

    public static void processValues(VirtualFile virtualFile, FileBasedIndex.ValueProcessor<ImageInfo> processor2, Project project) {
        FileBasedIndex.getInstance().processValues(INDEX_ID, (Object)Math.abs(FileBasedIndex.getFileId((VirtualFile)virtualFile)), virtualFile, processor2, GlobalSearchScope.fileScope((Project)project, (VirtualFile)virtualFile));
    }

    @NotNull
    public DataExternalizer<ImageInfo> getValueExternalizer() {
        DataExternalizer<ImageInfo> dataExternalizer = this.myValueExternalizer;
        if (dataExternalizer == null) {
            ImageInfoIndex.$$$reportNull$$$0(2);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{ImageFileTypeManager.getInstance().getImageFileType()}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                return file2.isInLocalFileSystem() && file2.getLength() / 1024L < (long)ourMaxImageSize;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/images/index/ImageInfoIndex$3", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            ImageInfoIndex.$$$reportNull$$$0(3);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public int getVersion() {
        return 5;
    }

    static {
        int maxImageSize = 200;
        try {
            maxImageSize = Integer.parseInt(System.getProperty("idea.max.image.filesize", Integer.toString(maxImageSize)), 10);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ourMaxImageSize = maxImageSize;
        INDEX_ID = ID.create((String)"ImageFileInfoIndex");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/intellij/images/index/ImageInfoIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static class ImageInfo {
        public int width;
        public int height;
        public int bpp;

        public ImageInfo(int width, int height, int bpp) {
            this.width = width;
            this.height = height;
            this.bpp = bpp;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageInfo imageInfo = (ImageInfo)o;
            if (this.bpp != imageInfo.bpp) {
                return false;
            }
            if (this.height != imageInfo.height) {
                return false;
            }
            return this.width == imageInfo.width;
        }

        public int hashCode() {
            int result2 = this.width;
            result2 = 31 * result2 + this.height;
            result2 = 31 * result2 + this.bpp;
            return result2;
        }
    }
}

