/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnCheck;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnCollate;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDefault;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnForeignKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnNotNull;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnNull;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnUnique;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTypeDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTypeDef;
import org.tmatesoft.sqljet.core.schema.SqlJetTypeAffinity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetColumnDef
implements ISqlJetColumnDef {
    private final String name;
    private final String quotedName;
    private final ISqlJetTypeDef type;
    private final List<ISqlJetColumnConstraint> constraints;
    private int index;

    public SqlJetColumnDef(CommonTree ast) throws SqlJetException {
        this.name = ast.getText();
        this.quotedName = SqlParser.quotedId(ast);
        CommonTree constraintsNode = (CommonTree)ast.getChild(0);
        assert ("constraints".equalsIgnoreCase(constraintsNode.getText()));
        ArrayList<ISqlJetColumnConstraint> constraints = new ArrayList<ISqlJetColumnConstraint>();
        for (int i = 0; i < constraintsNode.getChildCount(); ++i) {
            String constraintName;
            CommonTree constraintRootNode = (CommonTree)constraintsNode.getChild(i);
            assert ("column_constraint".equalsIgnoreCase(constraintRootNode.getText()));
            CommonTree constraintNode = (CommonTree)constraintRootNode.getChild(0);
            String constraintType = constraintNode.getText();
            String string = constraintName = constraintRootNode.getChildCount() > 1 ? constraintRootNode.getChild(1).getText() : null;
            if ("primary".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnPrimaryKey(this, constraintName, constraintNode));
                continue;
            }
            if ("not_null".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnNotNull(this, constraintName, constraintNode));
                continue;
            }
            if ("unique".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnUnique(this, constraintName, constraintNode));
                continue;
            }
            if ("check".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnCheck(this, constraintName, constraintNode));
                continue;
            }
            if ("default".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnDefault(this, constraintName, constraintNode));
                continue;
            }
            if ("collate".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnCollate(this, constraintName, constraintNode));
                continue;
            }
            if ("references".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnForeignKey(constraintName, constraintNode));
                continue;
            }
            if ("is_null".equalsIgnoreCase(constraintType)) {
                constraints.add(new SqlJetColumnNull(this, constraintName, constraintNode));
                continue;
            }
            assert (false);
        }
        this.constraints = Collections.unmodifiableList(constraints);
        if (ast.getChildCount() > 1) {
            CommonTree typeNode = (CommonTree)ast.getChild(1);
            assert ("type".equalsIgnoreCase(typeNode.getText()));
            this.type = new SqlJetTypeDef(typeNode);
        } else {
            this.type = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuotedName() {
        return this.quotedName;
    }

    @Override
    public ISqlJetTypeDef getType() {
        return this.type;
    }

    @Override
    public SqlJetTypeAffinity getTypeAffinity() {
        ISqlJetTypeDef type = this.getType();
        if (type == null) {
            return SqlJetTypeAffinity.decode(null);
        }
        List<String> typeNames = type.getNames();
        if (typeNames.size() == 1) {
            return SqlJetTypeAffinity.decode(typeNames.get(0));
        }
        String types = "";
        for (String typeName : this.getType().getNames()) {
            types = types + typeName + ' ';
        }
        return SqlJetTypeAffinity.decode(types);
    }

    @Override
    public boolean hasExactlyIntegerType() {
        if (this.getTypeAffinity() != SqlJetTypeAffinity.INTEGER) {
            return false;
        }
        ISqlJetTypeDef type = this.getType();
        if (type == null || type.getNames() == null || type.getNames().size() == 0) {
            return false;
        }
        return "INTEGER".equals(type.getNames().get(0).toUpperCase());
    }

    @Override
    public List<ISqlJetColumnConstraint> getConstraints() {
        return this.constraints;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getQuotedName());
        if (this.getType() != null) {
            buffer.append(' ');
            buffer.append(this.getType());
        }
        for (int i = 0; i < this.getConstraints().size(); ++i) {
            buffer.append(' ');
            buffer.append(this.getConstraints().get(i));
        }
        return buffer.toString();
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

