/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.BunchProvider;
import org.jetbrains.idea.svn.history.Fragment;
import org.jetbrains.idea.svn.history.LatestExistentSearcher;
import org.jetbrains.idea.svn.history.Origin;
import org.jetbrains.idea.svn.history.SvnLogLoader;
import org.jetbrains.idea.svn.history.SvnRepositoryLocation;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class LiveProvider
implements BunchProvider {
    private final SvnLogLoader myLoader;
    private final SvnRepositoryLocation myLocation;
    private final SVNURL myRepositoryUrl;
    private boolean myEarliestRevisionWasAccessed;
    private final long myYoungestRevision;
    private final SvnVcs myVcs;

    public LiveProvider(SvnVcs vcs, SvnRepositoryLocation location, long latestRevision, SvnLogLoader loader, SVNURL repositoryUrl) {
        this.myVcs = vcs;
        this.myLoader = loader;
        this.myLocation = location;
        this.myYoungestRevision = latestRevision;
        this.myRepositoryUrl = repositoryUrl;
    }

    @Override
    public long getEarliestRevision() {
        return -1L;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Fragment getEarliestBunchInInterval(long earliestRevision, long oldestRevision, int desirableSize, boolean includeYoungest, boolean includeOldest) throws VcsException {
        return this.getEarliestBunchInIntervalImpl(earliestRevision, oldestRevision, desirableSize, includeYoungest, includeOldest, earliestRevision);
    }

    private Fragment getEarliestBunchInIntervalImpl(long earliestRevision, long oldestRevision, int desirableSize, boolean includeYoungest, boolean includeOldest, long earliestToTake) throws VcsException {
        if (this.myEarliestRevisionWasAccessed || oldestRevision == this.myYoungestRevision && (!includeYoungest || !includeOldest)) {
            return null;
        }
        SVNRevision youngRevision = earliestRevision == -1L ? SVNRevision.HEAD : SVNRevision.create((long)earliestRevision);
        Ref refToList = new Ref();
        Ref exceptionRef = new Ref();
        Runnable loader = () -> {
            try {
                refToList.set(this.myLoader.loadInterval(youngRevision, SVNRevision.create((long)oldestRevision), desirableSize, includeYoungest, includeOldest));
            }
            catch (VcsException e) {
                exceptionRef.set((Object)e);
            }
        };
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || !application.isDispatchThread()) {
            loader.run();
        } else {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                ProgressIndicator ind = ProgressManager.getInstance().getProgressIndicator();
                if (ind != null) {
                    ind.setText(SvnBundle.message("progress.live.provider.loading.revisions.details.text", new Object[0]));
                }
                loader.run();
            }, SvnBundle.message("progress.live.provider.loading.revisions.text", new Object[0]), false, this.myVcs.getProject());
        }
        if (!exceptionRef.isNull()) {
            VcsException e = (VcsException)((Object)exceptionRef.get());
            if (LiveProvider.isElementNotFound(e)) {
                LatestExistentSearcher searcher = new LatestExistentSearcher(oldestRevision, this.myYoungestRevision, oldestRevision != 0L, this.myVcs, this.myLocation.toSvnUrl(), this.myRepositoryUrl);
                long existent = searcher.getLatestExistent();
                if (existent == -1L || existent == earliestRevision) {
                    this.myEarliestRevisionWasAccessed = true;
                    return null;
                }
                return this.getEarliestBunchInIntervalImpl(existent, oldestRevision, includeYoungest ? desirableSize : desirableSize + 1, true, includeOldest, Math.min(existent, earliestRevision));
            }
            throw e;
        }
        List list = (List)refToList.get();
        if (list.isEmpty()) {
            this.myEarliestRevisionWasAccessed = oldestRevision == 0L;
            return null;
        }
        if (earliestToTake > 0L) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CommittedChangeList changeList = (CommittedChangeList)iterator.next();
                if (changeList.getNumber() <= earliestToTake) continue;
                iterator.remove();
            }
        }
        this.myEarliestRevisionWasAccessed = oldestRevision == 0L && list.size() + (!includeOldest ? 1 : 0) + (!includeYoungest ? 1 : 0) < desirableSize;
        return new Fragment(Origin.LIVE, list, true, true, null);
    }

    private static boolean isElementNotFound(@NotNull VcsException e) {
        if (e == null) {
            LiveProvider.$$$reportNull$$$0(0);
        }
        return e instanceof SvnBindException && ((SvnBindException)e).contains(SVNErrorCode.FS_NOT_FOUND);
    }

    public boolean isEarliestRevisionWasAccessed() {
        return this.myEarliestRevisionWasAccessed;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/history/LiveProvider", "isElementNotFound"));
    }
}

