// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Metrics.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_Metrics_h__
#define __Ice_Metrics_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceMX
{

class Metrics;
class MetricsAdmin;
class MetricsAdminPrx;
class ThreadMetrics;
class DispatchMetrics;
class ChildInvocationMetrics;
class CollocatedMetrics;
class RemoteMetrics;
class InvocationMetrics;
class ConnectionMetrics;

}

namespace IceMX
{

using StringIntDict = ::std::map<::std::string, int>;

struct MetricsFailures
{
    ::std::string id;
    ::IceMX::StringIntDict failures;

    std::tuple<const ::std::string&, const ::IceMX::StringIntDict&> ice_tuple() const
    {
        return std::tie(id, failures);
    }
};

using MetricsFailuresSeq = ::std::vector<::IceMX::MetricsFailures>;

using MetricsMap = ::std::vector<::std::shared_ptr<::IceMX::Metrics>>;

using MetricsView = ::std::map<::std::string, ::IceMX::MetricsMap>;

class ICE_CLASS(ICE_API) UnknownMetricsView : public ::Ice::UserExceptionHelper<UnknownMetricsView, ::Ice::UserException>
{
public:

    ICE_MEMBER(ICE_API) virtual ~UnknownMetricsView();

    UnknownMetricsView(const UnknownMetricsView&) = default;

    UnknownMetricsView() = default;

    std::tuple<> ice_tuple() const
    {
        return std::tie();
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

static UnknownMetricsView _iceS_UnknownMetricsView_init;

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace IceMX
{

class ICE_API MetricsAdmin : public virtual ::Ice::Object
{
public:

    using ProxyType = MetricsAdminPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    struct GetMetricsViewNamesResult
    {
        ::Ice::StringSeq returnValue;
        ::Ice::StringSeq disabledViews;
    };

    virtual ::Ice::StringSeq getMetricsViewNames(::Ice::StringSeq&, const ::Ice::Current&) = 0;
    bool _iceD_getMetricsViewNames(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void enableMetricsView(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_enableMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void disableMetricsView(::std::string, const ::Ice::Current&) = 0;
    bool _iceD_disableMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);

    struct GetMetricsViewResult
    {
        ::IceMX::MetricsView returnValue;
        long long int timestamp;
    };

    virtual ::IceMX::MetricsView getMetricsView(::std::string, long long int&, const ::Ice::Current&) = 0;
    bool _iceD_getMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceMX::MetricsFailuresSeq getMapMetricsFailures(::std::string, ::std::string, const ::Ice::Current&) = 0;
    bool _iceD_getMapMetricsFailures(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceMX::MetricsFailures getMetricsFailures(::std::string, ::std::string, ::std::string, const ::Ice::Current&) = 0;
    bool _iceD_getMetricsFailures(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace IceMX
{

class ICE_CLASS(ICE_API) Metrics : public ::Ice::ValueHelper<Metrics, Ice::Value>
{
public:

    ICE_MEMBER(ICE_API) virtual ~Metrics();

    Metrics() = default;

    Metrics(const Metrics&) = default;
    Metrics(Metrics&&) = default;
    Metrics& operator=(const Metrics&) = default;
    Metrics& operator=(Metrics&&) = default;

    Metrics(const ::std::string& iceP_id, long long int iceP_total, int iceP_current, long long int iceP_totalLifetime, int iceP_failures) :
        id(::std::move(iceP_id)),
        total(iceP_total),
        current(iceP_current),
        totalLifetime(iceP_totalLifetime),
        failures(iceP_failures)
    {
    }

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    ::std::string id;
    long long int total = 0LL;
    int current = 0;
    long long int totalLifetime = 0LL;
    int failures = 0;
};

static Metrics _iceS_Metrics_init;

class ICE_CLASS(ICE_API) ThreadMetrics : public ::Ice::ValueHelper<ThreadMetrics, ::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ThreadMetrics();

    ThreadMetrics() = default;

    ThreadMetrics(const ThreadMetrics&) = default;
    ThreadMetrics(ThreadMetrics&&) = default;
    ThreadMetrics& operator=(const ThreadMetrics&) = default;
    ThreadMetrics& operator=(ThreadMetrics&&) = default;

    ThreadMetrics(const ::std::string& iceP_id, long long int iceP_total, int iceP_current, long long int iceP_totalLifetime, int iceP_failures, int iceP_inUseForIO, int iceP_inUseForUser, int iceP_inUseForOther) :
        Ice::ValueHelper<::IceMX::ThreadMetrics, ::IceMX::Metrics>(::std::move(iceP_id), iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        inUseForIO(iceP_inUseForIO),
        inUseForUser(iceP_inUseForUser),
        inUseForOther(iceP_inUseForOther)
    {
    }

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const int&, const int&, const int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, inUseForIO, inUseForUser, inUseForOther);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    int inUseForIO = 0;
    int inUseForUser = 0;
    int inUseForOther = 0;
};

class ICE_CLASS(ICE_API) DispatchMetrics : public ::Ice::ValueHelper<DispatchMetrics, ::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~DispatchMetrics();

    DispatchMetrics() = default;

    DispatchMetrics(const DispatchMetrics&) = default;
    DispatchMetrics(DispatchMetrics&&) = default;
    DispatchMetrics& operator=(const DispatchMetrics&) = default;
    DispatchMetrics& operator=(DispatchMetrics&&) = default;

    DispatchMetrics(const ::std::string& iceP_id, long long int iceP_total, int iceP_current, long long int iceP_totalLifetime, int iceP_failures, int iceP_userException, long long int iceP_size, long long int iceP_replySize) :
        Ice::ValueHelper<::IceMX::DispatchMetrics, ::IceMX::Metrics>(::std::move(iceP_id), iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        userException(iceP_userException),
        size(iceP_size),
        replySize(iceP_replySize)
    {
    }

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const int&, const long long int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, userException, size, replySize);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    int userException = 0;
    long long int size = 0LL;
    long long int replySize = 0LL;
};

class ICE_CLASS(ICE_API) ChildInvocationMetrics : public ::Ice::ValueHelper<ChildInvocationMetrics, ::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ChildInvocationMetrics();

    ChildInvocationMetrics() = default;

    ChildInvocationMetrics(const ChildInvocationMetrics&) = default;
    ChildInvocationMetrics(ChildInvocationMetrics&&) = default;
    ChildInvocationMetrics& operator=(const ChildInvocationMetrics&) = default;
    ChildInvocationMetrics& operator=(ChildInvocationMetrics&&) = default;

    ChildInvocationMetrics(const ::std::string& iceP_id, long long int iceP_total, int iceP_current, long long int iceP_totalLifetime, int iceP_failures, long long int iceP_size, long long int iceP_replySize) :
        Ice::ValueHelper<::IceMX::ChildInvocationMetrics, ::IceMX::Metrics>(::std::move(iceP_id), iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        size(iceP_size),
        replySize(iceP_replySize)
    {
    }

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const long long int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, size, replySize);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    long long int size = 0LL;
    long long int replySize = 0LL;
};

class ICE_CLASS(ICE_API) CollocatedMetrics : public ::Ice::ValueHelper<CollocatedMetrics, ::IceMX::ChildInvocationMetrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~CollocatedMetrics();

    CollocatedMetrics() = default;

    CollocatedMetrics(const CollocatedMetrics&) = default;
    CollocatedMetrics(CollocatedMetrics&&) = default;
    CollocatedMetrics& operator=(const CollocatedMetrics&) = default;
    CollocatedMetrics& operator=(CollocatedMetrics&&) = default;

    CollocatedMetrics(const ::std::string& iceP_id, long long int iceP_total, int iceP_current, long long int iceP_totalLifetime, int iceP_failures, long long int iceP_size, long long int iceP_replySize) :
        Ice::ValueHelper<::IceMX::CollocatedMetrics, ::IceMX::ChildInvocationMetrics>(::std::move(iceP_id), iceP_total, iceP_current, iceP_totalLifetime, iceP_failures, iceP_size, iceP_replySize)
    {
    }

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const long long int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, size, replySize);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

class ICE_CLASS(ICE_API) RemoteMetrics : public ::Ice::ValueHelper<RemoteMetrics, ::IceMX::ChildInvocationMetrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~RemoteMetrics();

    RemoteMetrics() = default;

    RemoteMetrics(const RemoteMetrics&) = default;
    RemoteMetrics(RemoteMetrics&&) = default;
    RemoteMetrics& operator=(const RemoteMetrics&) = default;
    RemoteMetrics& operator=(RemoteMetrics&&) = default;

    RemoteMetrics(const ::std::string& iceP_id, long long int iceP_total, int iceP_current, long long int iceP_totalLifetime, int iceP_failures, long long int iceP_size, long long int iceP_replySize) :
        Ice::ValueHelper<::IceMX::RemoteMetrics, ::IceMX::ChildInvocationMetrics>(::std::move(iceP_id), iceP_total, iceP_current, iceP_totalLifetime, iceP_failures, iceP_size, iceP_replySize)
    {
    }

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const long long int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, size, replySize);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();
};

class ICE_CLASS(ICE_API) InvocationMetrics : public ::Ice::ValueHelper<InvocationMetrics, ::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~InvocationMetrics();

    InvocationMetrics() = default;

    InvocationMetrics(const InvocationMetrics&) = default;
    InvocationMetrics(InvocationMetrics&&) = default;
    InvocationMetrics& operator=(const InvocationMetrics&) = default;
    InvocationMetrics& operator=(InvocationMetrics&&) = default;

    InvocationMetrics(const ::std::string& iceP_id, long long int iceP_total, int iceP_current, long long int iceP_totalLifetime, int iceP_failures, int iceP_retry, int iceP_userException, const ::IceMX::MetricsMap& iceP_remotes, const ::IceMX::MetricsMap& iceP_collocated) :
        Ice::ValueHelper<::IceMX::InvocationMetrics, ::IceMX::Metrics>(::std::move(iceP_id), iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        retry(iceP_retry),
        userException(iceP_userException),
        remotes(::std::move(iceP_remotes)),
        collocated(::std::move(iceP_collocated))
    {
    }

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const int&, const int&, const ::IceMX::MetricsMap&, const ::IceMX::MetricsMap&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, retry, userException, remotes, collocated);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    int retry = 0;
    int userException = 0;
    ::IceMX::MetricsMap remotes;
    ::IceMX::MetricsMap collocated;
};

class ICE_CLASS(ICE_API) ConnectionMetrics : public ::Ice::ValueHelper<ConnectionMetrics, ::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICE_API) virtual ~ConnectionMetrics();

    ConnectionMetrics() = default;

    ConnectionMetrics(const ConnectionMetrics&) = default;
    ConnectionMetrics(ConnectionMetrics&&) = default;
    ConnectionMetrics& operator=(const ConnectionMetrics&) = default;
    ConnectionMetrics& operator=(ConnectionMetrics&&) = default;

    ConnectionMetrics(const ::std::string& iceP_id, long long int iceP_total, int iceP_current, long long int iceP_totalLifetime, int iceP_failures, long long int iceP_receivedBytes, long long int iceP_sentBytes) :
        Ice::ValueHelper<::IceMX::ConnectionMetrics, ::IceMX::Metrics>(::std::move(iceP_id), iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        receivedBytes(iceP_receivedBytes),
        sentBytes(iceP_sentBytes)
    {
    }

    std::tuple<const ::std::string&, const long long int&, const int&, const long long int&, const int&, const long long int&, const long long int&> ice_tuple() const
    {
        return std::tie(id, total, current, totalLifetime, failures, receivedBytes, sentBytes);
    }

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

    long long int receivedBytes = 0LL;
    long long int sentBytes = 0LL;
};

}

namespace IceMX
{

class ICE_CLASS(ICE_API) MetricsAdminPrx : public virtual ::Ice::Proxy<MetricsAdminPrx, ::Ice::ObjectPrx>
{
public:

    ::Ice::StringSeq getMetricsViewNames(::Ice::StringSeq& iceP_disabledViews, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto result = _makePromiseOutgoing<::IceMX::MetricsAdmin::GetMetricsViewNamesResult>(true, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsViewNames, context).get();
        iceP_disabledViews = ::std::move(result.disabledViews);
        return ::std::move(result.returnValue);
    }

    template<template<typename> class P = ::std::promise>
    auto getMetricsViewNamesAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceMX::MetricsAdmin::GetMetricsViewNamesResult>>().get_future())
    {
        return _makePromiseOutgoing<::IceMX::MetricsAdmin::GetMetricsViewNamesResult, P>(false, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsViewNames, context);
    }

    ::std::function<void()>
    getMetricsViewNamesAsync(::std::function<void(::Ice::StringSeq, ::Ice::StringSeq)> response,
                             ::std::function<void(::std::exception_ptr)> ex = nullptr,
                             ::std::function<void(bool)> sent = nullptr,
                             const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto responseCb = [response](::IceMX::MetricsAdmin::GetMetricsViewNamesResult&& result)
        {
            response(::std::move(result.returnValue), ::std::move(result.disabledViews));
        };
        return _makeLamdaOutgoing<::IceMX::MetricsAdmin::GetMetricsViewNamesResult>(responseCb, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsViewNames, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_getMetricsViewNames(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceMX::MetricsAdmin::GetMetricsViewNamesResult>>&, const ::Ice::Context&);

    void enableMetricsView(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceMX::MetricsAdminPrx::_iceI_enableMetricsView, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto enableMetricsViewAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceMX::MetricsAdminPrx::_iceI_enableMetricsView, iceP_name, context);
    }

    ::std::function<void()>
    enableMetricsViewAsync(const ::std::string& iceP_name,
                           ::std::function<void()> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_enableMetricsView, iceP_name, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_enableMetricsView(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    void disableMetricsView(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &IceMX::MetricsAdminPrx::_iceI_disableMetricsView, iceP_name, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto disableMetricsViewAsync(const ::std::string& iceP_name, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &IceMX::MetricsAdminPrx::_iceI_disableMetricsView, iceP_name, context);
    }

    ::std::function<void()>
    disableMetricsViewAsync(const ::std::string& iceP_name,
                            ::std::function<void()> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_disableMetricsView, iceP_name, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_disableMetricsView(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::std::string&, const ::Ice::Context&);

    ::IceMX::MetricsView getMetricsView(const ::std::string& iceP_view, long long int& iceP_timestamp, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto result = _makePromiseOutgoing<::IceMX::MetricsAdmin::GetMetricsViewResult>(true, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsView, iceP_view, context).get();
        iceP_timestamp = result.timestamp;
        return ::std::move(result.returnValue);
    }

    template<template<typename> class P = ::std::promise>
    auto getMetricsViewAsync(const ::std::string& iceP_view, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceMX::MetricsAdmin::GetMetricsViewResult>>().get_future())
    {
        return _makePromiseOutgoing<::IceMX::MetricsAdmin::GetMetricsViewResult, P>(false, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsView, iceP_view, context);
    }

    ::std::function<void()>
    getMetricsViewAsync(const ::std::string& iceP_view,
                        ::std::function<void(::IceMX::MetricsView, long long int)> response,
                        ::std::function<void(::std::exception_ptr)> ex = nullptr,
                        ::std::function<void(bool)> sent = nullptr,
                        const ::Ice::Context& context = Ice::noExplicitContext)
    {
        auto responseCb = [response](::IceMX::MetricsAdmin::GetMetricsViewResult&& result)
        {
            response(::std::move(result.returnValue), result.timestamp);
        };
        return _makeLamdaOutgoing<::IceMX::MetricsAdmin::GetMetricsViewResult>(responseCb, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsView, iceP_view, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_getMetricsView(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceMX::MetricsAdmin::GetMetricsViewResult>>&, const ::std::string&, const ::Ice::Context&);

    ::IceMX::MetricsFailuresSeq getMapMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceMX::MetricsFailuresSeq>(true, this, &IceMX::MetricsAdminPrx::_iceI_getMapMetricsFailures, iceP_view, iceP_map, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getMapMetricsFailuresAsync(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceMX::MetricsFailuresSeq>>().get_future())
    {
        return _makePromiseOutgoing<::IceMX::MetricsFailuresSeq, P>(false, this, &IceMX::MetricsAdminPrx::_iceI_getMapMetricsFailures, iceP_view, iceP_map, context);
    }

    ::std::function<void()>
    getMapMetricsFailuresAsync(const ::std::string& iceP_view, const ::std::string& iceP_map,
                               ::std::function<void(::IceMX::MetricsFailuresSeq)> response,
                               ::std::function<void(::std::exception_ptr)> ex = nullptr,
                               ::std::function<void(bool)> sent = nullptr,
                               const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceMX::MetricsFailuresSeq>(response, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_getMapMetricsFailures, iceP_view, iceP_map, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_getMapMetricsFailures(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceMX::MetricsFailuresSeq>>&, const ::std::string&, const ::std::string&, const ::Ice::Context&);

    ::IceMX::MetricsFailures getMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::IceMX::MetricsFailures>(true, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsFailures, iceP_view, iceP_map, iceP_id, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getMetricsFailuresAsync(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::std::string& iceP_id, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::IceMX::MetricsFailures>>().get_future())
    {
        return _makePromiseOutgoing<::IceMX::MetricsFailures, P>(false, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsFailures, iceP_view, iceP_map, iceP_id, context);
    }

    ::std::function<void()>
    getMetricsFailuresAsync(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::std::string& iceP_id,
                            ::std::function<void(::IceMX::MetricsFailures)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::IceMX::MetricsFailures>(response, ex, sent, this, &IceMX::MetricsAdminPrx::_iceI_getMetricsFailures, iceP_view, iceP_map, iceP_id, context);
    }

    ICE_MEMBER(ICE_API) void _iceI_getMetricsFailures(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::IceMX::MetricsFailures>>&, const ::std::string&, const ::std::string&, const ::std::string&, const ::Ice::Context&);

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    MetricsAdminPrx() = default;
    friend ::std::shared_ptr<MetricsAdminPrx> IceInternal::createProxy<MetricsAdminPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

template<typename S>
struct StreamReader<::IceMX::Metrics, S>
{
    static void read(S* istr, ::IceMX::Metrics& v)
    {
        istr->readAll(v.id, v.total, v.current, v.totalLifetime, v.failures);
    }
};

template<>
struct StreamableTraits<::IceMX::MetricsFailures>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::IceMX::MetricsFailures, S>
{
    static void read(S* istr, ::IceMX::MetricsFailures& v)
    {
        istr->readAll(v.id, v.failures);
    }
};

template<typename S>
struct StreamWriter<::IceMX::ThreadMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ThreadMetrics& v)
    {
        ostr->writeAll(v.inUseForIO, v.inUseForUser, v.inUseForOther);
    }
};

template<typename S>
struct StreamReader<::IceMX::ThreadMetrics, S>
{
    static void read(S* istr, ::IceMX::ThreadMetrics& v)
    {
        istr->readAll(v.inUseForIO, v.inUseForUser, v.inUseForOther);
    }
};

template<typename S>
struct StreamWriter<::IceMX::DispatchMetrics, S>
{
    static void write(S* ostr, const ::IceMX::DispatchMetrics& v)
    {
        ostr->writeAll(v.userException, v.size, v.replySize);
    }
};

template<typename S>
struct StreamReader<::IceMX::DispatchMetrics, S>
{
    static void read(S* istr, ::IceMX::DispatchMetrics& v)
    {
        istr->readAll(v.userException, v.size, v.replySize);
    }
};

template<typename S>
struct StreamWriter<::IceMX::ChildInvocationMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ChildInvocationMetrics& v)
    {
        ostr->writeAll(v.size, v.replySize);
    }
};

template<typename S>
struct StreamReader<::IceMX::ChildInvocationMetrics, S>
{
    static void read(S* istr, ::IceMX::ChildInvocationMetrics& v)
    {
        istr->readAll(v.size, v.replySize);
    }
};

template<typename S>
struct StreamWriter<::IceMX::CollocatedMetrics, S>
{
    static void write(S*, const ::IceMX::CollocatedMetrics&)
    {
    }
};

template<typename S>
struct StreamReader<::IceMX::CollocatedMetrics, S>
{
    static void read(S*, ::IceMX::CollocatedMetrics&)
    {
    }
};

template<typename S>
struct StreamWriter<::IceMX::RemoteMetrics, S>
{
    static void write(S*, const ::IceMX::RemoteMetrics&)
    {
    }
};

template<typename S>
struct StreamReader<::IceMX::RemoteMetrics, S>
{
    static void read(S*, ::IceMX::RemoteMetrics&)
    {
    }
};

template<typename S>
struct StreamWriter<::IceMX::InvocationMetrics, S>
{
    static void write(S* ostr, const ::IceMX::InvocationMetrics& v)
    {
        ostr->writeAll(v.retry, v.userException, v.remotes, v.collocated);
    }
};

template<typename S>
struct StreamReader<::IceMX::InvocationMetrics, S>
{
    static void read(S* istr, ::IceMX::InvocationMetrics& v)
    {
        istr->readAll(v.retry, v.userException, v.remotes, v.collocated);
    }
};

template<typename S>
struct StreamWriter<::IceMX::ConnectionMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ConnectionMetrics& v)
    {
        ostr->writeAll(v.receivedBytes, v.sentBytes);
    }
};

template<typename S>
struct StreamReader<::IceMX::ConnectionMetrics, S>
{
    static void read(S* istr, ::IceMX::ConnectionMetrics& v)
    {
        istr->readAll(v.receivedBytes, v.sentBytes);
    }
};

}

namespace IceMX
{

using MetricsPtr = ::std::shared_ptr<Metrics>;

using MetricsAdminPtr = ::std::shared_ptr<MetricsAdmin>;
using MetricsAdminPrxPtr = ::std::shared_ptr<MetricsAdminPrx>;

using ThreadMetricsPtr = ::std::shared_ptr<ThreadMetrics>;

using DispatchMetricsPtr = ::std::shared_ptr<DispatchMetrics>;

using ChildInvocationMetricsPtr = ::std::shared_ptr<ChildInvocationMetrics>;

using CollocatedMetricsPtr = ::std::shared_ptr<CollocatedMetrics>;

using RemoteMetricsPtr = ::std::shared_ptr<RemoteMetrics>;

using InvocationMetricsPtr = ::std::shared_ptr<InvocationMetrics>;

using ConnectionMetricsPtr = ::std::shared_ptr<ConnectionMetrics>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace IceMX
{

class Metrics;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::Metrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::Metrics*);

class MetricsAdmin;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::MetricsAdmin>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::MetricsAdmin*);

class ThreadMetrics;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::ThreadMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::ThreadMetrics*);

class DispatchMetrics;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::DispatchMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::DispatchMetrics*);

class ChildInvocationMetrics;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::ChildInvocationMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::ChildInvocationMetrics*);

class CollocatedMetrics;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::CollocatedMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::CollocatedMetrics*);

class RemoteMetrics;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::RemoteMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::RemoteMetrics*);

class InvocationMetrics;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::InvocationMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::InvocationMetrics*);

class ConnectionMetrics;
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::IceMX::ConnectionMetrics>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::IceMX::ConnectionMetrics*);

}

}

namespace IceMX
{

class Metrics;
ICE_API ::Ice::Object* upCast(::IceMX::Metrics*);
typedef ::IceInternal::Handle< ::IceMX::Metrics> MetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::Metrics> MetricsPrx;
typedef MetricsPrx MetricsPrxPtr;
ICE_API void _icePatchObjectPtr(MetricsPtr&, const ::Ice::ObjectPtr&);

class MetricsAdmin;
ICE_API ::Ice::Object* upCast(::IceMX::MetricsAdmin*);
typedef ::IceInternal::Handle< ::IceMX::MetricsAdmin> MetricsAdminPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::MetricsAdmin> MetricsAdminPrx;
typedef MetricsAdminPrx MetricsAdminPrxPtr;
ICE_API void _icePatchObjectPtr(MetricsAdminPtr&, const ::Ice::ObjectPtr&);

class ThreadMetrics;
ICE_API ::Ice::Object* upCast(::IceMX::ThreadMetrics*);
typedef ::IceInternal::Handle< ::IceMX::ThreadMetrics> ThreadMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::ThreadMetrics> ThreadMetricsPrx;
typedef ThreadMetricsPrx ThreadMetricsPrxPtr;
ICE_API void _icePatchObjectPtr(ThreadMetricsPtr&, const ::Ice::ObjectPtr&);

class DispatchMetrics;
ICE_API ::Ice::Object* upCast(::IceMX::DispatchMetrics*);
typedef ::IceInternal::Handle< ::IceMX::DispatchMetrics> DispatchMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::DispatchMetrics> DispatchMetricsPrx;
typedef DispatchMetricsPrx DispatchMetricsPrxPtr;
ICE_API void _icePatchObjectPtr(DispatchMetricsPtr&, const ::Ice::ObjectPtr&);

class ChildInvocationMetrics;
ICE_API ::Ice::Object* upCast(::IceMX::ChildInvocationMetrics*);
typedef ::IceInternal::Handle< ::IceMX::ChildInvocationMetrics> ChildInvocationMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::ChildInvocationMetrics> ChildInvocationMetricsPrx;
typedef ChildInvocationMetricsPrx ChildInvocationMetricsPrxPtr;
ICE_API void _icePatchObjectPtr(ChildInvocationMetricsPtr&, const ::Ice::ObjectPtr&);

class CollocatedMetrics;
ICE_API ::Ice::Object* upCast(::IceMX::CollocatedMetrics*);
typedef ::IceInternal::Handle< ::IceMX::CollocatedMetrics> CollocatedMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::CollocatedMetrics> CollocatedMetricsPrx;
typedef CollocatedMetricsPrx CollocatedMetricsPrxPtr;
ICE_API void _icePatchObjectPtr(CollocatedMetricsPtr&, const ::Ice::ObjectPtr&);

class RemoteMetrics;
ICE_API ::Ice::Object* upCast(::IceMX::RemoteMetrics*);
typedef ::IceInternal::Handle< ::IceMX::RemoteMetrics> RemoteMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::RemoteMetrics> RemoteMetricsPrx;
typedef RemoteMetricsPrx RemoteMetricsPrxPtr;
ICE_API void _icePatchObjectPtr(RemoteMetricsPtr&, const ::Ice::ObjectPtr&);

class InvocationMetrics;
ICE_API ::Ice::Object* upCast(::IceMX::InvocationMetrics*);
typedef ::IceInternal::Handle< ::IceMX::InvocationMetrics> InvocationMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::InvocationMetrics> InvocationMetricsPrx;
typedef InvocationMetricsPrx InvocationMetricsPrxPtr;
ICE_API void _icePatchObjectPtr(InvocationMetricsPtr&, const ::Ice::ObjectPtr&);

class ConnectionMetrics;
ICE_API ::Ice::Object* upCast(::IceMX::ConnectionMetrics*);
typedef ::IceInternal::Handle< ::IceMX::ConnectionMetrics> ConnectionMetricsPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceMX::ConnectionMetrics> ConnectionMetricsPrx;
typedef ConnectionMetricsPrx ConnectionMetricsPrxPtr;
ICE_API void _icePatchObjectPtr(ConnectionMetricsPtr&, const ::Ice::ObjectPtr&);

}

namespace IceMX
{

typedef ::std::map< ::std::string, ::Ice::Int> StringIntDict;

struct MetricsFailures
{
    ::std::string id;
    ::IceMX::StringIntDict failures;
};

typedef ::std::vector< ::IceMX::MetricsFailures> MetricsFailuresSeq;

typedef ::std::vector< ::IceMX::MetricsPtr> MetricsMap;

typedef ::std::map< ::std::string, ::IceMX::MetricsMap> MetricsView;

class ICE_API UnknownMetricsView : public ::Ice::UserException
{
public:

    UnknownMetricsView() {}
    virtual ~UnknownMetricsView() throw();

    virtual ::std::string ice_id() const;
    virtual UnknownMetricsView* ice_clone() const;
    virtual void ice_throw() const;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);
};

static UnknownMetricsView _iceS_UnknownMetricsView_init;

}

namespace IceMX
{

class Callback_MetricsAdmin_getMetricsViewNames_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_getMetricsViewNames_Base> Callback_MetricsAdmin_getMetricsViewNamesPtr;

class Callback_MetricsAdmin_enableMetricsView_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_enableMetricsView_Base> Callback_MetricsAdmin_enableMetricsViewPtr;

class Callback_MetricsAdmin_disableMetricsView_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_disableMetricsView_Base> Callback_MetricsAdmin_disableMetricsViewPtr;

class Callback_MetricsAdmin_getMetricsView_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_getMetricsView_Base> Callback_MetricsAdmin_getMetricsViewPtr;

class Callback_MetricsAdmin_getMapMetricsFailures_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_getMapMetricsFailures_Base> Callback_MetricsAdmin_getMapMetricsFailuresPtr;

class Callback_MetricsAdmin_getMetricsFailures_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_MetricsAdmin_getMetricsFailures_Base> Callback_MetricsAdmin_getMetricsFailuresPtr;

}

namespace IceProxy
{

namespace IceMX
{

class ICE_CLASS(ICE_API) Metrics : public virtual ::Ice::Proxy<Metrics, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICE_API) MetricsAdmin : public virtual ::Ice::Proxy<MetricsAdmin, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(ICE_API) ::Ice::StringSeq getMetricsViewNames(::Ice::StringSeq& iceP_disabledViews, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getMetricsViewNames(iceP_disabledViews, _iceI_begin_getMetricsViewNames(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getMetricsViewNames(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getMetricsViewNames(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getMetricsViewNames(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsViewNames(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMetricsViewNames(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsViewNames(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMetricsViewNames(const ::IceMX::Callback_MetricsAdmin_getMetricsViewNamesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsViewNames(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMetricsViewNames(const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_getMetricsViewNamesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsViewNames(context, del, cookie);
    }

    ICE_MEMBER(ICE_API) ::Ice::StringSeq end_getMetricsViewNames(::Ice::StringSeq& iceP_disabledViews, const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getMetricsViewNames(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) void enableMetricsView(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_enableMetricsView(_iceI_begin_enableMetricsView(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_enableMetricsView(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_enableMetricsView(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_enableMetricsView(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableMetricsView(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_enableMetricsView(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableMetricsView(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_enableMetricsView(const ::std::string& iceP_name, const ::IceMX::Callback_MetricsAdmin_enableMetricsViewPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableMetricsView(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_enableMetricsView(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_enableMetricsViewPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_enableMetricsView(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) void end_enableMetricsView(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_enableMetricsView(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) void disableMetricsView(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_disableMetricsView(_iceI_begin_disableMetricsView(iceP_name, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_disableMetricsView(const ::std::string& iceP_name, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_disableMetricsView(iceP_name, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_disableMetricsView(const ::std::string& iceP_name, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_disableMetricsView(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_disableMetricsView(const ::std::string& iceP_name, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_disableMetricsView(iceP_name, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_disableMetricsView(const ::std::string& iceP_name, const ::IceMX::Callback_MetricsAdmin_disableMetricsViewPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_disableMetricsView(iceP_name, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_disableMetricsView(const ::std::string& iceP_name, const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_disableMetricsViewPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_disableMetricsView(iceP_name, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) void end_disableMetricsView(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_disableMetricsView(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) ::IceMX::MetricsView getMetricsView(const ::std::string& iceP_view, ::Ice::Long& iceP_timestamp, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getMetricsView(iceP_timestamp, _iceI_begin_getMetricsView(iceP_view, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getMetricsView(const ::std::string& iceP_view, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getMetricsView(iceP_view, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getMetricsView(const ::std::string& iceP_view, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsView(iceP_view, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMetricsView(const ::std::string& iceP_view, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsView(iceP_view, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMetricsView(const ::std::string& iceP_view, const ::IceMX::Callback_MetricsAdmin_getMetricsViewPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsView(iceP_view, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMetricsView(const ::std::string& iceP_view, const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_getMetricsViewPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsView(iceP_view, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) ::IceMX::MetricsView end_getMetricsView(::Ice::Long& iceP_timestamp, const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getMetricsView(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) ::IceMX::MetricsFailuresSeq getMapMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getMapMetricsFailures(_iceI_begin_getMapMetricsFailures(iceP_view, iceP_map, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getMapMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getMapMetricsFailures(iceP_view, iceP_map, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getMapMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMapMetricsFailures(iceP_view, iceP_map, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMapMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMapMetricsFailures(iceP_view, iceP_map, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMapMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::IceMX::Callback_MetricsAdmin_getMapMetricsFailuresPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMapMetricsFailures(iceP_view, iceP_map, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMapMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_getMapMetricsFailuresPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMapMetricsFailures(iceP_view, iceP_map, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) ::IceMX::MetricsFailuresSeq end_getMapMetricsFailures(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getMapMetricsFailures(const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) ::IceMX::MetricsFailures getMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getMetricsFailures(_iceI_begin_getMetricsFailures(iceP_view, iceP_map, iceP_id, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::std::string& iceP_id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getMetricsFailures(iceP_view, iceP_map, iceP_id, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::std::string& iceP_id, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsFailures(iceP_view, iceP_map, iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::std::string& iceP_id, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsFailures(iceP_view, iceP_map, iceP_id, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::std::string& iceP_id, const ::IceMX::Callback_MetricsAdmin_getMetricsFailuresPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsFailures(iceP_view, iceP_map, iceP_id, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getMetricsFailures(const ::std::string& iceP_view, const ::std::string& iceP_map, const ::std::string& iceP_id, const ::Ice::Context& context, const ::IceMX::Callback_MetricsAdmin_getMetricsFailuresPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getMetricsFailures(iceP_view, iceP_map, iceP_id, context, del, cookie);
    }

    ICE_MEMBER(ICE_API) ::IceMX::MetricsFailures end_getMetricsFailures(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getMetricsFailures(const ::std::string&, const ::std::string&, const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICE_API) ThreadMetrics : public virtual ::Ice::Proxy<ThreadMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICE_API) DispatchMetrics : public virtual ::Ice::Proxy<DispatchMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICE_API) ChildInvocationMetrics : public virtual ::Ice::Proxy<ChildInvocationMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICE_API) CollocatedMetrics : public virtual ::Ice::Proxy<CollocatedMetrics, ::IceProxy::IceMX::ChildInvocationMetrics>
{
public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICE_API) RemoteMetrics : public virtual ::Ice::Proxy<RemoteMetrics, ::IceProxy::IceMX::ChildInvocationMetrics>
{
public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICE_API) InvocationMetrics : public virtual ::Ice::Proxy<InvocationMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(ICE_API) ConnectionMetrics : public virtual ::Ice::Proxy<ConnectionMetrics, ::IceProxy::IceMX::Metrics>
{
public:

    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace IceMX
{

class ICE_API Metrics : public virtual ::Ice::Object
{
public:

    typedef MetricsPrx ProxyType;
    typedef MetricsPtr PointerType;

    virtual ~Metrics();

    Metrics() :
        total(ICE_INT64(0)),
        current(0),
        totalLifetime(ICE_INT64(0)),
        failures(0)
    {
    }

    Metrics(const ::std::string& iceP_id, ::Ice::Long iceP_total, ::Ice::Int iceP_current, ::Ice::Long iceP_totalLifetime, ::Ice::Int iceP_failures) :
        id(iceP_id),
        total(iceP_total),
        current(iceP_current),
        totalLifetime(iceP_totalLifetime),
        failures(iceP_failures)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::std::string id;
    ::Ice::Long total;
    ::Ice::Int current;
    ::Ice::Long totalLifetime;
    ::Ice::Int failures;
};
static ::Ice::ValueFactoryPtr _iceS_Metrics_init = ::IceMX::Metrics::ice_factory();

inline bool operator==(const Metrics& lhs, const Metrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Metrics& lhs, const Metrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICE_API MetricsAdmin : public virtual ::Ice::Object
{
public:

    typedef MetricsAdminPrx ProxyType;
    typedef MetricsAdminPtr PointerType;

    virtual ~MetricsAdmin();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::Ice::StringSeq getMetricsViewNames(::Ice::StringSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_getMetricsViewNames(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void enableMetricsView(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_enableMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void disableMetricsView(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_disableMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceMX::MetricsView getMetricsView(const ::std::string&, ::Ice::Long&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_getMetricsView(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceMX::MetricsFailuresSeq getMapMetricsFailures(const ::std::string&, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_getMapMetricsFailures(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::IceMX::MetricsFailures getMetricsFailures(const ::std::string&, const ::std::string&, const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_getMetricsFailures(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const MetricsAdmin& lhs, const MetricsAdmin& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const MetricsAdmin& lhs, const MetricsAdmin& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICE_API ThreadMetrics : public ::IceMX::Metrics
{
public:

    typedef ThreadMetricsPrx ProxyType;
    typedef ThreadMetricsPtr PointerType;

    virtual ~ThreadMetrics();

    ThreadMetrics() :
        inUseForIO(0),
        inUseForUser(0),
        inUseForOther(0)
    {
    }

    ThreadMetrics(const ::std::string& iceP_id, ::Ice::Long iceP_total, ::Ice::Int iceP_current, ::Ice::Long iceP_totalLifetime, ::Ice::Int iceP_failures, ::Ice::Int iceP_inUseForIO, ::Ice::Int iceP_inUseForUser, ::Ice::Int iceP_inUseForOther) :
        ::IceMX::Metrics(iceP_id, iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        inUseForIO(iceP_inUseForIO),
        inUseForUser(iceP_inUseForUser),
        inUseForOther(iceP_inUseForOther)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::Ice::Int inUseForIO;
    ::Ice::Int inUseForUser;
    ::Ice::Int inUseForOther;
};
static ::Ice::ValueFactoryPtr _iceS_ThreadMetrics_init = ::IceMX::ThreadMetrics::ice_factory();

inline bool operator==(const ThreadMetrics& lhs, const ThreadMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ThreadMetrics& lhs, const ThreadMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICE_API DispatchMetrics : public ::IceMX::Metrics
{
public:

    typedef DispatchMetricsPrx ProxyType;
    typedef DispatchMetricsPtr PointerType;

    virtual ~DispatchMetrics();

    DispatchMetrics() :
        userException(0),
        size(ICE_INT64(0)),
        replySize(ICE_INT64(0))
    {
    }

    DispatchMetrics(const ::std::string& iceP_id, ::Ice::Long iceP_total, ::Ice::Int iceP_current, ::Ice::Long iceP_totalLifetime, ::Ice::Int iceP_failures, ::Ice::Int iceP_userException, ::Ice::Long iceP_size, ::Ice::Long iceP_replySize) :
        ::IceMX::Metrics(iceP_id, iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        userException(iceP_userException),
        size(iceP_size),
        replySize(iceP_replySize)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::Ice::Int userException;
    ::Ice::Long size;
    ::Ice::Long replySize;
};
static ::Ice::ValueFactoryPtr _iceS_DispatchMetrics_init = ::IceMX::DispatchMetrics::ice_factory();

inline bool operator==(const DispatchMetrics& lhs, const DispatchMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const DispatchMetrics& lhs, const DispatchMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICE_API ChildInvocationMetrics : public ::IceMX::Metrics
{
public:

    typedef ChildInvocationMetricsPrx ProxyType;
    typedef ChildInvocationMetricsPtr PointerType;

    virtual ~ChildInvocationMetrics();

    ChildInvocationMetrics() :
        size(ICE_INT64(0)),
        replySize(ICE_INT64(0))
    {
    }

    ChildInvocationMetrics(const ::std::string& iceP_id, ::Ice::Long iceP_total, ::Ice::Int iceP_current, ::Ice::Long iceP_totalLifetime, ::Ice::Int iceP_failures, ::Ice::Long iceP_size, ::Ice::Long iceP_replySize) :
        ::IceMX::Metrics(iceP_id, iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        size(iceP_size),
        replySize(iceP_replySize)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::Ice::Long size;
    ::Ice::Long replySize;
};
static ::Ice::ValueFactoryPtr _iceS_ChildInvocationMetrics_init = ::IceMX::ChildInvocationMetrics::ice_factory();

inline bool operator==(const ChildInvocationMetrics& lhs, const ChildInvocationMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ChildInvocationMetrics& lhs, const ChildInvocationMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICE_API CollocatedMetrics : public ::IceMX::ChildInvocationMetrics
{
public:

    typedef CollocatedMetricsPrx ProxyType;
    typedef CollocatedMetricsPtr PointerType;

    virtual ~CollocatedMetrics();

    CollocatedMetrics()
    {
    }

    CollocatedMetrics(const ::std::string& iceP_id, ::Ice::Long iceP_total, ::Ice::Int iceP_current, ::Ice::Long iceP_totalLifetime, ::Ice::Int iceP_failures, ::Ice::Long iceP_size, ::Ice::Long iceP_replySize) :
        ::IceMX::ChildInvocationMetrics(iceP_id, iceP_total, iceP_current, iceP_totalLifetime, iceP_failures, iceP_size, iceP_replySize)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};
static ::Ice::ValueFactoryPtr _iceS_CollocatedMetrics_init = ::IceMX::CollocatedMetrics::ice_factory();

inline bool operator==(const CollocatedMetrics& lhs, const CollocatedMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const CollocatedMetrics& lhs, const CollocatedMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICE_API RemoteMetrics : public ::IceMX::ChildInvocationMetrics
{
public:

    typedef RemoteMetricsPrx ProxyType;
    typedef RemoteMetricsPtr PointerType;

    virtual ~RemoteMetrics();

    RemoteMetrics()
    {
    }

    RemoteMetrics(const ::std::string& iceP_id, ::Ice::Long iceP_total, ::Ice::Int iceP_current, ::Ice::Long iceP_totalLifetime, ::Ice::Int iceP_failures, ::Ice::Long iceP_size, ::Ice::Long iceP_replySize) :
        ::IceMX::ChildInvocationMetrics(iceP_id, iceP_total, iceP_current, iceP_totalLifetime, iceP_failures, iceP_size, iceP_replySize)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};
static ::Ice::ValueFactoryPtr _iceS_RemoteMetrics_init = ::IceMX::RemoteMetrics::ice_factory();

inline bool operator==(const RemoteMetrics& lhs, const RemoteMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const RemoteMetrics& lhs, const RemoteMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICE_API InvocationMetrics : public ::IceMX::Metrics, public ::IceInternal::GCObject
{
public:

    typedef InvocationMetricsPrx ProxyType;
    typedef InvocationMetricsPtr PointerType;

    virtual ~InvocationMetrics();

    InvocationMetrics() :
        retry(0),
        userException(0)
    {
    }

    InvocationMetrics(const ::std::string& iceP_id, ::Ice::Long iceP_total, ::Ice::Int iceP_current, ::Ice::Long iceP_totalLifetime, ::Ice::Int iceP_failures, ::Ice::Int iceP_retry, ::Ice::Int iceP_userException, const ::IceMX::MetricsMap& iceP_remotes, const ::IceMX::MetricsMap& iceP_collocated) :
        ::IceMX::Metrics(iceP_id, iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        retry(iceP_retry),
        userException(iceP_userException),
        remotes(iceP_remotes),
        collocated(iceP_collocated)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();
    virtual void _iceGcVisitMembers(::IceInternal::GCVisitor&);

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::Ice::Int retry;
    ::Ice::Int userException;
    ::IceMX::MetricsMap remotes;
    ::IceMX::MetricsMap collocated;
};
static ::Ice::ValueFactoryPtr _iceS_InvocationMetrics_init = ::IceMX::InvocationMetrics::ice_factory();

inline bool operator==(const InvocationMetrics& lhs, const InvocationMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const InvocationMetrics& lhs, const InvocationMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class ICE_API ConnectionMetrics : public ::IceMX::Metrics
{
public:

    typedef ConnectionMetricsPrx ProxyType;
    typedef ConnectionMetricsPtr PointerType;

    virtual ~ConnectionMetrics();

    ConnectionMetrics() :
        receivedBytes(ICE_INT64(0)),
        sentBytes(ICE_INT64(0))
    {
    }

    ConnectionMetrics(const ::std::string& iceP_id, ::Ice::Long iceP_total, ::Ice::Int iceP_current, ::Ice::Long iceP_totalLifetime, ::Ice::Int iceP_failures, ::Ice::Long iceP_receivedBytes, ::Ice::Long iceP_sentBytes) :
        ::IceMX::Metrics(iceP_id, iceP_total, iceP_current, iceP_totalLifetime, iceP_failures),
        receivedBytes(iceP_receivedBytes),
        sentBytes(iceP_sentBytes)
    {
    }

    virtual ::Ice::ObjectPtr ice_clone() const;

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    static ::Ice::ValueFactoryPtr ice_factory();

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);

public:

    ::Ice::Long receivedBytes;
    ::Ice::Long sentBytes;
};
static ::Ice::ValueFactoryPtr _iceS_ConnectionMetrics_init = ::IceMX::ConnectionMetrics::ice_factory();

inline bool operator==(const ConnectionMetrics& lhs, const ConnectionMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const ConnectionMetrics& lhs, const ConnectionMetrics& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<typename S>
struct StreamWriter< ::IceMX::Metrics, S>
{
    static void write(S* ostr, const ::IceMX::Metrics& v)
    {
        ostr->write(v.id);
        ostr->write(v.total);
        ostr->write(v.current);
        ostr->write(v.totalLifetime);
        ostr->write(v.failures);
    }
};

template<typename S>
struct StreamReader< ::IceMX::Metrics, S>
{
    static void read(S* istr, ::IceMX::Metrics& v)
    {
        istr->read(v.id);
        istr->read(v.total);
        istr->read(v.current);
        istr->read(v.totalLifetime);
        istr->read(v.failures);
    }
};

template<>
struct StreamableTraits< ::IceMX::MetricsFailures>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::IceMX::MetricsFailures, S>
{
    static void write(S* ostr, const ::IceMX::MetricsFailures& v)
    {
        ostr->write(v.id);
        ostr->write(v.failures);
    }
};

template<typename S>
struct StreamReader< ::IceMX::MetricsFailures, S>
{
    static void read(S* istr, ::IceMX::MetricsFailures& v)
    {
        istr->read(v.id);
        istr->read(v.failures);
    }
};

template<>
struct StreamableTraits< ::IceMX::UnknownMetricsView>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::IceMX::ThreadMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ThreadMetrics& v)
    {
        ostr->write(v.inUseForIO);
        ostr->write(v.inUseForUser);
        ostr->write(v.inUseForOther);
    }
};

template<typename S>
struct StreamReader< ::IceMX::ThreadMetrics, S>
{
    static void read(S* istr, ::IceMX::ThreadMetrics& v)
    {
        istr->read(v.inUseForIO);
        istr->read(v.inUseForUser);
        istr->read(v.inUseForOther);
    }
};

template<typename S>
struct StreamWriter< ::IceMX::DispatchMetrics, S>
{
    static void write(S* ostr, const ::IceMX::DispatchMetrics& v)
    {
        ostr->write(v.userException);
        ostr->write(v.size);
        ostr->write(v.replySize);
    }
};

template<typename S>
struct StreamReader< ::IceMX::DispatchMetrics, S>
{
    static void read(S* istr, ::IceMX::DispatchMetrics& v)
    {
        istr->read(v.userException);
        istr->read(v.size);
        istr->read(v.replySize);
    }
};

template<typename S>
struct StreamWriter< ::IceMX::ChildInvocationMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ChildInvocationMetrics& v)
    {
        ostr->write(v.size);
        ostr->write(v.replySize);
    }
};

template<typename S>
struct StreamReader< ::IceMX::ChildInvocationMetrics, S>
{
    static void read(S* istr, ::IceMX::ChildInvocationMetrics& v)
    {
        istr->read(v.size);
        istr->read(v.replySize);
    }
};

template<typename S>
struct StreamWriter< ::IceMX::InvocationMetrics, S>
{
    static void write(S* ostr, const ::IceMX::InvocationMetrics& v)
    {
        ostr->write(v.retry);
        ostr->write(v.userException);
        ostr->write(v.remotes);
        ostr->write(v.collocated);
    }
};

template<typename S>
struct StreamReader< ::IceMX::InvocationMetrics, S>
{
    static void read(S* istr, ::IceMX::InvocationMetrics& v)
    {
        istr->read(v.retry);
        istr->read(v.userException);
        istr->read(v.remotes);
        istr->read(v.collocated);
    }
};

template<typename S>
struct StreamWriter< ::IceMX::ConnectionMetrics, S>
{
    static void write(S* ostr, const ::IceMX::ConnectionMetrics& v)
    {
        ostr->write(v.receivedBytes);
        ostr->write(v.sentBytes);
    }
};

template<typename S>
struct StreamReader< ::IceMX::ConnectionMetrics, S>
{
    static void read(S* istr, ::IceMX::ConnectionMetrics& v)
    {
        istr->read(v.receivedBytes);
        istr->read(v.sentBytes);
    }
};

}

namespace IceMX
{

template<class T>
class CallbackNC_MetricsAdmin_getMetricsViewNames : public Callback_MetricsAdmin_getMetricsViewNames_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const ::Ice::StringSeq&);

    CallbackNC_MetricsAdmin_getMetricsViewNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq iceP_disabledViews;
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getMetricsViewNames(iceP_disabledViews, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_disabledViews);
        }
    }

private:

    Response _response;
};

template<class T> Callback_MetricsAdmin_getMetricsViewNamesPtr
newCallback_MetricsAdmin_getMetricsViewNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsViewNames<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_MetricsAdmin_getMetricsViewNamesPtr
newCallback_MetricsAdmin_getMetricsViewNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsViewNames<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_MetricsAdmin_getMetricsViewNames : public Callback_MetricsAdmin_getMetricsViewNames_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const ::Ice::StringSeq&, const CT&);

    Callback_MetricsAdmin_getMetricsViewNames(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq iceP_disabledViews;
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_getMetricsViewNames(iceP_disabledViews, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_disabledViews, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_MetricsAdmin_getMetricsViewNamesPtr
newCallback_MetricsAdmin_getMetricsViewNames(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsViewNames<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_MetricsAdmin_getMetricsViewNamesPtr
newCallback_MetricsAdmin_getMetricsViewNames(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsViewNames<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_MetricsAdmin_enableMetricsView : public Callback_MetricsAdmin_enableMetricsView_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_MetricsAdmin_enableMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_enableMetricsView(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_enableMetricsView<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_enableMetricsView<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_enableMetricsView<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_enableMetricsView<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_MetricsAdmin_enableMetricsView : public Callback_MetricsAdmin_enableMetricsView_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_MetricsAdmin_enableMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_enableMetricsView(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_enableMetricsView<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_enableMetricsView<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_enableMetricsView<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_MetricsAdmin_enableMetricsViewPtr
newCallback_MetricsAdmin_enableMetricsView(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_enableMetricsView<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_MetricsAdmin_disableMetricsView : public Callback_MetricsAdmin_disableMetricsView_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_MetricsAdmin_disableMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_disableMetricsView(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }

private:

    Response _response;
};

template<class T> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_disableMetricsView<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_disableMetricsView<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_disableMetricsView<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_disableMetricsView<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_MetricsAdmin_disableMetricsView : public Callback_MetricsAdmin_disableMetricsView_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_MetricsAdmin_disableMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_disableMetricsView(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_disableMetricsView<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_disableMetricsView<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_disableMetricsView<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_MetricsAdmin_disableMetricsViewPtr
newCallback_MetricsAdmin_disableMetricsView(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_disableMetricsView<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_MetricsAdmin_getMetricsView : public Callback_MetricsAdmin_getMetricsView_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceMX::MetricsView&, ::Ice::Long);

    CallbackNC_MetricsAdmin_getMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_timestamp;
        ::IceMX::MetricsView ret;
        try
        {
            ret = proxy->end_getMetricsView(iceP_timestamp, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret, iceP_timestamp);
        }
    }

private:

    Response _response;
};

template<class T> Callback_MetricsAdmin_getMetricsViewPtr
newCallback_MetricsAdmin_getMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceMX::MetricsView&, ::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsView<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_MetricsAdmin_getMetricsViewPtr
newCallback_MetricsAdmin_getMetricsView(T* instance, void (T::*cb)(const ::IceMX::MetricsView&, ::Ice::Long), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsView<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_MetricsAdmin_getMetricsView : public Callback_MetricsAdmin_getMetricsView_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceMX::MetricsView&, ::Ice::Long, const CT&);

    Callback_MetricsAdmin_getMetricsView(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::Ice::Long iceP_timestamp;
        ::IceMX::MetricsView ret;
        try
        {
            ret = proxy->end_getMetricsView(iceP_timestamp, result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, iceP_timestamp, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_MetricsAdmin_getMetricsViewPtr
newCallback_MetricsAdmin_getMetricsView(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceMX::MetricsView&, ::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsView<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_MetricsAdmin_getMetricsViewPtr
newCallback_MetricsAdmin_getMetricsView(T* instance, void (T::*cb)(const ::IceMX::MetricsView&, ::Ice::Long, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsView<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_MetricsAdmin_getMapMetricsFailures : public Callback_MetricsAdmin_getMapMetricsFailures_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceMX::MetricsFailuresSeq&);

    CallbackNC_MetricsAdmin_getMapMetricsFailures(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::IceMX::MetricsFailuresSeq ret;
        try
        {
            ret = proxy->end_getMapMetricsFailures(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_MetricsAdmin_getMapMetricsFailuresPtr
newCallback_MetricsAdmin_getMapMetricsFailures(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceMX::MetricsFailuresSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMapMetricsFailures<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_MetricsAdmin_getMapMetricsFailuresPtr
newCallback_MetricsAdmin_getMapMetricsFailures(T* instance, void (T::*cb)(const ::IceMX::MetricsFailuresSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMapMetricsFailures<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_MetricsAdmin_getMapMetricsFailures : public Callback_MetricsAdmin_getMapMetricsFailures_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceMX::MetricsFailuresSeq&, const CT&);

    Callback_MetricsAdmin_getMapMetricsFailures(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::IceMX::MetricsFailuresSeq ret;
        try
        {
            ret = proxy->end_getMapMetricsFailures(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_MetricsAdmin_getMapMetricsFailuresPtr
newCallback_MetricsAdmin_getMapMetricsFailures(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceMX::MetricsFailuresSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMapMetricsFailures<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_MetricsAdmin_getMapMetricsFailuresPtr
newCallback_MetricsAdmin_getMapMetricsFailures(T* instance, void (T::*cb)(const ::IceMX::MetricsFailuresSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMapMetricsFailures<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_MetricsAdmin_getMetricsFailures : public Callback_MetricsAdmin_getMetricsFailures_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::IceMX::MetricsFailures&);

    CallbackNC_MetricsAdmin_getMetricsFailures(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::IceMX::MetricsFailures ret;
        try
        {
            ret = proxy->end_getMetricsFailures(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_MetricsAdmin_getMetricsFailuresPtr
newCallback_MetricsAdmin_getMetricsFailures(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceMX::MetricsFailures&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsFailures<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_MetricsAdmin_getMetricsFailuresPtr
newCallback_MetricsAdmin_getMetricsFailures(T* instance, void (T::*cb)(const ::IceMX::MetricsFailures&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_MetricsAdmin_getMetricsFailures<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_MetricsAdmin_getMetricsFailures : public Callback_MetricsAdmin_getMetricsFailures_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::IceMX::MetricsFailures&, const CT&);

    Callback_MetricsAdmin_getMetricsFailures(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::IceMX::MetricsAdminPrx proxy = ::IceMX::MetricsAdminPrx::uncheckedCast(result->getProxy());
        ::IceMX::MetricsFailures ret;
        try
        {
            ret = proxy->end_getMetricsFailures(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_MetricsAdmin_getMetricsFailuresPtr
newCallback_MetricsAdmin_getMetricsFailures(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::IceMX::MetricsFailures&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsFailures<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_MetricsAdmin_getMetricsFailuresPtr
newCallback_MetricsAdmin_getMetricsFailures(T* instance, void (T::*cb)(const ::IceMX::MetricsFailures&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_MetricsAdmin_getMetricsFailures<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
