/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.Communicator;
import com.zeroc.Ice.Current;
import com.zeroc.Ice.Identity;
import com.zeroc.Ice.InitializationData;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.LogMessage;
import com.zeroc.Ice.LogMessageType;
import com.zeroc.Ice.Logger;
import com.zeroc.Ice.LoggerAdmin;
import com.zeroc.Ice.ObjectNotExistException;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.Properties;
import com.zeroc.Ice.RemoteLoggerAlreadyAttachedException;
import com.zeroc.Ice.RemoteLoggerPrx;
import com.zeroc.Ice.UnknownException;
import com.zeroc.Ice.Util;
import com.zeroc.IceInternal.LoggerAdminLoggerI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

final class LoggerAdminI
implements LoggerAdmin {
    private final List<LogMessage> _queue = new LinkedList<LogMessage>();
    private int _logCount = 0;
    private final int _maxLogCount;
    private int _traceCount = 0;
    private final int _maxTraceCount;
    private final int _traceLevel;
    private int _oldestTrace = -1;
    private int _oldestLog = -1;
    private final Map<Identity, RemoteLoggerData> _remoteLoggerMap = new HashMap<Identity, RemoteLoggerData>();
    private final LoggerAdminLoggerI _logger;
    private Communicator _sendLogCommunicator = null;
    private boolean _destroyed = false;
    private static final String _traceCategory = "Admin.Logger";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachRemoteLogger(RemoteLoggerPrx prx, LogMessageType[] messageTypes, String[] categories, int messageMax, Current current) throws RemoteLoggerAlreadyAttachedException {
        if (prx == null) {
            return;
        }
        RemoteLoggerPrx remoteLogger = RemoteLoggerPrx.uncheckedCast(prx.ice_twoway());
        Filters filters = new Filters(messageTypes, categories);
        LinkedList<Object> initLogMessages = null;
        LoggerAdminI loggerAdminI = this;
        synchronized (loggerAdminI) {
            Identity remoteLoggerId;
            if (this._sendLogCommunicator == null) {
                if (this._destroyed) {
                    throw new ObjectNotExistException();
                }
                this._sendLogCommunicator = LoggerAdminI.createSendLogCommunicator(current.adapter.getCommunicator(), this._logger.getLocalLogger());
            }
            if (this._remoteLoggerMap.containsKey(remoteLoggerId = remoteLogger.ice_getIdentity())) {
                if (this._traceLevel > 0) {
                    this._logger.trace(_traceCategory, "rejecting `" + remoteLogger.toString() + "' with RemoteLoggerAlreadyAttachedException");
                }
                throw new RemoteLoggerAlreadyAttachedException();
            }
            this._remoteLoggerMap.put(remoteLoggerId, new RemoteLoggerData(LoggerAdminI.changeCommunicator(remoteLogger, this._sendLogCommunicator), filters));
            initLogMessages = messageMax != 0 ? new LinkedList<LogMessage>(this._queue) : new LinkedList();
        }
        if (this._traceLevel > 0) {
            this._logger.trace(_traceCategory, "attached `" + remoteLogger.toString() + "'");
        }
        if (!initLogMessages.isEmpty()) {
            LoggerAdminI.filterLogMessages(initLogMessages, filters.messageTypes, filters.traceCategories, messageMax);
        }
        try {
            remoteLogger.initAsync(this._logger.getPrefix(), initLogMessages.toArray(new LogMessage[0])).whenComplete((v, ex) -> {
                if (ex != null) {
                    if (ex instanceof LocalException) {
                        this.deadRemoteLogger(remoteLogger, this._logger, (LocalException)ex, "init");
                    } else {
                        this.deadRemoteLogger(remoteLogger, this._logger, new UnknownException((Throwable)ex), "init");
                    }
                } else if (this._traceLevel > 1) {
                    this._logger.trace(_traceCategory, "init on `" + remoteLogger.toString() + "' completed successfully");
                }
            });
        }
        catch (LocalException ex2) {
            this.deadRemoteLogger(remoteLogger, this._logger, ex2, "init");
            throw ex2;
        }
    }

    @Override
    public boolean detachRemoteLogger(RemoteLoggerPrx remoteLogger, Current current) {
        if (remoteLogger == null) {
            return false;
        }
        boolean found = this.removeRemoteLogger(remoteLogger);
        if (this._traceLevel > 0) {
            if (found) {
                this._logger.trace(_traceCategory, "detached `" + remoteLogger.toString() + "'");
            } else {
                this._logger.trace(_traceCategory, "cannot detach `" + remoteLogger.toString() + "': not found");
            }
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LoggerAdmin.GetLogResult getLog(LogMessageType[] messageTypes, String[] categories, int messageMax, Current current) {
        LoggerAdmin.GetLogResult r = new LoggerAdmin.GetLogResult();
        LinkedList<Object> logMessages = null;
        LoggerAdminI loggerAdminI = this;
        synchronized (loggerAdminI) {
            logMessages = messageMax != 0 ? new LinkedList<LogMessage>(this._queue) : new LinkedList();
        }
        r.prefix = this._logger.getPrefix();
        if (!logMessages.isEmpty()) {
            Filters filters = new Filters(messageTypes, categories);
            LoggerAdminI.filterLogMessages(logMessages, filters.messageTypes, filters.traceCategories, messageMax);
        }
        r.returnValue = logMessages.toArray(new LogMessage[0]);
        return r;
    }

    LoggerAdminI(Properties props, LoggerAdminLoggerI logger) {
        this._maxLogCount = props.getPropertyAsIntWithDefault("Ice.Admin.Logger.KeepLogs", 100);
        this._maxTraceCount = props.getPropertyAsIntWithDefault("Ice.Admin.Logger.KeepTraces", 100);
        this._traceLevel = props.getPropertyAsInt("Ice.Trace.Admin.Logger");
        this._logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        Communicator sendLogCommunicator = null;
        LoggerAdminI loggerAdminI = this;
        synchronized (loggerAdminI) {
            if (!this._destroyed) {
                this._destroyed = true;
                sendLogCommunicator = this._sendLogCommunicator;
                this._sendLogCommunicator = null;
            }
        }
        if (sendLogCommunicator != null) {
            sendLogCommunicator.destroy();
        }
    }

    synchronized List<RemoteLoggerPrx> log(LogMessage logMessage) {
        ArrayList<RemoteLoggerPrx> remoteLoggers = null;
        if (logMessage.type != LogMessageType.TraceMessage && this._maxLogCount > 0 || logMessage.type == LogMessageType.TraceMessage && this._maxTraceCount > 0) {
            int qs;
            this._queue.add(logMessage);
            if (logMessage.type != LogMessageType.TraceMessage) {
                assert (this._maxLogCount > 0);
                if (this._logCount == this._maxLogCount) {
                    assert (this._oldestLog != -1);
                    this._queue.remove(this._oldestLog);
                    qs = this._queue.size();
                    while (this._oldestLog < qs && this._queue.get((int)this._oldestLog).type == LogMessageType.TraceMessage) {
                        ++this._oldestLog;
                    }
                    assert (this._oldestLog < qs);
                } else {
                    assert (this._logCount < this._maxLogCount);
                    ++this._logCount;
                    if (this._oldestLog == -1) {
                        this._oldestLog = this._queue.size() - 1;
                    }
                }
            } else {
                assert (this._maxTraceCount > 0);
                if (this._traceCount == this._maxTraceCount) {
                    assert (this._oldestTrace != -1);
                    this._queue.remove(this._oldestTrace);
                    qs = this._queue.size();
                    while (this._oldestTrace < qs && this._queue.get((int)this._oldestTrace).type != LogMessageType.TraceMessage) {
                        ++this._oldestTrace;
                    }
                    assert (this._oldestTrace < qs);
                } else {
                    assert (this._traceCount < this._maxTraceCount);
                    ++this._traceCount;
                    if (this._oldestTrace == -1) {
                        this._oldestTrace = this._queue.size() - 1;
                    }
                }
            }
            for (RemoteLoggerData p : this._remoteLoggerMap.values()) {
                Filters filters = p.filters;
                if (!filters.messageTypes.isEmpty() && !filters.messageTypes.contains(logMessage.type) || logMessage.type == LogMessageType.TraceMessage && !filters.traceCategories.isEmpty() && !filters.traceCategories.contains(logMessage.traceCategory)) continue;
                if (remoteLoggers == null) {
                    remoteLoggers = new ArrayList<RemoteLoggerPrx>();
                }
                remoteLoggers.add(p.remoteLogger);
            }
        }
        return remoteLoggers;
    }

    void deadRemoteLogger(RemoteLoggerPrx remoteLogger, Logger logger, LocalException ex, String operation) {
        if (this.removeRemoteLogger(remoteLogger) && this._traceLevel > 0) {
            logger.trace(_traceCategory, "detached `" + remoteLogger.toString() + "' because " + operation + " raised:\n" + ex.toString());
        }
    }

    int getTraceLevel() {
        return this._traceLevel;
    }

    private synchronized boolean removeRemoteLogger(RemoteLoggerPrx remoteLogger) {
        return this._remoteLoggerMap.remove(remoteLogger.ice_getIdentity()) != null;
    }

    private static void filterLogMessages(List<LogMessage> logMessages, Set<LogMessageType> messageTypes, Set<String> traceCategories, int messageMax) {
        assert (!logMessages.isEmpty() && messageMax != 0);
        if (!messageTypes.isEmpty() || !traceCategories.isEmpty() || messageMax > 0) {
            int count = 0;
            ListIterator<LogMessage> p = logMessages.listIterator(logMessages.size());
            while (p.hasPrevious()) {
                boolean keepIt = false;
                LogMessage msg = p.previous();
                if ((messageTypes.isEmpty() || messageTypes.contains(msg.type)) && (msg.type != LogMessageType.TraceMessage || traceCategories.isEmpty() || traceCategories.contains(msg.traceCategory))) {
                    keepIt = true;
                }
                if (keepIt) {
                    if (messageMax <= 0 || ++count < messageMax) continue;
                    if (!p.hasPrevious()) break;
                    int removeCount = p.previousIndex() + 1;
                    for (int i = 0; i < removeCount; ++i) {
                        logMessages.remove(0);
                    }
                    break;
                }
                p.remove();
            }
        }
    }

    private static RemoteLoggerPrx changeCommunicator(RemoteLoggerPrx prx, Communicator communicator) {
        if (prx == null) {
            return null;
        }
        ObjectPrx result = communicator.stringToProxy(prx.toString());
        return RemoteLoggerPrx.uncheckedCast(result.ice_invocationTimeout(prx.ice_getInvocationTimeout()));
    }

    private static void copyProperties(String prefix, Properties from, Properties to) {
        for (Map.Entry<String, String> p : from.getPropertiesForPrefix(prefix).entrySet()) {
            to.setProperty(p.getKey(), p.getValue());
        }
    }

    private static Communicator createSendLogCommunicator(Communicator communicator, Logger logger) {
        InitializationData initData = new InitializationData();
        initData.logger = logger;
        initData.properties = Util.createProperties();
        Properties mainProps = communicator.getProperties();
        LoggerAdminI.copyProperties("Ice.Default.Locator", mainProps, initData.properties);
        LoggerAdminI.copyProperties("Ice.Plugin.IceSSL", mainProps, initData.properties);
        LoggerAdminI.copyProperties("IceSSL.", mainProps, initData.properties);
        String[] extraProps = mainProps.getPropertyAsList("Ice.Admin.Logger.Properties");
        if (extraProps.length > 0) {
            for (int i = 0; i < extraProps.length; ++i) {
                String p = extraProps[i];
                if (p.startsWith("--")) continue;
                extraProps[i] = "--" + p;
            }
            initData.properties.parseCommandLineOptions("", extraProps);
        }
        return Util.initialize(initData);
    }

    private static class RemoteLoggerData {
        final RemoteLoggerPrx remoteLogger;
        final Filters filters;

        RemoteLoggerData(RemoteLoggerPrx prx, Filters f) {
            this.remoteLogger = prx;
            this.filters = f;
        }
    }

    private static class Filters {
        final Set<LogMessageType> messageTypes;
        final Set<String> traceCategories;

        Filters(LogMessageType[] m, String[] c) {
            this.messageTypes = new HashSet<LogMessageType>(Arrays.asList(m));
            this.traceCategories = new HashSet<String>(Arrays.asList(c));
        }
    }
}

