/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro;

import common.ScrollTextPanel;
import common.SwingWorker;
import common.Util;
import dguitar.codecs.guitarPro.GPKey;
import dguitar.codecs.guitarPro.GPMIDIChannel;
import dguitar.codecs.guitarPro.GPMeasureTrackPair;
import dguitar.codecs.guitarPro.GPTrackLyrics;
import java.util.ArrayList;
import java.util.List;

public class GPSong {
    public boolean tripletFeel = false;
    protected String title = "";
    protected String subtitle = "";
    protected String interpret = "";
    protected String album = "";
    protected String authorSong = "";
    protected String copyright = "";
    protected String authorPiece = "";
    protected String instruction = "";
    protected String note = "";
    protected GPTrackLyrics lyrics;
    protected int tempo = 100;
    protected GPMIDIChannel[] channels = new GPMIDIChannel[64];
    protected List tracks;
    public List measures;
    protected List measuresTracksPairs;
    protected String version = "unknown";
    SwingWorker worker;
    protected List chordsDiagrams = new ArrayList(0);
    protected GPKey key = GPKey.G;
    protected int octave = 8;

    public GPSong() {
        this.lyrics = new GPTrackLyrics();
        this.measures = new ArrayList(0);
        this.measuresTracksPairs = new ArrayList(0);
        this.tracks = new ArrayList(0);
    }

    public String getAlbum() {
        return this.album;
    }

    public String getAuthorPiece() {
        return this.authorPiece;
    }

    public String getAuthorSong() {
        return this.authorSong;
    }

    public GPMIDIChannel getChannels(int i) {
        return this.channels[i];
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public String getInterpret() {
        return this.interpret;
    }

    public GPTrackLyrics getLyrics() {
        return this.lyrics;
    }

    public String getNote() {
        return this.note;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public int getTempo() {
        return this.tempo;
    }

    public String getTitle() {
        return this.title;
    }

    public List getTracks() {
        return this.tracks;
    }

    public String getVersion() {
        return this.version;
    }

    public List getMeasures() {
        return this.measures;
    }

    public List getMeasuresTracksPairs() {
        return this.measuresTracksPairs;
    }

    public int getNumTracks() {
        int res = 0;
        if (this.tracks != null) {
            res = this.tracks.size();
        }
        return res;
    }

    public int getNumMeasures() {
        int res = 0;
        if (this.measures != null) {
            res = this.measures.size();
        }
        return res;
    }

    public GPMeasureTrackPair getTrackMeasurePair(int track, int measure) {
        return (GPMeasureTrackPair)this.measuresTracksPairs.get((measure - 1) * this.tracks.size() + track - 1);
    }

    public void startDisplayString(ScrollTextPanel stp) {
        this.worker = new StringImpl(2, stp);
        this.worker.start();
    }

    public void stopDisplayString() {
        if (this.worker != null) {
            this.worker.interrupt();
        }
    }

    public String toString() {
        return new StringImpl(100, null).toString();
    }

    public void setAlbum(String album) {
        this.album = album;
    }

    public void setAuthorPiece(String authorPiece) {
        this.authorPiece = authorPiece;
    }

    public void setAuthorSong(String authorSong) {
        this.authorSong = authorSong;
    }

    public void setChannels(int i, GPMIDIChannel channels) {
        this.channels[i] = channels;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setInstruction(String instruction) {
        this.instruction = instruction;
    }

    public void setInterpret(String interpret) {
        this.interpret = interpret;
    }

    public void setKey(GPKey key) {
        this.key = key;
    }

    public void setLyrics(GPTrackLyrics lyrics) {
        this.lyrics = lyrics;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public void setOctave(int octave) {
        this.octave = octave;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setTempo(int tempo) {
        this.tempo = tempo;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public List getChordsDiagrams() {
        return this.chordsDiagrams;
    }

    public GPKey getKey() {
        return this.key;
    }

    public GPMeasureTrackPair getMeasureTrackPair(int measure, int track) {
        return (GPMeasureTrackPair)this.measuresTracksPairs.get((measure - 1) * this.tracks.size() + track - 1);
    }

    public int getOctave() {
        return this.octave;
    }

    class StringImpl
    extends SwingWorker {
        int i;
        int j;
        int numTracks;
        int numMeasures;
        int deep;
        ScrollTextPanel STP;
        public String res;
        private int tabsStrinImpl;

        public Object construct() {
            return this.toString();
        }

        StringImpl(int howDeep, ScrollTextPanel stp) {
            this.STP = stp;
            this.tabsStrinImpl = 0;
            this.deep = howDeep;
        }

        private void resAppend(String s) {
            String aux = String.valueOf(Util.tabs(this.tabsStrinImpl)) + s;
            this.res = String.valueOf(this.res) + aux;
            if (this.STP != null) {
                this.STP.append(aux);
            }
        }

        public String toString() {
            this.res = "";
            this.resAppend("GP - BEGIN\n");
            ++this.tabsStrinImpl;
            this.resAppend("HEADER - BEGIN\n");
            this.resAppend("Version: " + GPSong.this.version + "\n");
            this.resAppend("Title: " + GPSong.this.title + "\n");
            this.resAppend("Subtitle: " + GPSong.this.subtitle + "\n");
            this.resAppend("Interpret: " + GPSong.this.interpret + "\n");
            this.resAppend("Album: " + GPSong.this.album + "\n");
            this.resAppend("Author of the song: " + GPSong.this.authorSong + "\n");
            this.resAppend("Copyright: " + GPSong.this.copyright + "\n");
            this.resAppend("Author of the piece: " + GPSong.this.authorPiece + "\n");
            this.resAppend("Instructions: " + GPSong.this.instruction + "\n");
            this.resAppend("Notes: " + GPSong.this.note);
            this.resAppend("Use triplet feel? " + GPSong.this.tripletFeel + "\n");
            this.resAppend(GPSong.this.lyrics.toString());
            this.resAppend("Tempo: " + GPSong.this.tempo + "\n");
            this.resAppend("Key: " + GPSong.this.key + "\n");
            this.resAppend("Octave: " + GPSong.this.octave + "\n");
            this.numTracks = GPSong.this.tracks.size();
            this.resAppend("Number of measures: " + GPSong.this.measures.size() + "\n");
            this.resAppend("Number of tracks: " + GPSong.this.tracks.size() + "\n");
            this.resAppend("HEADER - END\n");
            --this.tabsStrinImpl;
            if (this.deep > 1) {
                ++this.tabsStrinImpl;
                this.resAppend("MEASURES - BEGIN\n");
                this.i = 0;
                while (this.i < GPSong.this.measures.size()) {
                    this.resAppend("Measure #" + this.i + "\n");
                    this.resAppend(String.valueOf(GPSong.this.measures.get(this.i).toString()) + "\n");
                    ++this.i;
                }
                this.resAppend("MEASURES - END\n");
                --this.tabsStrinImpl;
            }
            if (this.deep > 1) {
                ++this.tabsStrinImpl;
                this.resAppend("TRACKS - BEGIN\n");
                this.i = 0;
                while (this.i < this.numTracks) {
                    this.resAppend("Track #" + (this.i + 1) + "\n");
                    this.resAppend(String.valueOf(GPSong.this.tracks.get(this.i).toString()) + "\n");
                    ++this.i;
                }
                this.resAppend("TRACKS - END\n");
                --this.tabsStrinImpl;
            }
            if (this.deep > 1) {
                ++this.tabsStrinImpl;
                this.resAppend("MEASURE-TRACK PAIRS - BEGIN\n");
                this.i = 0;
                while (this.i < GPSong.this.measuresTracksPairs.size()) {
                    this.resAppend("Measure #" + (this.i / this.numTracks + 1) + " Track #" + this.i % this.numTracks + "\n");
                    this.resAppend(String.valueOf(GPSong.this.measuresTracksPairs.get(this.i).toString()) + "\n");
                    ++this.i;
                }
                this.resAppend("MEASURE-TRACK PAIRS - END\n");
                --this.tabsStrinImpl;
            }
            if (this.deep > 1) {
                ++this.tabsStrinImpl;
                this.resAppend("MIDI Channels - BEGIN\n");
                this.i = 0;
                while (this.i < 4) {
                    this.resAppend("Port: " + this.i + "\n");
                    this.j = 0;
                    while (this.j < 16) {
                        this.resAppend("Channel: " + this.j + "\n");
                        this.resAppend(GPSong.this.channels[this.i * 16 + this.j] + "\n");
                        ++this.j;
                    }
                    ++this.i;
                }
                this.resAppend("MIDI Channels - END\n");
                --this.tabsStrinImpl;
            }
            ++this.tabsStrinImpl;
            this.resAppend("CHORD DIAGRAMS - BEGIN\n");
            this.resAppend("At this moment Chord Diagrams are not being read\n");
            this.resAppend("CHORD DIAGRAMS - END\n");
            --this.tabsStrinImpl;
            this.resAppend("GP - END");
            return this.res;
        }
    }
}

