/*
 * Decompiled with CFR 0.152.
 */
package test.suite;

import java.util.LinkedList;
import javax.sound.midi.MidiEvent;
import junit.framework.TestCase;
import test.tools.MidiTools;

public class MidiTestCase
extends TestCase {
    protected void compareMIDIFiles(String originalFile, String outputFile, int[] channelMap, String[] eventRemap) throws Exception {
        LinkedList original = new LinkedList();
        int originalPPQ = MidiTools.load(originalFile, original);
        LinkedList output = new LinkedList();
        int outputPPQ = MidiTools.load(outputFile, output);
        MidiTools.remapTicks(original, originalPPQ, outputPPQ);
        if (eventRemap != null) {
            MidiTools.remapEvents(output, eventRemap);
        }
        MidiTools.filterOptionalMeta(original);
        MidiTools.filterOptionalMeta(output);
        MidiTools.remapNoteOff(original);
        MidiTools.remapNoteOff(output);
        if (channelMap != null) {
            int i = 0;
            while (i < channelMap.length) {
                int effectsChannel = channelMap[i + 1];
                int mainChannel = channelMap[i];
                if (effectsChannel != mainChannel) {
                    MidiTools.remapChannel(original, effectsChannel, mainChannel);
                }
                i += 2;
            }
        }
        MidiTools.prioritizeByChannel(original);
        MidiTools.prioritizeByChannel(output);
        while (!original.isEmpty() && !output.isEmpty()) {
            MidiEvent e1 = (MidiEvent)original.remove(0);
            MidiEvent e2 = (MidiEvent)output.remove(0);
            String s1 = MidiTools.stringize(e1);
            String s2 = MidiTools.stringize(e2);
            MidiTestCase.assertEquals((String)s1, (String)s2);
        }
        if (!original.isEmpty()) {
            MidiEvent e = (MidiEvent)original.get(0);
            MidiTestCase.assertTrue((String)("additional event in original " + MidiTools.stringize(e)), (boolean)original.isEmpty());
        }
        MidiTestCase.assertTrue((boolean)output.isEmpty());
    }
}

