/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.util.AttributeSource;

public final class EdgeNGramTokenFilter
extends TokenFilter {
    public static final int DEFAULT_MAX_GRAM_SIZE = 1;
    public static final int DEFAULT_MIN_GRAM_SIZE = 1;
    private final int minGram;
    private final int maxGram;
    private char[] curTermBuffer;
    private int curTermLength;
    private int curCodePointCount;
    private int curGramSize;
    private int savePosIncr;
    private AttributeSource.State state;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);

    public EdgeNGramTokenFilter(TokenStream input, int minGram, int maxGram) {
        super(input);
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
    }

    public final boolean incrementToken() throws IOException {
        while (true) {
            if (this.curTermBuffer == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                this.curTermBuffer = (char[])this.termAtt.buffer().clone();
                this.curTermLength = this.termAtt.length();
                this.curCodePointCount = Character.codePointCount((CharSequence)this.termAtt, 0, this.termAtt.length());
                this.curGramSize = this.minGram;
                this.state = this.captureState();
                this.savePosIncr += this.posIncrAtt.getPositionIncrement();
            }
            if (this.curGramSize <= this.maxGram && this.curGramSize <= this.curCodePointCount) {
                this.restoreState(this.state);
                if (this.curGramSize == this.minGram) {
                    this.posIncrAtt.setPositionIncrement(this.savePosIncr);
                    this.savePosIncr = 0;
                } else {
                    this.posIncrAtt.setPositionIncrement(0);
                }
                int charLength = Character.offsetByCodePoints(this.curTermBuffer, 0, this.curTermLength, 0, this.curGramSize);
                this.termAtt.copyBuffer(this.curTermBuffer, 0, charLength);
                ++this.curGramSize;
                return true;
            }
            this.curTermBuffer = null;
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.curTermBuffer = null;
        this.savePosIncr = 0;
    }
}

