/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d.geom;

import org.apache.lucene.spatial3d.geom.Bounds;
import org.apache.lucene.spatial3d.geom.DistanceStyle;
import org.apache.lucene.spatial3d.geom.GeoBaseAreaShape;
import org.apache.lucene.spatial3d.geom.GeoDistanceShape;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.spatial3d.geom.Vector;

public abstract class GeoBaseDistanceShape
extends GeoBaseAreaShape
implements GeoDistanceShape {
    public GeoBaseDistanceShape(PlanetModel planetModel) {
        super(planetModel);
    }

    @Override
    public boolean isWithin(Vector point) {
        return this.isWithin(point.x, point.y, point.z);
    }

    @Override
    public double computeDistance(DistanceStyle distanceStyle, GeoPoint point) {
        return this.computeDistance(distanceStyle, point.x, point.y, point.z);
    }

    @Override
    public double computeDistance(DistanceStyle distanceStyle, double x, double y, double z) {
        if (!this.isWithin(x, y, z)) {
            return Double.POSITIVE_INFINITY;
        }
        return this.distance(distanceStyle, x, y, z);
    }

    protected abstract double distance(DistanceStyle var1, double var2, double var4, double var6);

    @Override
    public void getDistanceBounds(Bounds bounds, DistanceStyle distanceStyle, double distanceValue) {
        if (distanceValue == Double.POSITIVE_INFINITY) {
            this.getBounds(bounds);
            return;
        }
        this.distanceBounds(bounds, distanceStyle, distanceValue);
    }

    protected abstract void distanceBounds(Bounds var1, DistanceStyle var2, double var3);
}

