/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.util.Arrays;

public final class Transports
extends Enum<Transports> {
    public static final String TEST_MOCK_TRANSPORT_THREAD_PREFIX = "__mock_network_thread";
    public static final String NIO_TRANSPORT_WORKER_THREAD_NAME_PREFIX = "es_nio_transport_worker";
    public static final String NIO_TRANSPORT_ACCEPTOR_THREAD_NAME_PREFIX = "es_nio_transport_acceptor";
    private static final /* synthetic */ Transports[] $VALUES;

    public static Transports[] values() {
        return (Transports[])$VALUES.clone();
    }

    public static Transports valueOf(String name) {
        return Enum.valueOf(Transports.class, name);
    }

    public static final boolean isTransportThread(Thread t) {
        String threadName = t.getName();
        for (String s : Arrays.asList("http_server_worker", "transport_server_worker", "transport_client_boss", TEST_MOCK_TRANSPORT_THREAD_PREFIX, NIO_TRANSPORT_WORKER_THREAD_NAME_PREFIX, NIO_TRANSPORT_ACCEPTOR_THREAD_NAME_PREFIX)) {
            if (!threadName.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean assertTransportThread() {
        Thread t = Thread.currentThread();
        assert (Transports.isTransportThread(t)) : "Expected transport thread but got [" + t + "]";
        return true;
    }

    public static boolean assertNotTransportThread(String reason) {
        Thread t = Thread.currentThread();
        assert (!Transports.isTransportThread(t)) : "Expected current thread [" + t + "] to not be a transport thread. Reason: [" + reason + "]";
        return true;
    }

    static {
        $VALUES = new Transports[0];
    }
}

