/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.Definition;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStoreable;
import org.objectweb.asm.Type;

final class PSubDefArray
extends AStoreable {
    private AExpression index;

    PSubDefArray(Location location, AExpression index) {
        super(location);
        this.index = Objects.requireNonNull(index);
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("Illegal tree structure."));
    }

    @Override
    void analyze(Locals locals) {
        this.index.analyze(locals);
        this.index.expected = this.index.actual;
        this.index = this.index.cast(locals);
        this.actual = this.expected == null || this.explicit ? locals.getDefinition().DefType : this.expected;
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        this.setup(writer, globals);
        this.load(writer, globals);
    }

    @Override
    int accessElementCount() {
        return 2;
    }

    @Override
    boolean isDefOptimized() {
        return true;
    }

    @Override
    void updateActual(Definition.Type actual) {
        this.actual = actual;
    }

    @Override
    void setup(MethodWriter writer, Globals globals) {
        writer.dup();
        this.index.write(writer, globals);
        Type methodType = Type.getMethodType((Type)this.index.actual.type, (Type[])new Type[]{Type.getType(Object.class), this.index.actual.type});
        writer.invokeDefCall("normalizeIndex", methodType, 10, new Object[0]);
    }

    @Override
    void load(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        Type methodType = Type.getMethodType((Type)this.actual.type, (Type[])new Type[]{Type.getType(Object.class), this.index.actual.type});
        writer.invokeDefCall("arrayLoad", methodType, 3, new Object[0]);
    }

    @Override
    void store(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        Type methodType = Type.getMethodType((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Object.class), this.index.actual.type, this.actual.type});
        writer.invokeDefCall("arrayStore", methodType, 4, new Object[0]);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.prefix, this.index);
    }
}

