/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.data.Config;
import esmska.data.Contact;
import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.SMS;
import esmska.utils.MiscUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class Envelope {
    private static final Config config = Config.getInstance();
    private static final Logger logger = Logger.getLogger(Envelope.class.getName());
    private static final Gateways gateways = Gateways.getInstance();
    private String text = "";
    private Set<Contact> contacts = new HashSet<Contact>();
    private Gateway gateway;
    private String senderName;
    private static final double wordCutSpread = 0.1;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        text = StringUtils.defaultString(text, "");
        String oldText = this.text;
        if (config.isRemoveAccents()) {
            text = MiscUtils.removeAccents(text);
        }
        this.text = text;
        this.changeSupport.firePropertyChange("text", oldText, text);
    }

    public Set<Contact> getContacts() {
        return Collections.unmodifiableSet(this.contacts);
    }

    public void setContacts(Set<Contact> contacts) {
        Set<Contact> oldContacts = this.contacts;
        this.contacts = contacts;
        this.gateway = this.computeWorstGateway();
        this.senderName = this.extractSenderName();
        this.changeSupport.firePropertyChange("contacts", oldContacts, contacts);
    }

    public String getSenderName() {
        return this.senderName;
    }

    private Gateway computeWorstGateway() {
        Gateway worstGateway = null;
        int worstLength = Integer.MAX_VALUE;
        for (Contact c : this.contacts) {
            Gateway gw = gateways.get(c.getGateway());
            if (gw == null || gw.getSMSLength() >= worstLength) continue;
            worstLength = gw.getSMSLength();
            worstGateway = gw;
        }
        return worstGateway;
    }

    private String extractSenderName() {
        if (this.gateway == null) {
            return "";
        }
        return this.gateway.getSenderName();
    }

    public int getMaxTextLength(String customText) {
        if (this.gateway == null) {
            return 1000;
        }
        int maxLength = this.gateway.getMaxChars() * this.gateway.getMaxParts();
        int lostChars = this.computeLostCharsByWordCutting(customText, this.gateway.getMaxChars());
        return maxLength -= lostChars;
    }

    public int getMaxTextLength() {
        return this.getMaxTextLength(this.text);
    }

    public int getSMSLength() {
        if (this.gateway != null) {
            return this.gateway.getSMSLength();
        }
        return 1000;
    }

    public int getSMSCount(String msgText, int limit) {
        return this.getIndicesOfCuts(msgText, limit).size();
    }

    public ArrayList<SMS> generate() {
        ArrayList<SMS> list = new ArrayList<SMS>();
        for (Contact c : this.contacts) {
            Gateway gateway = gateways.get(c.getGateway());
            int limit = gateway != null ? gateway.getMaxChars() : 1000;
            String msgText = this.text;
            if (this.contacts.size() > 1 && gateway != null && !StringUtils.startsWith(msgText = StringUtils.removeStart(this.text, this.senderName), gateway.getSenderName())) {
                msgText = gateway.getSenderName() + msgText;
            }
            String messageId = SMS.generateID();
            ArrayList<String> messages = this.cutOutMessages(msgText, limit);
            for (String cutText : messages) {
                SMS sms = new SMS(c.getNumber(), cutText, c.getGateway(), c.getName(), messageId);
                list.add(sms);
            }
        }
        logger.log(Level.FINE, "Envelope specified for {0} contact(s) generated {1} SMS(s)", new Object[]{this.contacts.size(), list.size()});
        return list;
    }

    private ArrayList<String> cutOutMessages(String msgText, int limit) {
        ArrayList<String> messages = new ArrayList<String>();
        int from = 0;
        for (Integer to : this.getIndicesOfCuts(msgText, limit)) {
            String cutText = msgText.substring(from, to);
            messages.add(cutText);
            from = to;
        }
        return messages;
    }

    public ArrayList<Integer> getIndicesOfCuts(String msgText, int limit) {
        int cutLength;
        ArrayList<Integer> listOfCuts = new ArrayList<Integer>();
        if (limit <= 0) {
            return listOfCuts;
        }
        for (int from = 0; from < msgText.length(); from += cutLength) {
            int indexOfCut = this.findIndexOfCut(msgText, from, limit);
            cutLength = indexOfCut - from;
            if (cutLength <= 0) {
                throw new IllegalStateException("Error while message cutting");
            }
            listOfCuts.add(indexOfCut);
        }
        return listOfCuts;
    }

    private int findIndexOfCut(String msgText, int start, int limit) {
        int indexOfCut = start + limit;
        if (indexOfCut >= msgText.length()) {
            return msgText.length();
        }
        if (Character.isWhitespace(msgText.charAt(indexOfCut)) || Character.isWhitespace(msgText.charAt(indexOfCut - 1))) {
            return indexOfCut;
        }
        int minIndexOfCut = start + (int)((double)limit * 0.9);
        while (indexOfCut > 0 && !Character.isWhitespace(msgText.charAt(indexOfCut - 1))) {
            if (--indexOfCut >= minIndexOfCut) continue;
            return start + limit;
        }
        return indexOfCut;
    }

    public int getPenultimateIndexOfCut(String msgText, int limit) {
        ArrayList<Integer> indicesOfCuts = this.getIndicesOfCuts(msgText, limit);
        if (indicesOfCuts.size() <= 1) {
            return 0;
        }
        return indicesOfCuts.get(indicesOfCuts.size() - 2);
    }

    private int computeLostCharsByWordCutting(String msgText, int limit) {
        int lostChars = (this.getSMSCount(msgText, limit) - 1) * limit - this.getPenultimateIndexOfCut(msgText, limit);
        if (lostChars <= 0) {
            return 0;
        }
        return lostChars;
    }
}

