/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.Context;
import esmska.data.Contact;
import esmska.data.Contacts;
import esmska.data.CountryPrefix;
import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.Icons;
import esmska.data.Log;
import esmska.data.event.ActionEventSupport;
import esmska.data.event.ValuedEvent;
import esmska.data.event.ValuedListener;
import esmska.gui.EditContactPanel;
import esmska.gui.ListPopupMouseListener;
import esmska.gui.dnd.ImportContactsTransferHandler;
import esmska.utils.L10N;
import esmska.utils.MiscUtils;
import esmska.utils.RuntimeUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.StringUtils;
import org.pushingpixels.substance.api.renderers.SubstanceDefaultListCellRenderer;

public class ContactPanel
extends JPanel {
    public static final int ACTION_CONTACT_SELECTION_CHANGED = 0;
    public static final int ACTION_CONTACT_CHOSEN = 1;
    private static final String RES = "/esmska/resources/";
    private static final Logger logger = Logger.getLogger(ContactPanel.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final Contacts contacts = Contacts.getInstance();
    private static final Log log = Log.getInstance();
    private static final Gateways gateways = Gateways.getInstance();
    private Action addContactAction = new AddContactAction(null);
    private Action editContactAction = new EditContactAction();
    private Action removeContactAction = new RemoveContactAction();
    private Action chooseContactAction = new ChooseContactAction();
    private SearchContactAction searchContactAction = new SearchContactAction();
    private ContactListModel contactListModel = new ContactListModel();
    private ContactPopupMenu popup = new ContactPopupMenu();
    private ContactMouseListener mouseListener;
    private ActionEventSupport actionSupport = new ActionEventSupport(this);
    private JButton addContactButton;
    private JList contactList;
    private JButton editContactButton;
    private JScrollPane jScrollPane4;
    private JButton removeContactButton;

    public void addActionListener(ActionListener actionListener) {
        this.actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionSupport.removeActionListener(actionListener);
    }

    public ContactPanel() {
        this.initComponents();
        this.mouseListener = new ContactMouseListener(this.contactList, this.popup);
        this.contactList.addMouseListener(this.mouseListener);
        this.contactList.setDropMode(DropMode.ON);
        this.contactList.setTransferHandler(new ImportContactsTransferHandler());
        ((ContactList)this.contactList).showNewContactHint(contacts.size() <= 0);
        contacts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ContactList)ContactPanel.this.contactList).showNewContactHint(contacts.size() <= 0);
            }
        });
        gateways.addValuedListener(new ValuedListener<Gateways.Events, Gateway>(){

            @Override
            public void eventOccured(ValuedEvent<Gateways.Events, Gateway> e) {
                switch (e.getEvent()) {
                    case ADDED_GATEWAY: 
                    case ADDED_GATEWAYS: 
                    case CLEARED_GATEWAYS: 
                    case REMOVED_GATEWAY: 
                    case REMOVED_GATEWAYS: {
                        ContactPanel.this.contactList.repaint();
                    }
                }
            }
        });
    }

    public void clearSelection() {
        this.contactList.clearSelection();
    }

    public void setSelectedContact(Contact contact) {
        this.contactList.setSelectedValue(contact, true);
    }

    public boolean setSelectedContact(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        for (Contact c : contacts.getAll()) {
            if (!c.getName().equals(name)) continue;
            this.contactList.setSelectedValue(c, true);
            return true;
        }
        return false;
    }

    public HashSet<Contact> getSelectedContacts() {
        HashSet<Contact> selectedContacts = new HashSet<Contact>();
        for (Object o : this.contactList.getSelectedValues()) {
            selectedContacts.add((Contact)o);
        }
        return selectedContacts;
    }

    public void ensureContactSelected() {
        if (this.contactList.getSelectedIndex() < 0 && this.contactListModel.getSize() > 0) {
            this.contactList.setSelectedIndex(0);
        }
    }

    public void makeNiceSelection() {
        int[] indices = this.contactList.getSelectedIndices();
        if (indices.length != 1) {
            return;
        }
        this.setSelectedContactIndexWithMargins(indices[0]);
    }

    public void showAddContactDialog(Contact skeleton) {
        AddContactAction action = new AddContactAction(skeleton);
        action.actionPerformed(null);
    }

    private void setSelectedContactIndexWithMargins(int index) {
        this.contactList.setSelectedIndex(index);
        for (int j = index - 3; j <= index + 3; ++j) {
            if (j < 0 || j >= this.contactListModel.getSize()) continue;
            this.contactList.ensureIndexIsVisible(j);
        }
        this.contactList.ensureIndexIsVisible(index);
    }

    private void initComponents() {
        this.addContactButton = new JButton();
        this.removeContactButton = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.contactList = new ContactList();
        this.editContactButton = new JButton();
        this.setBorder(BorderFactory.createTitledBorder(l10n.getString("ContactPanel.border.title")));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                ContactPanel.this.formFocusGained(evt);
            }
        });
        this.addContactButton.setAction(this.addContactAction);
        this.addContactButton.setHideActionText(true);
        this.addContactButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.addContactButton.setText(l10n.getString("Add"));
        this.removeContactButton.setAction(this.removeContactAction);
        this.removeContactButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.removeContactButton.setText("");
        this.contactList.setModel(this.contactListModel);
        this.contactList.setToolTipText(l10n.getString("ContactPanel.contactList.toolTipText"));
        this.contactList.setCellRenderer(new ContactListRenderer());
        String command = "choose contact";
        this.contactList.getInputMap().put(KeyStroke.getKeyStroke(10, 0), command);
        this.contactList.getActionMap().put(command, this.chooseContactAction);
        command = "focus contacts";
        this.getInputMap(2).put(KeyStroke.getKeyStroke(75, 512), command);
        this.getActionMap().put(command, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContactPanel.this.contactList.requestFocusInWindow();
            }
        });
        this.contactList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ContactPanel.this.contactListValueChanged(evt);
            }
        });
        this.contactList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ContactPanel.this.contactListKeyPressed(evt);
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                ContactPanel.this.contactListKeyTyped(evt);
            }
        });
        this.jScrollPane4.setViewportView(this.contactList);
        this.editContactButton.setAction(this.editContactAction);
        this.editContactButton.putClientProperty("substancelaf.componentFlat", Boolean.TRUE);
        this.editContactButton.setText("");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addContactButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editContactButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeContactButton)).addComponent(this.jScrollPane4, -1, 242, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane4, -1, 326, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addContactButton).addComponent(this.editContactButton).addComponent(this.removeContactButton)).addContainerGap()));
    }

    private void contactListValueChanged(ListSelectionEvent evt) {
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int count = this.contactList.getSelectedIndices().length;
        this.removeContactAction.setEnabled(count > 0);
        this.editContactAction.setEnabled(count > 0);
        this.actionSupport.fireActionPerformed(0, null);
    }

    private void formFocusGained(FocusEvent evt) {
        this.contactList.requestFocusInWindow();
    }

    private void contactListKeyTyped(KeyEvent evt) {
        if (evt.isActionKey() || evt.isAltDown() || evt.isAltGraphDown() || evt.isControlDown() || evt.isMetaDown()) {
            return;
        }
        char chr = evt.getKeyChar();
        if (Character.isISOControl(chr)) {
            return;
        }
        String searchString = this.searchContactAction.getSearchString();
        searchString = searchString + Character.toLowerCase(chr);
        this.searchContactAction.setSearchString(searchString);
        this.searchContactAction.actionPerformed(null);
    }

    private void contactListKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 8) {
            String searchString = this.searchContactAction.getSearchString();
            if (searchString.length() > 0) {
                searchString = searchString.substring(0, searchString.length() - 1);
                this.searchContactAction.setSearchString(searchString);
                this.searchContactAction.actionPerformed(null);
            }
            return;
        }
        if (evt.getKeyCode() == 27) {
            this.searchContactAction.setSearchString("");
            this.searchContactAction.actionPerformed(null);
            return;
        }
        if (!(evt.getKeyCode() != 38 && evt.getKeyCode() != 40 || this.searchContactAction.getSearchString().equals(""))) {
            int index = Math.max(this.contactList.getSelectedIndex(), 0);
            if (evt.getKeyCode() == 40) {
                ++index;
                while (index < this.contactListModel.getSize()) {
                    Contact contact = this.contactListModel.getElementAt(index);
                    if (this.searchContactAction.isContactMatched(contact)) {
                        this.setSelectedContactIndexWithMargins(index);
                        break;
                    }
                    ++index;
                }
            } else {
                --index;
                while (index >= 0) {
                    Contact contact = this.contactListModel.getElementAt(index);
                    if (this.searchContactAction.isContactMatched(contact)) {
                        this.setSelectedContactIndexWithMargins(index);
                        break;
                    }
                    --index;
                }
            }
            evt.consume();
            this.searchContactAction.restartTimer();
            ((ContactList)this.contactList).repaintSearchField();
        }
        if (evt.getKeyCode() == 127) {
            this.removeContactButton.doClick(0);
            return;
        }
    }

    private class ContactMouseListener
    extends ListPopupMouseListener {
        public ContactMouseListener(JList list, JPopupMenu popup) {
            super(list, popup);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                ContactPanel.this.editContactAction.actionPerformed(null);
            } else if (SwingUtilities.isMiddleMouseButton(e)) {
                int index = this.list.locationToIndex(e.getPoint());
                if (index >= 0 && !this.list.isSelectedIndex(index)) {
                    this.list.setSelectedIndex(index);
                }
                ContactPanel.this.chooseContactAction.actionPerformed(null);
            }
        }
    }

    private class ContactPopupMenu
    extends JPopupMenu {
        public ContactPopupMenu() {
            JMenuItem menuItem = null;
            menuItem = new JMenuItem(ContactPanel.this.addContactAction);
            this.add(menuItem);
            menuItem = new JMenuItem(ContactPanel.this.editContactAction);
            this.add(menuItem);
            menuItem = new JMenuItem(ContactPanel.this.removeContactAction);
            this.add(menuItem);
        }
    }

    private class ContactListRenderer
    extends SubstanceDefaultListCellRenderer {
        private final ListCellRenderer lafRenderer = new JList().getCellRenderer();
        private final URL contactIconURI = this.getClass().getResource("/esmska/resources/contact-32.png");

        private ContactListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = this.lafRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Contact contact = (Contact)value;
            JLabel label = (JLabel)c;
            Gateway gateway = gateways.get(contact.getGateway());
            label.setIcon(gateway != null && !gateway.isHidden() ? gateway.getIcon() : Icons.GATEWAY_BLANK);
            String tooltip = "<html><table><tr><td><img src=\"" + this.contactIconURI + "\"></td><td valign=top><b>" + MiscUtils.escapeHtml(contact.getName()) + "</b><br>" + CountryPrefix.stripCountryPrefix(contact.getNumber(), true) + "<br>" + MiscUtils.escapeHtml(contact.getGateway()) + "</td></tr></table></html>";
            label.setToolTipText(tooltip);
            if (!ContactPanel.this.searchContactAction.getSearchString().equals("") && !ContactPanel.this.searchContactAction.isContactMatched(contact)) {
                label.setBackground(label.getBackground().darker());
                label.setForeground(label.getForeground().darker());
            }
            return label;
        }
    }

    private class ContactDialog
    extends JDialog
    implements PropertyChangeListener {
        private final ImageIcon contactIcon;
        private EditContactPanel panel;
        private JOptionPane optionPane;
        private Contact contact;
        private Object[] options;
        private Object initialValue;
        private Object confirmOption;

        public ContactDialog() {
            super((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, ContactPanel.this), l10n.getString("Contact"), true);
            this.contactIcon = Icons.get("contact-48.png");
            RuntimeUtils.setDocumentModalDialog(this);
            this.init();
            this.setDefaultCloseOperation(1);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    ContactDialog.this.formWindowClosing(evt);
                }
            });
        }

        private void init() {
            this.panel = new EditContactPanel();
            this.optionPane = new JOptionPane(this.panel, 3, -1, this.contactIcon, this.options, this.initialValue);
            this.optionPane.addPropertyChangeListener(this);
            this.setContentPane(this.optionPane);
            this.pack();
            this.panel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getID() == 0) {
                        ContactDialog.this.pack();
                    }
                }
            });
        }

        public void setOptions(Object[] options, Object initialValue, Object confirmOption) {
            this.options = options;
            this.initialValue = initialValue;
            this.confirmOption = confirmOption;
        }

        public void show(Contact contact) {
            logger.fine("Showing edit contact dialog for contact: " + contact);
            this.contact = contact;
            this.init();
            this.setLocationRelativeTo(Context.mainFrame);
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            this.panel.setContact(contact);
            this.panel.prepareForShow();
            this.setVisible(true);
        }

        public void show(Collection<Contact> contacts) {
            if (contacts.size() <= 1) {
                this.show(contacts.size() <= 0 ? null : contacts.iterator().next());
                return;
            }
            logger.fine("Showing edit contact dialog for " + contacts.size() + " contacts");
            this.contact = null;
            this.init();
            this.setLocationRelativeTo(Context.mainFrame);
            this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            this.panel.setContacts(contacts);
            this.panel.prepareForShow();
            this.setVisible(true);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (this.isVisible() && e.getSource() == this.optionPane && "value".equals(prop)) {
                Object value = this.optionPane.getValue();
                if (value == JOptionPane.UNINITIALIZED_VALUE) {
                    return;
                }
                if (!value.equals(this.confirmOption)) {
                    this.contact = null;
                    this.setVisible(false);
                    return;
                }
                if (!this.panel.validateForm()) {
                    this.optionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                    return;
                }
                this.contact = this.panel.getContact();
                this.setVisible(false);
            }
        }

        public Contact getContact() {
            return this.contact;
        }

        private void formWindowClosing(WindowEvent evt) {
            if (evt == null) {
                return;
            }
            this.contact = null;
        }
    }

    private class ContactListModel
    extends AbstractListModel {
        private int oldSize = this.getSize();

        public ContactListModel() {
            contacts.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    switch (e.getID()) {
                        case 0: 
                        case 3: {
                            ContactListModel.this.fireContentsChanged(ContactListModel.this, 0, ContactListModel.this.getSize());
                            break;
                        }
                        case 1: 
                        case 2: {
                            ContactListModel.this.fireIntervalRemoved(ContactListModel.this, 0, ContactListModel.this.oldSize);
                            break;
                        }
                        default: {
                            logger.warning("Unknown action event type");
                            assert (false) : "Unknown action event type";
                            break;
                        }
                    }
                    ContactListModel.this.oldSize = ContactListModel.this.getSize();
                }
            });
        }

        @Override
        public int getSize() {
            return contacts.size();
        }

        @Override
        public Contact getElementAt(int index) {
            return contacts.getAll().toArray(new Contact[0])[index];
        }
    }

    private class ContactList
    extends JList {
        JTextField searchField = new JTextField();
        JLabel newContactLabel = new JLabel(ContactPanel.access$800().getString("ContactPanel.new_contact_hint"));

        public ContactList() {
            this.searchField.setFocusable(false);
            this.newContactLabel.setVerticalAlignment(1);
            this.newContactLabel.setForeground(SystemColor.textInactiveText);
            Contacts.getInstance().addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = ContactList.this.getSelectedIndex();
                    switch (e.getID()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            ContactList.this.clearSelection();
                            break;
                        }
                        case 3: {
                            ContactList.this.clearSelection();
                            ContactList.this.setSelectedIndex(index);
                            break;
                        }
                        default: {
                            logger.warning("Unknown action event type");
                            assert (false) : "Unknown action event type";
                            break;
                        }
                    }
                }
            });
        }

        public void showSearchField(String text) {
            if (StringUtils.isEmpty(text)) {
                this.remove(this.searchField);
            } else {
                this.searchField.setText(text);
                if (this.searchField.getParent() == null) {
                    this.add(this.searchField);
                }
            }
            this.searchField.invalidate();
            this.validate();
        }

        public void showNewContactHint(boolean show) {
            if (show && this.newContactLabel.getParent() == null) {
                this.add(this.newContactLabel);
            } else {
                this.remove(this.newContactLabel);
            }
        }

        public void repaintSearchField() {
            Rectangle oldBounds = this.searchField.getBounds();
            this.searchField.invalidate();
            ContactPanel.this.contactList.validate();
            ContactPanel.this.contactList.repaint(oldBounds);
            ContactPanel.this.contactList.repaint(this.searchField.getBounds());
        }

        @Override
        public void doLayout() {
            int width;
            int height;
            Rectangle visibleRect;
            super.doLayout();
            if (this.searchField.getParent() != null) {
                visibleRect = this.getVisibleRect();
                height = (int)this.searchField.getPreferredSize().getHeight();
                width = (int)this.searchField.getPreferredSize().getWidth() + 1;
                this.searchField.setBounds(visibleRect.x + visibleRect.width - width, visibleRect.y + visibleRect.height - height, width, height);
            }
            if (this.newContactLabel.getParent() != null) {
                visibleRect = this.getVisibleRect();
                height = visibleRect.height - 10;
                width = visibleRect.width - 10;
                this.newContactLabel.setBounds(visibleRect.x + 5, visibleRect.y + 5, width, height);
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.searchField != null) {
                this.searchField.updateUI();
            }
        }
    }

    private class SearchContactAction
    extends AbstractAction {
        private String searchString = "";
        private Timer timer = new Timer(2000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchContactAction.this.searchString = "";
                SearchContactAction.this.actionPerformed(null);
            }
        });

        public SearchContactAction() {
            this.timer.setRepeats(false);
        }

        private void updateRendering() {
            ((ContactList)ContactPanel.this.contactList).showSearchField(this.searchString);
            ContactPanel.this.contactList.repaint();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.searchString.equals("")) {
                this.updateRendering();
                return;
            }
            for (int i = 0; i < ContactPanel.this.contactListModel.getSize(); ++i) {
                Contact contact = ContactPanel.this.contactListModel.getElementAt(i);
                if (!this.isContactMatched(contact)) continue;
                ContactPanel.this.setSelectedContactIndexWithMargins(i);
                break;
            }
            this.updateRendering();
            this.restartTimer();
        }

        public boolean isContactMatched(Contact contact) {
            if (this.searchString.equals("")) {
                return true;
            }
            String name = contact.getName().toLowerCase();
            return name.contains(this.searchString) || MiscUtils.removeAccents(name).contains(this.searchString) || contact.getNumber().contains(this.searchString);
        }

        public void setSearchString(String searchString) {
            this.searchString = StringUtils.lowerCase(searchString);
        }

        public String getSearchString() {
            return this.searchString;
        }

        public void restartTimer() {
            this.timer.restart();
        }
    }

    private class ChooseContactAction
    extends AbstractAction {
        private ChooseContactAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ContactPanel.this.contactList.getSelectedIndex() >= 0) {
                ContactPanel.this.actionSupport.fireActionPerformed(1, null);
            }
        }
    }

    private class RemoveContactAction
    extends AbstractAction {
        private final String deleteOption;
        private final String cancelOption;
        private final Object[] options;

        public RemoveContactAction() {
            super(l10n.getString("Delete_contacts"), Icons.get("delete-16.png"));
            this.deleteOption = l10n.getString("Delete");
            this.cancelOption = l10n.getString("Cancel");
            this.options = RuntimeUtils.sortDialogOptions(this.cancelOption, this.deleteOption);
            this.putValue("ShortDescription", l10n.getString("Delete_selected_contacts"));
            this.putValue("SwingLargeIconKey", Icons.get("delete-22.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContactPanel.this.contactList.requestFocusInWindow();
            HashSet<Contact> condemned = ContactPanel.this.getSelectedContacts();
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JLabel label = new JLabel(l10n.getString("ContactPanel.remove_following_contacts"));
            JTextArea area = new JTextArea();
            area.setEditable(false);
            area.setRows(5);
            for (Contact c : condemned) {
                area.append(c.getName() + "\n");
            }
            area.setCaretPosition(0);
            panel.add((Component)label, "First");
            panel.add((Component)new JScrollPane(area), "Center");
            JOptionPane pane = new JOptionPane(panel, 2, -1, null, this.options, this.deleteOption);
            JDialog dialog = pane.createDialog(Context.mainFrame, null);
            dialog.setResizable(true);
            RuntimeUtils.setDocumentModalDialog(dialog);
            dialog.pack();
            dialog.setVisible(true);
            if (!this.deleteOption.equals(pane.getValue())) {
                return;
            }
            contacts.removeAll(condemned);
            String message = condemned.size() == 1 ? MessageFormat.format(l10n.getString("ContactPanel.removeContact"), condemned.iterator().next().getName()) : MessageFormat.format(l10n.getString("ContactPanel.removeContacts"), condemned.size());
            log.addRecord(new Log.Record(message, null, Icons.STATUS_INFO));
        }
    }

    private class EditContactAction
    extends AbstractAction {
        private final String saveOption;
        private final String cancelOption;
        private final Object[] options;

        public EditContactAction() {
            super(l10n.getString("Edit_contacts"), Icons.get("edit-16.png"));
            this.saveOption = l10n.getString("Save");
            this.cancelOption = l10n.getString("Cancel");
            this.options = RuntimeUtils.sortDialogOptions(this.cancelOption, this.saveOption);
            this.putValue("ShortDescription", l10n.getString("Edit_selected_contacts"));
            this.putValue("SwingLargeIconKey", Icons.get("edit-22.png"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContactPanel.this.contactList.requestFocusInWindow();
            Object[] selected = ContactPanel.this.contactList.getSelectedValues();
            if (selected.length <= 0) {
                logger.warning("Trying to edit contact when none selected");
                return;
            }
            ContactDialog contactDialog = new ContactDialog();
            contactDialog.setOptions(this.options, this.saveOption, this.saveOption);
            if (selected.length == 1) {
                Contact contact = (Contact)selected[0];
                contactDialog.setTitle(l10n.getString("Edit_contact"));
                Contact edited = new Contact(contact);
                contactDialog.show(edited);
                edited = contactDialog.getContact();
                if (edited == null) {
                    return;
                }
                contact.copyFrom(edited);
                ContactPanel.this.contactList.setSelectedValue(contact, true);
                log.addRecord(new Log.Record(MessageFormat.format(l10n.getString("ContactPanel.editedContact"), contact.getName()), null, Icons.STATUS_INFO));
            } else {
                contactDialog.setTitle(l10n.getString("Edit_contacts_collectively"));
                ArrayList<Contact> list = new ArrayList<Contact>(selected.length);
                for (Object object : selected) {
                    list.add((Contact)object);
                }
                contactDialog.show(list);
                Contact c = contactDialog.getContact();
                if (c == null) {
                    return;
                }
                int[] selection = ContactPanel.this.contactList.getSelectedIndices();
                for (Contact contact : list) {
                    contact.setGateway(c.getGateway());
                }
                ContactPanel.this.contactList.setSelectedIndices(selection);
                log.addRecord(new Log.Record(MessageFormat.format(l10n.getString("ContactPanel.editedContacts"), list.size()), null, Icons.STATUS_INFO));
            }
        }
    }

    private class AddContactAction
    extends AbstractAction {
        private final String createOption;
        private final String cancelOption;
        private final Object[] options;
        private final Contact skeleton;

        public AddContactAction(Contact skeleton) {
            super(l10n.getString("Add_contact"), Icons.get("add-16.png"));
            this.createOption = l10n.getString("Create");
            this.cancelOption = l10n.getString("Cancel");
            this.options = RuntimeUtils.sortDialogOptions(this.cancelOption, this.createOption);
            this.putValue("ShortDescription", l10n.getString("Add_new_contact"));
            this.putValue("SwingLargeIconKey", Icons.get("add-22.png"));
            this.putValue("MnemonicKey", 65);
            this.skeleton = skeleton;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ContactPanel.this.contactList.requestFocusInWindow();
            ContactDialog contactDialog = new ContactDialog();
            contactDialog.setTitle(l10n.getString("New_contact"));
            contactDialog.setOptions(this.options, this.createOption, this.createOption);
            contactDialog.show(this.skeleton);
            Contact c = contactDialog.getContact();
            if (c == null) {
                return;
            }
            contacts.add(c);
            ContactPanel.this.contactList.setSelectedValue(c, true);
            log.addRecord(new Log.Record(MessageFormat.format(l10n.getString("ContactPanel.addedContact"), c.getName()), null, Icons.STATUS_INFO));
        }
    }
}

