/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.Config;
import esmska.data.Icons;
import esmska.data.SMS;
import esmska.gui.ClipboardPopupMenu;
import esmska.gui.GatewayMessage;
import esmska.gui.GatewayMessageFrame;
import esmska.gui.JHtmlLabel;
import esmska.gui.ThemeManager;
import esmska.utils.RuntimeUtils;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.lang.StringUtils;
import org.openide.awt.Mnemonics;

public class GatewayImageCodeMessage
extends GatewayMessage {
    private static final Config config = Config.getInstance();
    private static final ImageIcon ICON = Icons.get("keyring-16.png");
    private SMS sms;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JTextField codeTextField;
    private JHtmlLabel imageLabel;
    private JLabel jLabel2;
    private JButton okButton;

    public GatewayImageCodeMessage() {
        this.initComponents();
        JButton[] buttons = RuntimeUtils.sortOptions(this.cancelButton, this.okButton);
        this.buttonPanel.removeAll();
        this.buttonPanel.add(buttons[0]);
        this.buttonPanel.add(buttons[1]);
        if (!config.getLookAndFeel().equals((Object)ThemeManager.LAF.SUBSTANCE)) {
            ClipboardPopupMenu.register(this.codeTextField);
        }
    }

    public GatewayMessageFrame.TaskPane showImageCodeMsg(SMS sms) {
        this.sms = sms;
        if (sms.getImage() == null && StringUtils.isEmpty(sms.getImageHint())) {
            this.cancelButtonActionPerformed(null);
        }
        String recipient = this.extractRecipient(sms);
        String title = MessageFormat.format(l10n.getString("GatewayImageCodeMessage.securityImage"), recipient);
        ImageIcon icon = ICON;
        this.imageLabel.setIcon(sms.getImage());
        this.imageLabel.setText("<html><i>" + sms.getImageHint() + "</i></html>");
        return this.wrapAsTaskPane(this, title, icon);
    }

    @Override
    public void setBestFocus() {
        this.codeTextField.requestFocusInWindow();
    }

    @Override
    public void cancel() {
        this.cancelButton.doClick(0);
    }

    private void initComponents() {
        this.imageLabel = new JHtmlLabel();
        this.codeTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/missing-image-64.png")));
        this.imageLabel.setHorizontalTextPosition(0);
        this.imageLabel.setVerticalTextPosition(1);
        this.codeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                GatewayImageCodeMessage.this.codeTextFieldKeyReleased(evt);
            }
        });
        this.jLabel2.setLabelFor(this.codeTextField);
        Mnemonics.setLocalizedText(this.jLabel2, l10n.getString("GatewayImageCodeMessage.jLabel2.text"));
        this.buttonPanel.setLayout(new GridLayout(1, 0, 5, 0));
        Mnemonics.setLocalizedText(this.cancelButton, l10n.getString("Cancel_"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GatewayImageCodeMessage.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        Mnemonics.setLocalizedText(this.okButton, l10n.getString("OK_"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GatewayImageCodeMessage.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.imageLabel, -1, 145, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.codeTextField, -1, 50, Short.MAX_VALUE)).addComponent(this.buttonPanel, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.imageLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.codeTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPanel, -2, -1, -2).addContainerGap()));
    }

    private void codeTextFieldKeyReleased(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            this.okButton.doClick(0);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.sms.setImageCode(null);
        this.actionSupport.fireActionPerformed(0, null);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.sms.setImageCode(this.codeTextField.getText());
        this.actionSupport.fireActionPerformed(0, null);
    }
}

