/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JList;
import javax.swing.JPopupMenu;

public class ListPopupMouseListener
extends MouseAdapter {
    protected JList list;
    protected JPopupMenu popup;

    public ListPopupMouseListener(JList list, JPopupMenu popup) {
        if (list == null) {
            throw new IllegalArgumentException("list may not be null");
        }
        this.list = list;
        this.popup = popup;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.maybePopup(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.maybePopup(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int index = this.list.getSelectedIndex();
        if (e.getWheelRotation() >= 0) {
            if (index < this.list.getModel().getSize() - 1) {
                this.list.setSelectedIndex(index + 1);
                this.list.ensureIndexIsVisible(index + 1);
            }
        } else if (index > 0) {
            this.list.setSelectedIndex(index - 1);
            this.list.ensureIndexIsVisible(index - 1);
        }
    }

    protected void maybePopup(MouseEvent e) {
        if (!e.isPopupTrigger() || this.popup == null) {
            return;
        }
        int index = this.list.locationToIndex(e.getPoint());
        if (index >= 0 && !this.list.isSelectedIndex(index)) {
            this.list.setSelectedIndex(index);
        }
        this.popup.show(this.list, e.getX(), e.getY());
    }
}

