/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.watermarkpack;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.InputStream;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceKatakanaWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;
    private static int fontSize = 14;
    private static Font font = SubstanceKatakanaWatermark.getFont();

    private static Font getFont() {
        ClassLoader cl = SubstanceCoreUtilities.getClassLoaderForResources();
        InputStream is = cl.getResourceAsStream("resource/katakana.ttf");
        if (is != null) {
            try {
                Font kf = Font.createFont(0, is);
                int fontSize = 14;
                return kf.deriveFont(1, fontSize);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void drawWatermarkImage(Graphics graphics, Component c, int x, int y, int width, int height) {
        if (!c.isShowing()) {
            return;
        }
        int dx = c.getLocationOnScreen().x;
        int dy = c.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, x, y, x + width, y + height, x + dx, y + dy, x + dx + width, y + dy + height, null);
    }

    public boolean updateWatermarkImage(SubstanceSkin skin) {
        GraphicsDevice[] gds;
        if (font == null) {
            return false;
        }
        Rectangle virtualBounds = new Rectangle();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice gd : gds = ge.getScreenDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            virtualBounds = virtualBounds.union(gc.getBounds());
        }
        int screenWidth = virtualBounds.width;
        int screenHeight = virtualBounds.height;
        watermarkImage = SubstanceCoreUtilities.getBlankImage((int)screenWidth, (int)screenHeight);
        Graphics2D graphics = (Graphics2D)watermarkImage.getGraphics().create();
        boolean status = this.drawWatermarkImage(skin, graphics, 0, 0, screenWidth, screenHeight, false);
        graphics.dispose();
        return status;
    }

    public void previewWatermark(Graphics g, SubstanceSkin skin, int x, int y, int width, int height) {
        this.drawWatermarkImage(skin, (Graphics2D)g, x, y, width, height, true);
    }

    private boolean drawWatermarkImage(SubstanceSkin skin, Graphics2D graphics, int x, int y, int width, int height, boolean isPreview) {
        Color stampColor = null;
        SubstanceColorScheme scheme = skin.getWatermarkColorScheme();
        stampColor = isPreview ? (scheme.isDark() ? Color.white : Color.black) : scheme.getWatermarkStampColor();
        graphics.setColor(stampColor);
        graphics.setFont(font);
        int fontWidth = fontSize;
        int fontHeight = fontSize - 2;
        int rows = height / fontHeight;
        int columns = width / fontWidth;
        for (int col = 0; col <= columns; ++col) {
            for (int row = 0; row <= rows; ++row) {
                int letterIndex = isPreview ? 33 + (col + columns * row) % 95 : (int)(33.0 + Math.random() * 95.0);
                char c = (char)letterIndex;
                graphics.drawString("" + c, x + col * fontWidth, y + fontHeight * (row + 1));
            }
        }
        return true;
    }

    public String getDisplayName() {
        return "Katakana";
    }

    public void dispose() {
        watermarkImage = null;
    }
}

