/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.util.CollectionUtils;
import org.w3c.dom.Element;

public abstract class GoodsLocation
extends UnitLocation {
    private static final Logger logger = Logger.getLogger(GoodsLocation.class.getName());
    private GoodsContainer goodsContainer = null;

    public GoodsLocation(Game game) {
        super(game);
    }

    public GoodsLocation(Game game, Element e) {
        super(game, e);
    }

    public GoodsLocation(Game game, String id) {
        super(game, id);
    }

    public final void setGoodsContainer(GoodsContainer goodsContainer) {
        this.goodsContainer = goodsContainer;
    }

    public final boolean addGoods(AbstractGoods goods) {
        return this.addGoods(goods.getType(), goods.getAmount());
    }

    public final boolean addGoods(List<AbstractGoods> goods) {
        for (AbstractGoods ag : goods) {
            if (this.addGoods(ag)) continue;
            return false;
        }
        return true;
    }

    public final Goods removeGoods(AbstractGoods goods) {
        return this.removeGoods(goods.getType(), goods.getAmount());
    }

    public final Goods removeGoods(GoodsType type) {
        return this.removeGoods(type, this.getGoodsCount(type));
    }

    public final int getGoodsCount(GoodsType type) {
        return this.goodsContainer == null ? 0 : this.goodsContainer.getGoodsCount(type);
    }

    public final boolean containsGoods(List<AbstractGoods> goods) {
        return CollectionUtils.all(goods, ag -> ag.getAmount() <= this.getGoodsCount(ag.getType()));
    }

    public final Iterator<Goods> getGoodsIterator() {
        return this.goodsContainer == null ? null : this.goodsContainer.getGoodsIterator();
    }

    public final List<Goods> getGoods() {
        return this.goodsContainer == null ? Collections.emptyList() : this.goodsContainer.getGoods();
    }

    public final List<Goods> getCompactGoods() {
        return this.goodsContainer == null ? Collections.emptyList() : this.goodsContainer.getCompactGoods();
    }

    @Override
    public boolean add(Locatable locatable) {
        return locatable instanceof Goods ? this.addGoods((Goods)locatable) : super.add(locatable);
    }

    @Override
    public boolean remove(Locatable locatable) {
        return locatable instanceof Goods ? this.removeGoods((Goods)locatable) != null : super.remove(locatable);
    }

    @Override
    public boolean contains(Locatable locatable) {
        return locatable instanceof Goods ? this.goodsContainer.contains((Goods)locatable) : super.contains(locatable);
    }

    @Override
    public final GoodsContainer getGoodsContainer() {
        return this.goodsContainer;
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        if (locatable instanceof Goods) {
            Goods goods = (Goods)locatable;
            if (goods.getSpaceTaken() + (this.goodsContainer == null ? 0 : this.goodsContainer.getSpaceTaken()) > this.getGoodsCapacity()) {
                return UnitLocation.NoAddReason.CAPACITY_EXCEEDED;
            }
            return UnitLocation.NoAddReason.NONE;
        }
        return super.getNoAddReason(locatable);
    }

    public abstract int getGoodsCapacity();

    public boolean addGoods(GoodsType type, int amount) {
        if (this.goodsContainer == null) {
            this.goodsContainer = new GoodsContainer(this.getGame(), this);
        }
        return this.goodsContainer.addGoods(type, amount);
    }

    public Goods removeGoods(GoodsType type, int amount) {
        return this.goodsContainer == null ? null : this.goodsContainer.removeGoods(type, amount);
    }

    @Override
    public List<FreeColGameObject> getDisposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        if (this.goodsContainer != null) {
            objects.addAll(this.goodsContainer.getDisposeList());
        }
        objects.addAll(super.getDisposeList());
        return objects;
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (this.goodsContainer != null) {
            this.goodsContainer.toXML(xw);
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (this.goodsContainer != null) {
            this.goodsContainer.removeAll();
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (GoodsContainer.getXMLElementTagName().equals(tag)) {
            this.goodsContainer = xr.readFreeColGameObject(this.getGame(), GoodsContainer.class);
            this.goodsContainer.setLocation(this);
        } else {
            super.readChild(xr);
        }
    }
}

