/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class Introspector {
    private final Class<?> theClass;
    private final String field;

    public Introspector(Class<?> theClass, String field) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("Field may not be empty");
        }
        this.theClass = theClass;
        this.field = field;
    }

    private Method getGetMethod() {
        String methodName = "get" + this.field.substring(0, 1).toUpperCase() + this.field.substring(1);
        try {
            return this.theClass.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(this.theClass.getName() + "." + methodName, e);
        }
    }

    private Method getSetMethod(Class<?> argType) {
        String methodName = "set" + this.field.substring(0, 1).toUpperCase() + this.field.substring(1);
        try {
            return this.theClass.getMethod(methodName, argType);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(this.theClass.getName() + "." + methodName, e);
        }
    }

    private Class<?> getMethodReturnType(Method method) {
        Class<?> ret;
        try {
            ret = method.getReturnType();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(this.theClass.getName() + "." + method.getName() + " return type.", e);
        }
        return ret;
    }

    private Method getToStringConverter(Class<?> argType) {
        Method method;
        if (argType.isEnum()) {
            try {
                method = argType.getMethod("name", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException(argType.getName() + ".getMethod(name())", e);
            }
        }
        try {
            method = String.class.getMethod("valueOf", argType);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("String.getMethod(valueOf(" + argType.getName() + "))", e);
        }
        return method;
    }

    private Method getFromStringConverter(Class<?> argType) {
        Method method;
        if (argType.isEnum()) {
            try {
                method = Enum.class.getMethod("valueOf", Class.class, String.class);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new IllegalArgumentException("Enum.getMethod(valueOf(Class, String))", e);
            }
        }
        if (argType.isPrimitive()) {
            if (argType == Integer.TYPE) {
                argType = Integer.class;
            } else if (argType == Boolean.TYPE) {
                argType = Boolean.class;
            } else if (argType == Float.TYPE) {
                argType = Float.class;
            } else if (argType == Double.TYPE) {
                argType = Double.class;
            } else if (argType == Character.TYPE) {
                argType = Character.class;
            } else {
                throw new IllegalArgumentException("Need compatible class for primitive " + argType.getName());
            }
        }
        try {
            method = argType.getMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException(argType.getName() + ".getMethod(valueOf(String))", e);
        }
        return method;
    }

    public String getter(Object obj) {
        Method getMethod = this.getGetMethod();
        Class<?> fieldType = this.getMethodReturnType(getMethod);
        if (fieldType == String.class) {
            try {
                return (String)getMethod.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException(getMethod.getName() + "(obj)", e);
            }
        }
        Object result = null;
        try {
            result = getMethod.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(getMethod.getName() + "(obj)", e);
        }
        Method convertMethod = this.getToStringConverter(fieldType);
        if (Modifier.isStatic(convertMethod.getModifiers())) {
            try {
                return (String)convertMethod.invoke(null, result);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException(convertMethod.getName() + "(null, result)", e);
            }
        }
        try {
            return (String)convertMethod.invoke(result, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(convertMethod.getName() + "(result)", e);
        }
    }

    public void setter(Object obj, String value) {
        Method getMethod = this.getGetMethod();
        Class<?> fieldType = this.getMethodReturnType(getMethod);
        Method setMethod = this.getSetMethod(fieldType);
        if (fieldType == String.class) {
            try {
                setMethod.invoke(obj, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException(setMethod.getName() + "(obj, " + value + ")", e);
            }
        }
        Method convertMethod = this.getFromStringConverter(fieldType);
        Object result = null;
        if (fieldType.isEnum()) {
            try {
                result = convertMethod.invoke(null, fieldType, value);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalArgumentException(convertMethod.getName() + "(null, " + fieldType.getName() + ", " + value + ")", e);
            }
        }
        try {
            result = convertMethod.invoke(null, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(convertMethod.getName() + "(null, " + value + ")", e);
        }
        try {
            setMethod.invoke(obj, result);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new IllegalArgumentException(setMethod.getName() + "(result)", e);
        }
    }

    public static Object instantiate(String tag, Class[] types, Object[] params) {
        Object instance;
        Constructor<?> constructor;
        Class<?> messageClass;
        try {
            messageClass = Class.forName(tag);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unable to find class " + tag, e);
        }
        try {
            constructor = messageClass.getDeclaredConstructor(types);
        }
        catch (NoSuchMethodException | SecurityException e) {
            String p = "Unable to find constructor " + tag + "(";
            for (Class type : types) {
                p = p + " " + type;
            }
            p = p + " )";
            throw new IllegalArgumentException(p, e);
        }
        try {
            instance = constructor.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to construct " + tag, e);
        }
        return instance;
    }
}

